/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * This file contains the function prototypes and data structure declarations
 * specific to distribution function of Access Point
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanapDs.h#1 $
 */

#ifndef	__INCwlanApDsh
#define	__INCwlanApDsh

#ifdef __cplusplus
extern "C" {
#endif

/* DS Return Code */
#define DS_DONE	        OK
#define DS_CONT         ERROR

/*
 * data frames FROM WM as 802.11 frame.
 */
void
wlanDsFromWM(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc);

/*
 * data frames from MUX in 802.3/ethernet format.
 */
STATUS
wlanDsFromMux(END_OBJ *pCookie, M_BLK_ID pMBlk);
/*
 * data frames from MUX to the virtual port in 802.3/ethernet format.
 * wlanDsFromMux currently is used when sending to the default virtual 
 * port. In the first cut, the default virtual port is same as the 
 * corresponding physical port ( logically ).
 */
STATUS
vportWdsFromMux(END_OBJ *pCookie, M_BLK_ID pMBlk);

void
vPortWdsRxFn(void *p, ATHEROS_DESC *pDesc);

/*
 * Send Data Frames to a destination thru the next hop specified.
 */
STATUS
wlanTxNextHop(WLAN_DEV_INFO *pdevInfo, M_BLK *pMblk, WLAN_MACADDR *nextHopAddr, SIB_ENTRY *, VPORT_CNTR *pCntr);

#ifdef __cplusplus
}
#endif

#endif /* __INCwlanApDsh */
