/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * This file contains the function prototypes and data structure declarations
 * used for sending beacons.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanbeacon.h#1 $
 */

#ifndef _WLAN_BEACON_H_
#define _WLAN_BEACON_H_

#include "wlantype.h"
#include "wlandrv.h"
#include "wlanframe.h"
#include "wlanproto.h"
#include "wlanchannel.h"

#ifdef __cplusplus
extern "C" {
#endif

#define ELEM_ID_LEN             2       /* Element ID length */
#define TIM_BITMAP_LEN          251
#define POST_TIM_LEN            128     /* cover sizeof(COUNTRY_INFO_LIST) + sizeof(WPA_IE) */

#define DMA_BEACON_RESPONSE_TIME    512 /* 1/2 TU  */
#define SW_BEACON_RESPONSE_TIME   10240 /*  10 TUs */
#define MAX_FRAME_TIME_ON_AIR      3072 /*   3 TUs for max len frame @ 6Mbps */
#define MAX_PENDING_PCU_FRAMES        2 /*   2 frames sitting in the PCU ready to send */
#define ADDITIONAL_SWBA_BACKOFF   (MAX_FRAME_TIME_ON_AIR * MAX_PENDING_PCU_FRAMES)

typedef struct BeaconInfo {
    A_BOOL            beaconEnabled;      /* enable or disable beacon transmission */
    TIM_ELEMENT       *pTim;              /* pointer to the start of TIM in the beacon */
    A_SEM_TYPE        timSemaphoreId;     /* semaphore for TIM */
    A_UINT16          nonTIMLen;          /* Beacon frame length, but w/o TIM */
    A_UINT16          postTIMLen;         /* Beacon frame length after TIM */
    A_UINT16          TIMLen;             /* TIM length */
    A_UINT16          frameLen;           /* Total beacon frame length */
    A_UINT16          missedBeaconCount;  /* AP could not keep up with beacon generation */
    A_UINT32          txBeaconCount;      /* sent out beacon count */
    A_UINT32          wdTxBeaconNum;      /* watchdog's saved  txBeaconCount */
    A_UINT16          calBeaconNum;       /* calibration saved txBEaconCount */
    A_UINT16          calBeaconCount;     /* calibration period in beacon count */
    A_UINT32          bssStartCount;      /* how many times the BSS starts */
    A_UINT32          wdgDelayTicks;      /* beacon watchdog timer delay in ticks */
    A_UCHAR           *pCfPtr;            /* ptr to start of CF element in real beacon */
    A_INT32           timBitsSet;         /* number of STAs having buffered traffic */
    A_UCHAR           timBitmap[TIM_BITMAP_LEN]; /* for keeping track of the entire TIM bitmap */
    A_UCHAR           postTIMBuf[POST_TIM_LEN];  /* for keeping track of the entire TIM bitmap */
} BEACON_INFO;

/* Exported function prototypes */

A_STATUS
wlanApBeaconGen(WLAN_DEV_INFO *pDev);

A_STATUS
wlanBeaconInit(WLAN_DEV_INFO *pDev);

void
wlanBeaconRelease(WLAN_DEV_INFO *pdevInfo);

void
wlanTimUpdate(WLAN_DEV_INFO *pDev, A_UINT16 aid, A_BOOL set);

A_STATUS
wlanBeaconRestore(WLAN_DEV_INFO *pDev);

#ifdef __cplusplus
}
#endif

#endif /* _WLAN_BEACON_H_ */
