/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanext.h#4 $
 *
 * Function prototype declarations for general driver routines
 *
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef __INCwlanexth
#define __INCwlanexth

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "wlansme.h"
#include "wlandrv.h"

INFO_ELEMENT *
mgtElementGet(WLAN_MGT_MAC_HEADER *pmacHdr,
              A_UINT16 frameSize,       /* Size of complete frame */
              A_UINT8  elementId);      /* element ID to search for */

INFO_ELEMENT *
vpMgtElementGet(WLAN_MGT_MAC_HEADER *pmacHdr,
                A_UINT16 frameSize,     /* Size of complete frame */
                const A_UINT8  oui[]);   /* vendor OUI to search for */

void
mgtGetInfoElements(INFO_ELEMENT_SET *pIeSet,
                   INFO_ELEMENT     *ie,         /* pointer to begin of Ies */
                   const A_UINT16   ieLen);      /* size of the information
                                                  elements*/
A_INT32 wlanMACHash(A_UINT32 devno, WLAN_MACADDR *pmacAddr);

/***********************************************************
 * This routine parses an ASCII string that looks like a standard
 * ethernet mac address like nnnnnnnnnnnn or nn:nn:nn:nn:nn:nn or
 * '.' or '-' instead of ':'. It is flexible about single digit
 * values too. It places resulting 6 bytes address in pmac.
 *
 * RETURNS: FALSE if conversion failed, TRUE if it succeeds
 */
A_BOOL
asciiToMacaddr(A_UCHAR *pstr,           // Input string, not null terminated
               A_UINT16 alen,           // input length
               WLAN_MACADDR *pmac);     // pointer to resulting mac address

A_BOOL bitMapAllocEntry(A_UINT16 *bitMap, A_UINT8 *bitPos);
A_BOOL bitMapFreeEntry(A_UINT16 *bitMap, A_UINT8 bitPos);
/***********************************************************
 * This routine finds the hash table index for WDS tables
 * keyed off the MAC Address.
 */

A_INT32 wlanWdsMacHash(A_UINT32 devno, WLAN_MACADDR *pMacAddr, A_UINT32 maxEntries);

/***********************************************************
 * This routine parses an ASCII string of hex digits
 * and converts them into a byte array of corresponding values.
 * It also updates key length field.
 *
 * RETURNS: FALSE if conversion failed, TRUE if it succeeds
 */
A_BOOL
asciiToKey(A_UCHAR *pstr,               // Input string, not null terminated
           A_UINT16 alen,               // length of input string
           WLAN_PRIV_RECORD *pKey,
           A_INT32 keylen,             // length of desired hardware key in bytes
           A_INT32 encryptedKeyLen);   // length of returned key

A_BOOL
asciiToPassphraseKey(A_UCHAR *pstr,     // Null terminated input string
           A_UINT8 *pPpKey,
           int     encryptedKeyLen);    // length of returned key

A_BOOL
asciiToMacAddr(A_UCHAR *hexStr, WLAN_MACADDR *pMacAddr);

A_BOOL
asciiHexToChar(A_UCHAR *hexStr, A_UINT16 hexStrLen, A_UINT8 *pOut);

A_BOOL
asciiToPasswd(A_UCHAR *hexString, A_UINT16 hexStrLen, A_UINT8 *pOut,
              A_UINT16 outLen);

/* Parses the regAdd.txt file for hex pairs that act as register writes */
A_BOOL
parseRegLine(A_CHAR *pChar, A_UINT32 *offset, A_UINT *value);

A_BOOL
convertHexToU32(A_CHAR *hexStr, A_UINT32 *hexVal, A_CHAR **hexStrEnd);

/* sibTableInit - Initialize the SIBtable at system initialization stage */
A_STATUS sibTableInit(SIB_TABLE *pMySibTable, A_UINT32 sibTableSize);

A_STATUS sibTableExit(SIB_TABLE *pMySibTable);

A_STATUS
sibFreeTargetConn(WLAN_DEV_INFO *pDevInfo, SIB_TABLE *pSibTable);

/* sibEntryFind - find the entry which has matched macAddres */
SIB_ENTRY *sibEntryFind(WLAN_DEV_INFO *pDevInfo, WLAN_MACADDR *macAddr, struct OpBss *pOpBss);
#ifdef UPSD
SIB_ENTRY *sibEntryFindLocked(WLAN_DEV_INFO *pDevInfo, WLAN_MACADDR *macAddr, struct OpBss *pOpBss);
#endif

/* sibEntryGet - get the entry which is indexed */
SIB_ENTRY *sibEntryGet(A_UINT32 entryIndex);

/* sibEntryDel - delete (invalidate) the sibEntry from the table */
A_STATUS sibEntryDel(WLAN_DEV_INFO *pDev, SIB_ENTRY *sibEntry);

/* sibEntryAge*() - age out the SIB entry */
void sibEntryAge(WLAN_DEV_INFO *pDev, SIB_ENTRY *sibEntry);

A_BOOL sibEntryAgeCheck(SIB_ENTRY *sibEntry, A_UINT32 aging_period_ms);

/* psStateReset() -- reset state of given SIB */
void psStateReset(WLAN_DEV_INFO *pDev, SIB_ENTRY* pSib, COMPLETION_ENUM complete);

/* sibTableStateReset() -- reset state of all SIBs in SIB table */
void sibTableStateReset(WLAN_DEV_INFO *pDev, COMPLETION_ENUM complete);

/* staRoamNotify() -- Notify SME code that sta has roamed away */
void staRoamNotify(WLAN_DEV_INFO *pdevInfo, OP_BSS *pOpBss, L2_UPDATE_FRAME *pDestAddr);

/* sibEntryAlloc - Allocate a SIB entry from sibTable. */
SIB_ENTRY *
sibEntryAlloc(WLAN_DEV_INFO *pDev, WLAN_MACADDR *macAddr, struct OpBss *pOpBss);

/* sibEntryAdd - add a entry to the SIBTable */
A_STATUS sibEntryAdd(SIB_ENTRY *sibEntry);

SIB_ENTRY *sibTblFind(A_UINT32 staId);

WLAN_DEV_INFO *sib2DevInfo(SIB_ENTRY *pSib);

/*
 * macACLFind - Look-up priv entry for mac in mac ACL hash table.
 * macACLUpdate - Store WEP info about mac in mac ACL hash table.
 * macACLCheck - Return if mac address is allowed and updates pKey.
 */
MACACL_ENTRY *macACLFind(WLAN_MACADDR *mac);
void         macACLUpdate(WLAN_MACADDR *mac, A_UINT32 flags, A_UINT32 key);
A_BOOL       macACLCheck(WLAN_DEV_INFO *pDev, WLAN_MACADDR *pAddr, SIB_ENTRY *pSib);

/*
 * Privacy related routines
 *
 *   wlanKeyTableInit   - Initialize the encryption key table and cache.
 *   wlanKeyTableFree   - Free software resources allocated in wlanKeyTableInit.
 *   wlanKeyTableAdd    - Add or update an entry to the key table.
 *   wlanKeyTableRemove - Remove an entry from the key table (and cache).
 *   wlanKeyEnable      - Add instance of key @ keyTableIndex for pSib.
 *   wlanKeyFree        - Remove dynamic key table entry and clean-up key cache.
 *   wlanKeyCacheSet    - Add the key for pSib to the HW cache.
 *   wlanKeyCacheFault  - Ensure a SIB specific key is in the key cache.
 *   wlanKeyCacheFree   - Remove entry from sw cache and hw cache.
 *
 *   Blowfish_Init      - Initialize WEP key encryption structure
 *   Blowfish_Encrypt   - Encrypt WEP key
 *   Blowfish_Decrypt   - Decrypt WEP key
 */

A_BOOL
isKeyTableSlotEmpty(WLAN_PRIV_RECORD *pKey);

A_STATUS
wlanKeyTableInit(WLAN_DEV_INFO *pDev, A_UINT16 nstatic,
                 A_UINT16 ndynamic);
void
wlanKeyTableFree(WLAN_DEV_INFO *pDev);

WLAN_PRIV_RECORD *
wlanKeyTableAdd(WLAN_DEV_INFO   *pDev,
                A_UINT16        keyIndex,
                A_UINT32        keyType,
                A_UINT32        keyLength,      /* in bits */
                A_UINT8         *keyValue);

void
keyMask(A_UINT8 *, A_UINT8 *, A_UINT8, A_INT32);

A_BOOL
wlanKeyTableAddDynamic(WLAN_DEV_INFO    *pDev,
                       SIB_ENTRY        *pSib,
                       A_UINT32         keyType,
                       A_UINT32         keyLength,      /* in bits */
                       A_UINT8          *keyValue);

void
wlanKeyEnable(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib, A_UINT16 keyTableIndex);
void
wlanKeyTableRemove(WLAN_DEV_INFO *pDev, A_UINT16 keyIndex);
void
wlanKeyTableRemoveDynamic(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pKey);
void
wlanKeyFree(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib);

A_UINT16
wlanKeyCacheSet(WLAN_DEV_INFO    *pDev,
                SIB_ENTRY        *pSib,
                WLAN_MACADDR     *pmacAddr,
                WLAN_PRIV_RECORD *pKey);

A_UINT16 wlanKeyCacheFault(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib, A_BOOL *faulted);
void     wlanKeyCacheFree(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib);
void     wlanKeyCacheKeyFree(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pDelKey);
void     wlanKeyCacheFreeAll(WLAN_DEV_INFO *pDev);
A_STATUS wlanKeyUpdate(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib, A_UINT32 context);
A_STATUS wlanKeyUpdateSingle(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib,
                             A_UINT32 context, A_UINT16 keyIndexx,
                             A_UINT32 cipher);
A_UINT16 wlanKeyMcGet(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib, A_UINT8 *buf, A_INT32 *len);
void     wlanKeyAuthTypeSet(WLAN_STA_CONFIG *pConfig, WLAN_AUTH_TYPE authType);
A_STATUS wlanReplayCheck(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pkey,
                         ATHEROS_DESC *pDesc);

void
wlanKeyInvalidateAll(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pKeyInval);

void
wlanKeyTableSlotFree(WLAN_PRIV_RECORD *);

void
wlanKeyCacheDecompMaskClear(WLAN_DEV_INFO *pDevInfo, WLAN_PRIV_RECORD *pKey);

A_STATUS
wlanKeyTableSet(WLAN_DEV_INFO *pdevInfo, SIB_ENTRY *pSib,
                A_BOOL connectionKey, A_UINT32 cipher,
                A_UINT16 keyIndex,
                A_UINT32 keyLength, A_UINT8 *keyValue);

void
wlanInstallConnectionKey(WLAN_DEV_INFO *pDevInfo, SIB_ENTRY *pSib,
                         WLAN_MACADDR *pBssId, WLAN_PRIV_RECORD *pKey);

void
wlanDeleteConnectionKey(WLAN_DEV_INFO *pDevInfo, SIB_ENTRY *pSib,
                        WLAN_PRIV_RECORD *pKey);

void
wlanInstallBssKey(WLAN_DEV_INFO *pDevInfo,
                  A_UINT32 bssKeyIdx, A_UINT32 isDefaultBssKey,
                  WLAN_PRIV_RECORD *pKey);

void
wlanDeleteBssKey(WLAN_DEV_INFO *pDevInfo, A_UINT32 bssKeyIdx,
                 WLAN_PRIV_RECORD *pKey);

#define CONTEXT_NONE    0x00
#define CONTEXT_DOT1X   0x01

void
wpaElementsToWpaIe(UCSE_SET *pUcseSet,
                   MCSE_SET *pMcseSet,
                   AUTHSE_SET *pAuthSet,
                   A_UINT16 wpaCap,
                   WPA_IE *pWpaIe);

A_STATUS
wpaIeToWpaElements(WPA_IE *pWpaIe,
                   UCSE_SET *pUcseSet,
                   MCSE_SET *pMcseSet,
                   AUTHSE_SET *pAuthSet,
                   A_UINT16 *pWpaCap);

void wlanKeyPrivateDataDestroy(WLAN_PRIV_RECORD *pKey);

void
hmac_md5(unsigned char* text, int text_len, unsigned char* key, int key_len, unsigned char *digest);

#ifndef BUILD_AP
void processWEPKeys(WLAN_DEV_INFO *pDev);

void Blowfish_Init(BLOWFISH_CTX *ctx, unsigned char *key, int keyLen);
void Blowfish_Encrypt(BLOWFISH_CTX *ctx, unsigned long *xl, unsigned long *xr);
void Blowfish_Decrypt(BLOWFISH_CTX *ctx, unsigned long *xl, unsigned long *xr);
#endif


A_STATUS initCipher(WLAN_DEV_INFO *pDevInfo);

A_STATUS setupDecrypt(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc);
A_STATUS swEnCipher(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pPriv, ATHEROS_DESC *pDesc);
A_STATUS swDeCipher(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pPriv, ATHEROS_DESC *pDesc);
void     setupSwEncryption(WLAN_DEV_INFO *pDev);

void wlanReleaseKeyTableData(WLAN_DEV_INFO *);

A_UINT16 ieSetLengthFind(A_UINT8 *);

/**************************************************************************
 * descQInit - initialize the data structure corresponding to a descriptor
 *  queue
 *
 * RETURNS: status or failure
 */
A_STATUS
descQInit(QUEUE_DETAILS *pQueue);

/* descQGetHead - Get pointer to first descriptor on the queue, don't remove it
 *
 * DESCRIPTION:
 * Returns a pointer to first descriptor on the queue. Doesn't remove it from
 * the queue. Used by the interrupt handler or polling routines to look at the
 * first descriptor on tx or rx queue. Those routines will call descQRemove
 * only if the descr is done.
 *
 * RETURNS: pointer to first descriptor on the queue
 */
ATHEROS_DESC *
descQGetHead(QUEUE_DETAILS *pQueue);

/* descQGetTail - Get pointer to last descriptor on the queue, don't remove it
 *
 * DESCRIPTION:
 * Returns a pointer to last descriptor on the queue. Doesn't remove it from
 * the queue.
 * RETURNS: pointer to last descriptor on the queue
 */
ATHEROS_DESC *
descQGetTail(QUEUE_DETAILS *pQueue);

/**************************************************************************
* descQPopHead - remove the descriptor from the start of queue
*
* Removes and then deletes the descriptor from the head of the queue.
* Sets the new head of the queue to the next descriptor
*
* RETURNS: pointer to descriptor at head of the queue
*/
ATHEROS_DESC *
descQPopHead(QUEUE_DETAILS *pQueue);

/**************************************************************************
* getPktFromQueueStart - get a packet from the start of queue
*
* Removes the packet's descriptor chain from the head of the queue.
* Sets the new head of the queue to the next packet's descriptor chain
*
* RETURNS: Pointer to the descriptor chain of the packet if successful
*          NULL if failed
*/
ATHEROS_DESC *
getPktFromQueueStart(QUEUE_DETAILS *pQueue);

/**************************************************************************
* getPktFromQueue - get the given packet from within the queue
*
* Removes the packet's descriptor chain from where ever its in
* the queue
*
* RETURNS: Pointer to the descriptor chain of the packet if successful
*          NULL if failed
*/
ATHEROS_DESC *
getPktFromQueue(QUEUE_DETAILS *pQueue, ATHEROS_DESC *pDesc);

/**************************************************************************
* descQPushTail - add the descriptor(s) to the tail of queue struct
*
* Adds the given descriptor chain to the tail of the queue structure
*
* RETURNS: N/A
*/
void
descQPushTail(QUEUE_DETAILS *pQueue, ATHEROS_DESC *pDesc, ATHEROS_DESC *pTail);

/**************************************************************************
* descQPushHead - add the descriptor to the head of queue struct
*                 (non-conventional!)
*
* RETURNS: N/A
*/
void
descQPushHead(QUEUE_DETAILS *pQueue, ATHEROS_DESC *pDesc);

/**************************************************************************
 * memAllocateDescriptor - allocate a descriptor from the descriptor pool
 *
 * This routine will get a single ATHEROS descriptor from the descriptor pool
 *
 * RETURNS: N/A
 */
ATHEROS_DESC *
memAllocateDescriptor(WLAN_DEV_INFO *pDev);

/**************************************************************************
* memFreeDescriptor - free a descriptor
*
* This routine will free a descriptor that was already created by
* memAllocateDescriptor()
*
* RETURNS: N/A
*/
void
memFreeDescriptor(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc);

#ifdef BUILD_AP
/**************************************************************************
* createHeaderBuffandDesc - create a physically contiguous buffer
*                           and descriptor for 802.11 header
*
* Create a physically contiguous data buffer and a descriptor
* to go with it.  An ATHEROS_DESC gets returned, pointer to data buffer
* can be assertained from the descriptor
*
* RETURNS: ATHEROS_DESC if successful, NULL otherwise
*/
ATHEROS_DESC *
createHeaderBuffandDesc(WLAN_DEV_INFO *pDev, A_UINT16 buffSize);

#define CREATE_HEADER_BUFF_AND_DESC(_pDev, _hdrlen, _ppDesc)    \
    ( ((*(_ppDesc)) = createHeaderBuffandDesc(_pDev, _hdrlen)) ? A_OK : A_NO_MEMORY )
#else
#define CREATE_HEADER_BUFF_AND_DESC(_pDev, _hdrlen, _ppDesc)    \
    createBuffandDesc(_pDev, _hdrlen, _ppDesc)
#endif

/**************************************************************************
* createBuffandDesc - create a physically contiguous buffer and descriptor
*
* Create a physically contiguous data buffer and create a descriptor
* to go with it.  An ATHEROS_DESC gets returned, pointer to data buffer
* can be assertained from the descriptor
*
* RETURNS: A_OK if successful, A_ERROR otherwise
*/
A_STATUS
createBuffandDesc(WLAN_DEV_INFO *pDev, A_UINT16 buffSize, ATHEROS_DESC **ppDesc);

/**************************************************************************
* freeBuffandDesc - free buffer and descriptor
*
* Free the buffer and descriptor, created with createBuffandDesc()
*
* RETURNS: N/A
*/
void
freeBuffandDesc(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc);

/**************************************************************************
* freeBuffandDescChain - free buffer and descriptor chain
*
* Free the buffer and descriptor chain, created with createBuffandDesc()
*
* RETURNS: N/A
*/
void
freeBuffandDescChain(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc);

/* Macros that call endian conversion routine
 * Atheros device and 802.11 frame contents are little endian.
 */
#ifdef BIG_ENDIAN
#define LE2CPU  0   /* for rx */
#define CPU2LE  1   /* for tx */
void cryptoEndianChange(WLAN_FRAME_HEADER *pFrame, int direction);
void mgtFrameEndianChange(WLAN_MGT_MAC_HEADER *pFrame, A_UINT16 len, int direction);

#else
#define cryptoEndianChange(_pFrame, _direction)
#define mgtFrameEndianChange(_pFrame, _len, _direction)
#endif

#ifdef BUILD_AP

void   apReboot(void);
void   apHalt(void);
STATUS apCservStart(WLAN_DEV_INFO *);
A_BOOL isApShutdown(void);
int    enterDebugger(void);

void   chipReset(WLAN_DEV_INFO *, CHAN_VALUES *, A_BOOL);
STATUS beaconWdgCancel(WLAN_DEV_INFO *);

void   cliUptimeGet(char *p);
int    strtoWlanMAC(char *macstr, WLAN_MACADDR *mac);
void   sibSmeShow(int);
void   sibStationShow(int, int);
void   sibCipherShow(SIB_ENTRY *);
char   *authTypeGet(int);
ATHEROS_DESC *
dataFrameCreate(WLAN_DEV_INFO *pdevInfo, A_UINT32 fSubType,
                SIB_ENTRY *pSibEntry, A_BOOL isWds);

#endif /* BUILD_AP */
A_UINT32 staTxRateKbpsGet(WLAN_DEV_INFO *pDevInfo, SIB_ENTRY *pSib);
A_UINT32 staTxRateGet(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib);
A_UINT32 staRxRateGet(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib);
void     staTxRateSet(WLAN_DEV_INFO *pDev, A_UINT16 rateKbps);
A_UINT8  staRateValueToIndex(A_UINT32 txRateKbps, SIB_ENTRY *pSib);
A_UINT8  staGetSigQuality(A_UINT8 txRate, SIB_ENTRY *pSib);

/*
 * Higher level functions
 */

void wlanFrameReceive(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc);

#ifndef BUILD_AP

A_STATUS powerInitialization(WLAN_DEV_INFO *pDev);
A_STATUS powerSet(WLAN_DEV_INFO *pDev, PWR_MGMT_EVENT_TYPE event, A_UINT32 value,
                  A_BOOL notifyAP, void (*callBack)());
A_BOOL   powerEnabled(WLAN_DEV_INFO *pDev);
A_STATUS powerSendRequest(WLAN_DEV_INFO *pDev);
void     powerMgtPoll(WLAN_DEV_INFO *pDev);
void     powerReceiveIndication(WLAN_DEV_INFO *pDev);
void     powerTimIndication(WLAN_DEV_INFO *pDev, A_BOOL isDirected, A_BOOL isMc);
void     powerCabDone(WLAN_DEV_INFO *pDevInfo);
A_STATUS powerSendMgtFrame(WLAN_DEV_INFO *pDev, A_BOOL PowerMgt);
A_BOOL   powerTxIndication(WLAN_DEV_INFO *pdev, A_BOOL pktTransmitOK, ATHEROS_DESC *pDesc);
A_STATUS powerPSPollInit(WLAN_DEV_INFO *pDev);
void     powerPSPollFree(WLAN_DEV_INFO *pDev);
void     powerHwResetNotify(WLAN_DEV_INFO *pDev);
void     powerSleepHangCheck(WLAN_DEV_INFO *pDev);
void     powerSetResyncToBeacon(WLAN_DEV_INFO *pDev);

/* LEAP Support */
void leapAssocCallback(WLAN_DEV_INFO *pDevInfo, SIB_ENTRY *pSib);
void leapAuthCallback(WLAN_DEV_INFO *pDevInfo, WLAN_MACADDR *peer,
                      MLME_RESULT code);
#else /* BUILD_AP */

#define  powerSet(pDev, event, value, notifyAp, callback)
#define  powerEnabled(pDev)         TRUE
#define  powerTimIndication(pDev, isDirected, isMc)
#define  powerHwResetNotify(pDev)
#define  osIndicateConnectStatus(pDev, connectStatus)
#define  osIndicateResourcesAvailable(pDev)
#define  leapAssocCallback(pDevInfo, pSib)
#define  leapAuthCallback(pDevInfo, peer, code)
A_STATUS apCservNotify(struct wlanDevInfo *pdevInfo);

#endif /* BUILD_AP */

/* 802.1X support */
A_STATUS dot1xInit(void);
void     eapPortMsg(WLAN_DEV_INFO *pDev, WLAN_MACADDR *pAddr, A_UINT8 op); // TODO: if no longer used, why still here?
A_BOOL   isEapolFrame(WLAN_DEV_INFO *pDev, A_UINT8 *llc);

int
micErrorProcess(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc,
                MIC_ERROR_TYPE error);

#ifdef DEBUG
void ipDecode(WLAN_DEV_INFO *, ATHEROS_DESC *, A_BOOL);
#else
#define ipDecode(x, y, z)
#endif /* DEBUG */

void deriveBroadcastKey(WLAN_DEV_INFO *pdevInfo, A_UINT16, char *bcKeyBuf, int len);
void keyCounterInit(WLAN_DEV_INFO *pDevInfo);
void GNonceCalc(int unit);
void GMKGenerate(int unit);
A_STATUS rogueListAdd(WLAN_DEV_INFO *pDev, WLAN_MACADDR *rogue, A_UINT16 failureCode);

void wpaIeEndianChangeEle(WPA_IE *pWpaIe, int direction);

void athWmeIeGetInfo(WLAN_DEV_INFO *, OP_BSS *pOpBss, ATH_WME_PARAM_IE *pAthWmeIe);
INFO_ELEMENT *athWmeIeGenerate(WLAN_DEV_INFO *, OP_BSS *pOpBss, INFO_ELEMENT *pElement);

#ifdef WME
void wmeV1IeGetInfo(WLAN_DEV_INFO *, OP_BSS *pOpBss, WMEv1_PARAM_IE *pWmeV1Ie);
INFO_ELEMENT *wmeV1IeGenerate(WLAN_DEV_INFO *, OP_BSS *pOpBss, INFO_ELEMENT *pElement);
INFO_ELEMENT *wmeV1ShortIeGenerate(WLAN_DEV_INFO *, INFO_ELEMENT *pElement);
#define wmeV1IeLength(_pDev)                                   \
    (((_pDev)->staConfig.WmeEnabled)                 \
    ? (A_UINT8)FIELD_OFFSET(WMEv1_PARAM_IE, info.ac[ACI_MAX])  \
    : 0)

#define wmeV1ShortIeLength(_pDev)                                   \
    (((_pDev)->staConfig.WmeEnabled)                 \
    ? (A_UINT8)FIELD_OFFSET(WMEv1_PARAM_IE, info._pad)  \
    : 0)

#endif

#define athWmeIeLength(_pDev)                                   \
    (((_pDev)->staConfig.abolt & ABOLT_WME_ELE)                 \
    ? (A_UINT8)FIELD_OFFSET(ATH_WME_PARAM_IE, info.ac[ACI_BK])  \
    : 0)

/* Radio control/status support */
A_STATUS athDrvRadioEnable(WLAN_DEV_INFO *pDevInfo, A_BOOL *enableRequester);
A_STATUS athDrvRadioDisable(WLAN_DEV_INFO *pDevInfo, A_BOOL *enableRequester);
A_BOOL   athDrvRadioStatus(WLAN_DEV_INFO *pDevInfo, A_BOOL checkSwitch);

/* GPIO support */
A_STATUS initGPIO(WLAN_DEV_INFO *pDevInfo);
A_STATUS initGpioFunc0(WLAN_DEV_INFO *pDevInfo);
A_STATUS gpioFunc0(WLAN_DEV_INFO *pDevInfo, A_BOOL flag);
A_STATUS initGpioFunc1(WLAN_DEV_INFO *pDevInfo);
A_STATUS gpioFunc1(WLAN_DEV_INFO *pDevInfo, A_BOOL flag);

#ifdef BUILD_AP
#define ckip_internal_init()
#define ckip_init(pk)
#define ckip_close(pk)
#define ckip_setkey(pk)
#define ckip_encipher(pk, pkt, pktlen)
#define ckip_decipher(pk, pkt, pktlen)
#define ckip_enmic(pk, pkt, pktlen)
#define ckip_demic(pk, pkt, pktlen, src, dest)

#else
void     ckip_internal_init(void);          // init subsystem
int      ckip_init(WLAN_PRIV_RECORD *pk);   // init a session
void     ckip_close(WLAN_PRIV_RECORD *pk);  // close a session
int      ckip_setkey(WLAN_PRIV_RECORD *pk);
int      ckip_encipher(WLAN_PRIV_RECORD *pk, A_UINT8 *pkt, int pktlen);  // encrypt + mic
int      ckip_decipher(WLAN_PRIV_RECORD *pk, A_UINT8 *pkt, int pktlen);  // decrypt
A_STATUS ckip_enmic(WLAN_PRIV_RECORD *pk, A_UINT8 *pkt, int pktlen);
int      ckip_demic(WLAN_PRIV_RECORD *pk, A_UINT8 *pkt, int pktlen, WLAN_MACADDR *src, WLAN_MACADDR *dest);
#endif /* BUILD_AP */

A_STATUS
swEnmic(WLAN_DEV_INFO *pDev, WLAN_PRIV_RECORD *pKey, ATHEROS_DESC **ppDesc);

A_STATUS
swDemic(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc, WLAN_MACADDR *src, WLAN_MACADDR *dest, void *qosInfo);

void
keyPrivateInit(WLAN_PRIV_RECORD *pKey);

void
frameIVSetup(WLAN_DEV_INFO *pDevInfo, WLAN_PRIV_RECORD *pKey,
             WLAN_FRAME_HEADER *pHdr);

A_STATUS
rxKeyLookup(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc);

void
hmac_sha1(unsigned char *text, int text_len,
          unsigned char *key, int key_len,
          unsigned char *digest);

#define SHA1HashSize 20

void
PRF(unsigned char *key, int key_len,
    unsigned char *prefix, int prefix_len,
    unsigned char *data, int data_len,
    unsigned char *output, int len);

void printKey(unsigned char *key, int len);

#ifdef __cplusplus
}
#endif

#endif // __INCwlanexth
