/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

/*
 * fragde.h - fragmentation/de-fragmentation function prototypes
 *            and data structures
 */

#ifndef __INCwlanFragDe
#define __INCwlanFragDe

#ifdef __cplusplus
extern "C" {
#endif

#include "wlanproto.h"

#define dot11FRAGMENTATION_THRESHOLD    2346
#define dot11MaxReceiveLifeTime         512

struct wlanDevInfo;
struct atherosDesc;

/* function prototypes */

struct atherosDesc *wlanFrag(struct wlanDevInfo *pdevInfo, struct atherosDesc *pDesc);


/*******************************************************************
* Defragmentation support sorts
*******************************************************************/
/* The PartialSdu structure is for INCOMPLETE MSDUs/MMPDUs */
/* (generically SDUs) for which at least 1 fragment has been */
/* received. Unfragmented SDUs are reported upward immediately, */
/* and are never stored in instances of this structure. */

typedef struct PartialDesc {
    A_BOOL       inUse; /* =true if this instance holds any fragments */
    WLAN_MACADDR *rta;  /* transmitting station (Addr2) */
    A_UINT16     rsn;   /* sequence number */
    A_UINT16     rCur;  /* fragment number of most recent Mpdu */
    A_UINT16     pduLen;        /* partial frame body length */
    A_UINT16     hdrLen;        /* header length */
    A_UINT32     timeStamp;     /* timestamp @ 1st Mpdu */
    struct atherosDesc *pDesc;  /* descriptors where Mpdus are concatenated */
                                /* default (. false, nullAddr, 0, 0, 0, null .); */
} PARTIAL_DESC;

/* Number of entries in defragmentation array at this station. */
/* The value is implementation dependent (min=3, see 9.5). */
#define DEFRAG_ENTRIES_DEFAULT  3
#define DEFRAG_ENTRIES_MAX      32

/* de-fragmentation function prototype */

struct atherosDesc *wlanDeFrag(struct wlanDevInfo *pdevInfo, struct atherosDesc *pFragDesc);

#ifdef __cplusplus
}
#endif

#endif /* __INCwlanFragDe */
