/*
 *  Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * wlanframe.h - function declarations and macros to operate on 802.11 frames
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanframe.h#1 $
 */

#ifndef	__INCwlanFrameh
#define	__INCwlanFrameh

A_UINT16 lengthGet(ATHEROS_DESC *pDesc);
A_UINT16 headerLengthGet(ATHEROS_DESC *);
A_UINT16 ivLengthGet(ATHEROS_DESC *);
A_UINT16 icvLengthGet(WLAN_PRIV_RECORD *);

#define isFrag(header) \
    (((header)->frameControl.moreFrag == 1) || \
     ((header)->sequenceControl.fragNo != 0))
#define moreFragGet(desc) \
    ((desc)->pBufferVirtPtr.header->frameControl.moreFrag)
#define fragNumGet(desc) \
    WLAN_GET_FRAGNUM((desc)->pBufferVirtPtr.header->seqControl)
#define seqNumGet(desc) \
    WLAN_GET_SEQNUM((desc)->pBufferVirtPtr.header->seqControl)
#define isGrp(macaddr) \
    ((A_BOOL)((macaddr)->octets[0] & 0x01))
#define isBcast(macaddr) \
    (((macaddr)->octets[0] == 0xff))

#endif /* __INCwlanFrameh */
