/*
 *  Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * wlanmib.h - MLME/PLME MIB Attribute Declarations
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __INCwlanmibh
#define __INCwlanmibh

#ifdef VXWORKS
#include "wlantype.h"
#include "wlanproto.h"
#include "mibleaf.h"
#endif /* #ifdef VXWORKS */

#define MANUFACTURER_NAME       "Cisco Systems, Inc."
#define PRODUCT_NAME            "Cisco Aironet 802.11a/b/g Wireless Adapter"
#define RTID_NAME               "RTID"

#ifdef VXWORKS
/* the redefinition will provide portability for SNMP moduale */

#define LEAF_dot11StationConfigEntry                    0x100
#define LEAF_dot11SMEOperationEntry                     0x200
#define LEAF_dot11PrivacyEntry                          0x300
#define LEAF_dot11IdentificationEntry                   0x400
#define LEAF_dot11OperationEntry                        0x500
#define LEAF_dot11CountersEntry                         0x600

/* Dot11StationConfigEntry */
#define MIB_dot11StationID                      LEAF_dot11StationConfigEntry | LEAF_dot11StationID
#define MIB_dot11DesiredSSID                    LEAF_dot11StationConfigEntry | LEAF_dot11DesiredSSID
#define MIB_dot11DesiredBSSType                 LEAF_dot11StationConfigEntry | LEAF_dot11DesiredBSSType
#define MIB_dot11BeaconPeriod                   LEAF_dot11StationConfigEntry | LEAF_dot11BeaconPeriod
#define MIB_dot11DTIMPeriod                     LEAF_dot11StationConfigEntry | LEAF_dot11DTIMPeriod
#define MIB_dot11PrivacyOptionImplemented       LEAF_dot11StationConfigEntry | LEAF_dot11PrivacyOptionImplemented
#define MIB_dot11OperationalRateSet             LEAF_dot11StationConfigEntry | LEAF_dot11OperationalRateSet

/* dot11SMEOperationEntry */
#define MIB_dot11DisassociateReason             LEAF_dot11SMEOperationEntry | LEAF_dot11DisassociateReason
#define MIB_dot11DisassociateStation            LEAF_dot11SMEOperationEntry | LEAF_dot11DisassociateStation
#define MIB_dot11DeauthenticateReason           LEAF_dot11SMEOperationEntry | LEAF_dot11DeauthenticateReason
#define MIB_dot11DeauthenticateStation          LEAF_dot11SMEOperationEntry | LEAF_dot11DeauthenticateStation
#define MIB_dot11AuthenticateFailStatus         LEAF_dot11SMEOperationEntry | LEAF_dot11AuthenticateFailStatus
#define MIB_dot11AuthenticateFailStation        LEAF_dot11SMEOperationEntry | LEAF_dot11AuthenticateFailStation

/* dot11PrivacyEntry */
#define MIB_dot11PrivacyInvoked                 LEAF_dot11PrivacyEntry | LEAF_dot11PrivacyInvoked
#define MIB_dot11WEPDefaultKeyID                LEAF_dot11PrivacyEntry | LEAF_dot11WEPDefaultKeyID
#define MIB_dot11WEPKeyMappingLength            LEAF_dot11PrivacyEntry | LEAF_dot11WEPKeyMappingLength
#define MIB_dot11ExcludeUnencrypted             LEAF_dot11PrivacyEntry | LEAF_dot11ExcludeUnencrypted
#define MIB_dot11WEPICVErrorCount               LEAF_dot11PrivacyEntry | LEAF_dot11WEPICVErrorCount
#define MIB_dot11WEPExcludedCount               LEAF_dot11PrivacyEntry | LEAF_dot11WEPExcludedCount

/* dot11IdentificationEntry */
#define MIB_dot11ManufacturerID                 LEAF_dot11IdentificationEntry | LEAF_dot11ManufacturerID
#define MIB_dot11ProductID                      LEAF_dot11IdentificationEntry | LEAF_dot11ProductID
#define MIB_dot11ResourceTypeIDName             LEAF_dot11IdentificationEntry | LEAF_dot11ResourceTypeIDName
#define MIB_dot11manufacturerOUI                LEAF_dot11IdentificationEntry | LEAF_dot11manufacturerOUI
#define MIB_dot11manufacturerName               LEAF_dot11IdentificationEntry | LEAF_dot11manufacturerName
#define MIB_dot11manufacturerProductVersion     LEAF_dot11IdentificationEntry | LEAF_dot11manufacturerProductVersion

/* dot11OperationsEntry */
#define MIB_dot11MACAddress                     LEAF_dot11OperationEntry | LEAF_dot11MACAddress
#define MIB_dot11RTSThreshold                   LEAF_dot11OperationEntry | LEAF_dot11RTSThreshold
#define MIB_dot11ShortRetryLimit                LEAF_dot11OperationEntry | LEAF_dot11ShortRetryLimit
#define MIB_dot11LongRetryLimit                 LEAF_dot11OperationEntry | LEAF_dot11LongRetryLimit
#define MIB_dot11FragmentationThreshold         LEAF_dot11OperationEntry | LEAF_dot11FragmentationThreshold
#define MIB_dot11MaxTransmitMSDULifetime        LEAF_dot11OperationEntry | LEAF_dot11MaxTransmitMSDULifetime
#define MIB_dot11MaxReceiveLifetime             LEAF_dot11OperationEntry | LEAF_dot11MaxReceiveLifetime

/* dot11CountersEntry */
#define MIB_dot11TransmittedFragmentCount       LEAF_dot11CountersEntry | LEAF_dot11TransmittedFragmentCount
#define MIB_dot11MulticastTransmittedFrameCount LEAF_dot11CountersEntry | LEAF_dot11MulticastTransmittedFrameCount
#define MIB_dot11FailedCount                    LEAF_dot11CountersEntry | LEAF_dot11FailedCount
#define MIB_dot11RetryCount                     LEAF_dot11CountersEntry | LEAF_dot11RetryCount
#define MIB_dot11MultipleRetryCount             LEAF_dot11CountersEntry | LEAF_dot11MultipleRetryCount
#define MIB_dot11FrameDuplicateCount            LEAF_dot11CountersEntry | LEAF_dot11FrameDuplicateCount
#define MIB_dot11RTSSuccessCount                LEAF_dot11CountersEntry | LEAF_dot11RTSSuccessCount
#define MIB_dot11RTSFailureCount                LEAF_dot11CountersEntry | LEAF_dot11RTSFailureCount
#define MIB_dot11ACKFailureCount                LEAF_dot11CountersEntry | LEAF_dot11ACKFailureCount
#define MIB_dot11ReceivedFragmentCount          LEAF_dot11CountersEntry | LEAF_dot11ReceivedFragmentCount
#define MIB_dot11MulticastReceivedFrameCount    LEAF_dot11CountersEntry | LEAF_dot11MulticastReceivedFrameCount
#define MIB_dot11FCSErrorCount                  LEAF_dot11CountersEntry | LEAF_dot11FCSErrorCount
#define MIB_dot11TransmittedFrameCount          LEAF_dot11CountersEntry | LEAF_dot11TransmittedFrameCount
#define MIB_dot11WEPUndecryptableCount          LEAF_dot11CountersEntry | LEAF_dot11WEPUndecryptableCount


/* data structure definition */
typedef struct Dot11StationConfigEntry
{
    WLAN_MACADDR        dot11StationID[SIZE_dot11StationID];
    A_UCHAR             dot11DesiredSSID[MAXSIZE_dot11DesiredSSID];
    A_UINT32            dot11DesiredBSSType;
    A_UINT32            dot11BeaconPeriod;
    A_UINT32            dot11DTIMPeriod;
    A_BOOL              dot11PrivacyOptionImplemented;
    A_UINT8             dot11OperationalRateSet[MAXSIZE_dot11OperationalRateSet];
    A_UINT32            dot11AuthenticationAlgorithm;
    A_BOOL              dot11MultiDomainCapabilityImplemented;
    A_BOOL              dot11MultiDomainCapabilityEnabled;
    A_UCHAR             dot11CountryString[4];
} STRUCT_dot11StationConfigEntry;

typedef struct Dot11SMEOperationEntry
{
    A_UINT32            dot11DisassociateReason;
    WLAN_MACADDR        dot11DisassociateStation[SIZE_dot11DisassociateStation];
    A_UINT32            dot11DeauthenticateReason;
    WLAN_MACADDR        dot11DeauthenticateStation[SIZE_dot11DeauthenticateStation];
    A_UINT32            dot11AuthenticateFailStatus;
    WLAN_MACADDR        dot11AuthenticateFailStation[SIZE_dot11AuthenticateFailStation];
} STRUCT_dot11SMEOperationEntry;

typedef struct Dot11AuthenticationAlgorithmsEntry
{
    A_UINT32            dot11AuthenticationAlgorithmsIndex;
    A_UINT32            dot11AuthenticationAlgorithm;
    A_BOOL              dot11AuthenticationAlgorithmsEnable;
} STRUCT_dot11AuthenticationAlgorithmsEntry;

#define WEP_KEY_TYPE_SIZE 5

typedef struct WEPKeytype
{
    A_UINT8     octets[WEP_KEY_TYPE_SIZE]; /* wep key type is 5 octets */
} WEP_KEY_TYPE;

typedef struct Dot11WEPDefaultKeysEntry
{
    A_UINT32            dot11WEPDefaultKeyIndex;
    WEP_KEY_TYPE        dot11WEPDefaultKeyValue;
} STRUCT_dot11WEPDefaultKeysEntry;

typedef struct Dot11WEPKeyMappingsEntry
{
    A_UINT32            dot11WEPKeyMappingIndex;
    WLAN_MACADDR        dot11WEPKeyMappingAddress;
    A_BOOL              dot11WEPKeyMappingWEPOn;
    WEP_KEY_TYPE        dot11WEPKeyMappingValue;
    A_UINT32            dot11WEPKeyMappingStatus;
} STRUCT_dot11WEPKeyMappingsEntry;

typedef struct Dot11PrivacyEntry
{
    A_BOOL              dot11PrivacyInvoked;
    A_UINT32            dot11WEPDefaultKeyID;
    A_UINT32            dot11WEPKeyMappingLength;
    A_BOOL              dot11ExcludeUnencrypted;
    A_UINT32            dot11WEPICVErrorCount;
    A_UINT32            dot11WEPExcludedCount;

} STRUCT_dot11PrivacyEntry;

typedef struct Dot11ResourceInfoEntry
{
    A_CHAR              dot11manufacturerOUI[SIZE_dot11manufacturerOUI];
    A_CHAR              dot11manufacturerName[MAXSIZE_dot11manufacturerName];
    A_CHAR              dot11manufacturerProductName[MAXSIZE_dot11manufacturerProductName];
    A_CHAR              dot11manufacturerProductVersion[MAXSIZE_dot11manufacturerProductVersion];
} STRUCT_dot11ResourceInfoEntry;

typedef struct Dot11IdentificationEntry
{
    WLAN_MACADDR        dot11MACAddress[SIZE_dot11MACAddress];
    A_CHAR              dot11ManufacturerID[MAXSIZE_dot11ManufacturerID];
    A_CHAR              dot11ProductID[MAXSIZE_dot11ProductID];
    A_CHAR              dot11ResourceTypeIDName[SIZE_dot11ResourceTypeIDName];
    STRUCT_dot11ResourceInfoEntry       dot11ResourceInfoTable[2];
} STRUCT_dot11IdentificationEntry;

typedef struct Dot11OperationEntry
{
    A_UINT32            dot11RTSThreshold;
    A_UINT32            dot11ShortRetryLimit;
    A_UINT32            dot11LongRetryLimit;
    A_UINT32            dot11FragmentationThreshold;
    A_UINT32            dot11MaxTransmitMSDULifetime;
    A_UINT32            dot11MaxReceiveLifetime;
} STRUCT_dot11OperationEntry;

typedef struct Dot11CountersEntry
{
    A_UINT32            dot11TransmittedFragmentCount;
    A_UINT32            dot11MulticastTransmittedFrameCount;
    A_UINT32            dot11FailedCount;
    A_UINT32            dot11RetryCount;
    A_UINT32            dot11MultipleRetryCount;
    A_UINT32            dot11FrameDuplicateCount;
    A_UINT32            dot11RTSSuccessCount;
    A_UINT32            dot11RTSFailureCount;
    A_UINT32            dot11ACKFailureCount;
    A_UINT32            dot11ReceivedFragmentCount;
    A_UINT32            dot11MulticastReceivedFrameCount;
    A_UINT32            dot11FCSErrorCount;
    A_UINT32            dot11TransmittedFrameCount;
    A_UINT32            dot11WEPUndecryptableCount;
} STRUCT_dot11CountersEntry;

typedef struct Dot11PhyAntennaEntry
{
    A_UINT32            dot11CurrentTxAntenna;
    A_UINT32            dot11DiversitySupport;
    A_UINT32            dot11CurrentRxAntenna;
} STRUCT_dot11PhyAntennaEntry;

typedef struct Dot11PhyOperationEntry
{
    A_UINT32            dot11CurrentChannel;
    A_UINT32            dot11CurrentTxRate;
    A_BOOL              dot11TurboModeEnabled;
} STRUCT_dot11PhyOperationEntry;


typedef struct Dot11GroupAddressesEntry
{
    A_UINT32            dot11GroupAddressesIndex;
    WLAN_MACADDR        dot11Address;
    A_UINT32            dot11GroupAddressesStatus;
} STRUCT_dot11GroupAddressesEntry;

typedef struct Dot11resAttribute
{
    A_UCHAR             dot11ResourceTypeIDName;
} STRUCT_dot11resAttribute;

#endif /* #ifndef VXWORKS */

#endif /* #ifndef __INCwlanmibh */

#ifdef __cplusplus
}
#endif
