/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlansme.h#1 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * MLME/SME function prototypes and data structures
 * See also wlansmeext.h.
 */

#ifndef _WLANSME_H_
#define _WLANSME_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "wlantype.h"
#include "wlanproto.h"
#include "wlanPhy.h"

/* Defaults for some station parameters */
#define DEFAULT_ADHOC_BEACON_INTERVAL   100
#define DEFAULT_AP_BEACON_INTERVAL      100
#define DEFAULT_DTIM_PERIOD             1

#ifdef BUILD_AP
#define BSSDESCR_SET_SIZE 64
#else
#define BSSDESCR_SET_SIZE 128
#endif

/* Macros */

/*
 * Following macro is used to determine effective size
 * of info element. Used for allocating space for element.
 */
#define INFO_ELEMENT_SIZE(e) (((e).length > 0) ? (e).length + 2 : 0)

/* Enumerated types */

typedef enum {
    MLME_SUCCESS,
    MLME_INVALID_PARAM,
    MLME_NOT_SUPPORTED,
    MLME_TOOMANY_REQ,
    MLME_TIMEOUT,
    MLME_REFUSED,
    MLME_ALREADY_IN_BSS,
    MLME_DRIVER_ERROR,      /* Errors not in the MLME RESULT CODE */
    MLME_OP_PENDING
} MLME_RESULT;

typedef enum {
    ACTIVE_SCAN,
    PASSIVE_SCAN,
    ANY_SCAN
} SCANTYPE;

typedef enum {
    INVALID_TIMEOUT,
    MLME_AUTH_TIMEOUT,
    MLME_ASSOC_TIMEOUT,
    MLME_JOIN_TIMEOUT,
    MLME_SCAN_TIMEOUT,
    MLME_BEACON_TIMEOUT,
    MLME_PWRMGT_TIMEOUT,
    MLME_REASSOC_TIMEOUT
} TIMEOUTTYPE;

/* Internal driver rate set */
#define MAX_WLAN_RATE_SIZE  32
typedef struct WlanRateSet {
    A_UINT8     length;                     /* Length field */
    A_UINT8     rates[MAX_WLAN_RATE_SIZE];  /* Rates array of octets */
} WLAN_RATE_SET;

/*
 * BSS description structure. Each set is a max size element.
 * This will be a fixed size data structure to accomodate all sets
 * at their max sizes. It is used in Scan, Start operations.
 * Length field in each set
 */
typedef struct BSSDescription {
    struct channelValues *pChannel;
    WIRELESS_MODE        opMode;
    COUNTRY_INFO_LIST    ccList;        /* Country code element */
    BSSID                bssId;
    SSID                 ssid;
    BSSTYPE              bsstype;
    A_UINT16             beaconInterval;
    A_UINT8              DTIMPeriod;
    WLAN_TIMESTAMP       timestamp;
    DS_PARAM_SET         dsParamSet;
    CF_PARAM_SET         cfParamSet;
    IBSS_PARAM_SET       ibssParamSet;
    CAP_INFO             capabilityInfo;
    WPA_IE               wpaIe;
    A_BOOL               ckipEnabled;
    A_BOOL               ckipUseMic;
    TPC_IE               tpcIe;
    UCSE_SET             bssUcseSet;
    MCSE_SET             bssMcseSet;
    AUTHSE_SET           bssAuthSet;
    A_UINT32             rssi;
    A_UINT32             rssiAdder;     /* Used to enable preference of certain BSSes */
    A_UINT32             scanTime;      /* Time when beacon/probe received, used for aging */
#define BAD_AP   0x01
#define AP_RETRY 0x10
    A_CHAR               apState;       /* valid values 0-3 */
    A_UINT32             badAPTimeout;
    A_BOOL               probeResp;     /* Info from a probe response */
    int                  rank;          /* This ranking is used to determine the scanning order */
    NONERP_ELEMENT       nonErpElement; /* non ERP element */
    WLAN_RATE_SET        supportedRateSet;
    RATE_SET             rateSetIe;     /* copy of rate set element from beacon */
    EXT_RATE_SET         extRateSetIe;  /* copy of extended rate set element from beacon */
    ATH_ADVCAP_IE        athAdvCapElement;
    ATH_WME_PARAM_IE     athWmeIe;
#ifdef WME
    WMEv1_PARAM_IE       wmeV1Ie;
#endif
    A_UINT32             ccxApAddr;
    A_UCHAR              ccxApName[16];
    A_BOOL               isCiscoAp;
} BSSDESCR;

typedef struct BSSDescriptionSet {
    A_UINT16    count;                            /* No. of BSS description items in the set */
    A_CHAR      setIdx;                           /* index in the bss set */
    BSSDESCR    bssDescrArray[BSSDESCR_SET_SIZE]; /* Array of BSS description items */
} BSSDESCR_SET;

typedef struct SsidArray {
    A_ATOMIC     count;
    A_ATOMIC     numValid;
#define SSID_ARRAY_SIZE 32
    SSID        elements[SSID_ARRAY_SIZE];
} SSID_ARRAY;

#ifdef __cplusplus
}
#endif

#endif /* _WLANSME_H_ */
