/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlansmeext.h#2 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * MLME/SME function prototypes
 */

#ifndef _WLANSMEEXT_H_
#define _WLANSMEEXT_H_

#include "wlantype.h"
#include "wlanproto.h"
#include "wlansme.h"
#include "wlandrv.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Debugging facility (crude)
 *
 * This is exported for now as some AP files use it.  We should move to a system
 * where each subsystem contains its own debugging trace facility based off of
 * a some generic, common facility.
 */
#ifdef DEBUG

extern int mlmeDebugLevel;
extern int rxDebugLevel;
extern int txDebugLevel;

#define mlmePrintf            if (mlmeDebugLevel) uiPrintf
#define mlmePrintMacAddress   if (mlmeDebugLevel) printMacAddress
#define mlmePrintSsid         if (mlmeDebugLevel) printSsid
#define mlmePrintFlags        if (mlmeDebugLevel) wlanPrintFlags

#define mlmeL2Printf          if (mlmeDebugLevel == 2) uiPrintf
#define mlmeL2PrintMacAddress if (mlmeDebugLevel == 2) printMacAddress
#define mlmeL2PrintSsid       if (mlmeDebugLevel == 2) printSsid
#define mlmeL2PrintFlags      if (mlmeDebugLevel == 2) wlanPrintFlags

#define rxPrintf              if (rxDebugLevel) uiPrintf
#define rx2Printf             if (rxDebugLevel == 2) uiPrintf
#define rxPrintMacAddress     if (rxDebugLevel) printMacAddress
#define rxPrintSsid           if (rxDebugLevel) printSsid
#define rxPrintFlags          if (rxDebugLevel) wlanPrintFlags

#define txPrintf              if (txDebugLevel) uiPrintf
#define tx2Printf             if (txDebugLevel == 2) uiPrintf
#define txPrintMacAddress     if (txDebugLevel) printMacAddress
#define txPrintSsid           if (txDebugLevel) printSsid
#define txPrintFlags          if (txDebugLevel) wlanPrintFlags

#else /* DEBUG */

#define mlmeDebugLevel      0
#define rxDebugLevel        0
#define txDebugLevel        0

#ifdef VXWORKS
#define mlmePrintf(vargs...)
#define mlmePrintMacAddress(vargs...)
#define mlmePrintSsid(vargs...)
#define mlmePrintFlags(vargs...)

#define mlmeL2Printf(vargs...)
#define mlmeL2PrintMacAddress(vargs...)
#define mlmeL2PrintSsid(vargs...)
#define mlmeL2PrintFlags(vargs...)

#define rxPrintf(vargs...)
#define rx2Printf(vargs...)
#define rxPrintMacAddress(vargs...)
#define rxPrintSsid(vargs...)
#define rxPrintFlags(vargs...)

#define txPrintf(vargs...)
#define tx2Printf(vargs...)
#define txPrintMacAddress(vargs...)
#define txPrintSsid(vargs...)
#define txPrintFlags(vargs...)
#else
#define mlmePrintf(...)
#define mlmePrintMacAddress(...)
#define mlmePrintSsid(...)
#define mlmePrintFlags(...)

#define mlmeL2Printf(...)
#define mlmeL2PrintMacAddress(...)
#define mlmeL2PrintSsid(...)
#define mlmeL2PrintFlags(...)

#define rxPrintf(...)
#define rx2Printf(...)
#define rxPrintMacAddress(...)
#define rxPrintSsid(...)
#define rxPrintFlags(...)

#define txPrintf(...)
#define tx2Printf(...)
#define txPrintMacAddress(...)
#define txPrintSsid(...)
#define txPrintFlags(...)
#endif

#endif /* DEBUG */

/*
 * Global data structure maintained by MLME to hold its
 * static information.
 */
typedef struct smeInfoStruct {
    WLAN_SERVICE serviceType; /* WLAN_STA_SERVICE, WLAN_AP_SERVICE */
    void     (*authCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, A_UINT16, MLME_RESULT);
    void     (*authIndicationCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, A_UINT16);
    void     (*deauthCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, MLME_RESULT);
    void     (*deauthIndicationCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, MLME_RESULT);
    void     (*assocCallback)(WLAN_DEV_INFO *, MLME_RESULT);
    void     (*assocIndicationCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *);
    void     (*reassocCallback)(WLAN_DEV_INFO *, MLME_RESULT);
    void     (*reassocIndicationCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *);
    void     (*disassocCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, MLME_RESULT);
    void     (*disassocIndicationCallback)(WLAN_DEV_INFO *, WLAN_MACADDR *, MLME_RESULT);
    void     (*pwrMgtCallback)(WLAN_DEV_INFO *, A_STATUS, A_BOOL);
    void     (*scanCallback)(WLAN_DEV_INFO *, BSSDESCR_SET *, MLME_RESULT, A_BOOL, A_BOOL);
    void     (*joinCallback) (WLAN_DEV_INFO *, MLME_RESULT);
    void     (*startCallback) (WLAN_DEV_INFO *, MLME_RESULT);
    void     (*resetCallback)(WLAN_DEV_INFO *);
} SME_INFO_STRUCT;

#ifndef BUILD_AP
extern SME_INFO_STRUCT staSmeInfo;
#define apSmeInfo staSmeInfo;
#else 
extern SME_INFO_STRUCT staSmeInfo, apSmeInfo;
#endif

MLME_RESULT
wlanMlmePwrmgtRequest(WLAN_DEV_INFO *pdevInfo, A_UINT16 powermgtMode, A_BOOL wakeup);

typedef enum {
    SF_ADVANCE_NOW,
    SF_DONT_ADVANCE_NOW,
    SF_INVALID
} SF_ENUM;

void
mlmeScanFunction(WLAN_DEV_INFO *pdevInfo, SF_ENUM mode);

MLME_RESULT
wlanMlmeScanRequest(
    WLAN_DEV_INFO   *pdevInfo,
    BSSTYPE         bsstype,        /* Infra., indep. or any */
    BSSID           *bssid,         /* Specific MAC or broadcast addr */
    SSID_ARRAY      *ssid,          /* ESS identifier or NULL */
    SCANTYPE        scantype,       /* active or passive */
    WLAN_SCAN_LIST  *pScanList,     /* list of chennels to scan */
    A_UINT32        minActiveTime,  /* min waiting time on active channel */
    A_UINT32        maxActiveTime,  /* max waiting time on active channel */
    A_UINT32        minPassiveTime, /* min waiting time on passive channel */
    A_UINT32        maxPassiveTime, /* max waiting time on passive channel */
    A_BOOL          isTempScan);

A_BOOL
wlanMlmeScanDone(WLAN_DEV_INFO *pDev, A_BOOL cancelAll);

MLME_RESULT
wlanMlmeJoinRequest(WLAN_DEV_INFO *pDev, BSSDESCR *pBss, A_UINT32 timeout);

MLME_RESULT
wlanMlmeProbeRequest(WLAN_DEV_INFO *pdevInfo, WLAN_MACADDR *bssid, SSID *ssid);

MLME_RESULT
wlanMlmeAuthRequest(
    WLAN_DEV_INFO *pdevInfo,
    WLAN_MACADDR  *pPeerSTAAddress,    /* Address of other STA */
    A_UINT16      authType,            /* open systems or shared key */
    A_UINT32      authFailureTimeout); /* timeout in TU */

MLME_RESULT
wlanMlmeDeauthRequest(
    WLAN_DEV_INFO *pdevInfo,
    OP_BSS        *pOpBss,
    WLAN_MACADDR  *pPeerSTAAddress,
    A_UINT16      reasonCode,
    A_BOOL        sendFrame);

MLME_RESULT
wlanMlmeAssocRequest(
    WLAN_DEV_INFO *pdevInfo,
    WLAN_MACADDR  *pPeerSTAAddress,
    A_UINT32      assocFailureTimeout,
    CAP_INFO      *capabilityInfo,
    A_UINT16      listenInterval);

MLME_RESULT
wlanMlmeReassocRequest(
    WLAN_DEV_INFO *pdevInfo,
    WLAN_MACADDR  *pPeerSTAAddress,
    A_UINT32      reassocFailureTimeout,
    CAP_INFO      *capabilityInfo,
    A_UINT16      listenInterval);

MLME_RESULT
wlanMlmeDisassocRequest(
    WLAN_DEV_INFO *pdevInfo,
    OP_BSS        *pOpBss,
    WLAN_MACADDR  *pDestAddr,
    A_UINT16      reasonCode,
    A_BOOL        sendFrame);

A_UINT16
mlmeAssocIdNew(WLAN_DEV_INFO *pdevInfo, OP_BSS *pOpBss);

void
mlmeAssocIdRelease(WLAN_DEV_INFO *pdevInfo, OP_BSS *pOpBss, A_UINT16 assocId);

void
wlanResetRequest(WLAN_DEV_INFO *pDev, SEND_DEAUTH_ENUM sendDeauth);

MLME_RESULT
wlanMlmeStartRequest(WLAN_DEV_INFO *pdevInfo, BSSDESCR *pbssDescr);

MLME_RESULT
wlanMlmeStartConfirm(WLAN_DEV_INFO *pdevInfo, MLME_RESULT resultCode);

MLME_RESULT
wlanMlmeInit(WLAN_DEV_INFO *pdevInfo, SME_INFO_STRUCT *psmeInfo);

void
wlanMlmeFree(WLAN_DEV_INFO *pdevInfo);

void
initializeSme(WLAN_DEV_INFO *pdevInfo, A_UINT32 service);

void
mlmeMgtTxCompletion(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc);

void
mlmeMgtRxCompletion(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc);

/* Used by other pieces of our driver */

A_BOOL
basicRateSubsetCheck(WLAN_RATE_SET *psub, WLAN_RATE_SET *psuper);

void
wlanFullToRateSet(WLAN_RATE_SET *pShadowRateSet, RATE_SET *pRateSet, A_BOOL draft5);

void
wlanFullToExtRateSet(WLAN_RATE_SET *pShadowRateSet, EXT_RATE_SET *pExtRateSet, A_BOOL draft5);

void
wlanRateSetCopy(WLAN_RATE_SET *pSrc, WLAN_RATE_SET *pDest);

A_BOOL
phyRateSubSetCheck(WLAN_DEV_INFO *pDev, WIRELESS_MODE mode,
                   WLAN_RATE_SET *pRateSet, WLAN_PHY type);
void
sibDecompStateSet(WLAN_DEV_INFO *pDev, SIB_ENTRY *pSib, A_BOOL decomp);

void
mlmeBsssetAdd(WLAN_DEV_INFO *, BSSDESCR *src, BSSDESCR_SET *dest);

void
mlmeBsssetAge(BSSDESCR_SET *src, A_UINT32 agingPeriod, BSSID *pBssidToKeep);

BSSDESCR *
mlmeBsssetFind(BSSDESCR_SET *pSet, WLAN_MACADDR *pAddr, A_UINT16 channelFlags);

void
mlmeBsssetDel(BSSDESCR_SET *pSet, WLAN_MACADDR *pAddr);

A_BOOL
mlmeBsssetIsFull(BSSDESCR_SET *);
    
INFO_ELEMENT *
mlmeElementCopy(INFO_ELEMENT *pSrc, INFO_ELEMENT *pDest);

void
mlmeOperationCancel(WLAN_DEV_INFO *pDev);

A_STATUS
drvHwReset(WLAN_DEV_INFO *pdevInfo, CHAN_VALUES *pChval, A_BOOL keepRCContent);

A_STATUS
drvChangeChannel(WLAN_DEV_INFO *pdevInfo, CHAN_VALUES *channel, A_BOOL force, A_BOOL keepRCContent);

void
turboPrimeSwitch(WLAN_DEV_INFO *pdevInfo, A_UINT8 en);

void
mlmeCountryCodeElementFill(WLAN_DEV_INFO *pDevInfo, COUNTRY_INFO_LIST *pCountryInfo);

A_BOOL
isNullSsid(SSID *pSsid);

void
ssidArrayAdd(SSID_ARRAY *pArray, A_CHAR *buf, A_UINT8 length);

void
ssidArrayInit(SSID_ARRAY *pArray);

A_BOOL
isSsidEqual(SSID *s1, SSID *s2);

A_INT32
ssidArrayFind(SSID_ARRAY *pArray, SSID *pSsid);

void
mlmePoll(WLAN_DEV_INFO *pDev);

void
updtSupFeatureInfo(WLAN_DEV_INFO *pDev, WIRELESS_MODE mode);

void
wlanRateSet2WdcRateSet(WLAN_RATE_SET *pRateSet, CONN_RATE_SET *pConnRateSet );

#ifdef __cplusplus
}
#endif

#endif /* _WLANSMEEXT_H_ */


