/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/xr.h#1 $
 *
 * This file contains the function prototypes, helpful macros and data
 * structure declarations specific to the transmit functions.  It is the
 * same for both the station and access point.
 *
 * Copyright  2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 */

#ifndef _XR_H_
#define _XR_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * values supplied by HW design - should be
 * considered to be part of the XR spec!
 */
#define XR_SLOT_DELAY                   30      // 30usec
#define XR_DATA_DETECT_DELAY            40      // 40usec
#define XR_CHIRP_DUR                    24      // 24usec

#define XR_AIFS                         0
#define XR_LOG_CWMIN                    2
#define XR_LOG_CWMAX                    3

#define XR_MAX_FRAME_SIZE               AR_BUF_SIZE

/*
 * Parameters biasing the XR BSS to be a second
 * rate citizen
 */
#define XR_DNLINK_QUEUE_AIFS_SHIFT      7
#define XR_DNLINK_QUEUE_CWMIN_SHIFT     4
#define XR_BEACON_FACTOR                4
#define XR_DEFAULT_RATE                 500    // 500Kb/s

/*
 * CTS protection frame is needed to protect from other stations in
 * the normal BSS - so it needs to go out at the multicast rate for
 * the normal BSS - both for XR mode and maybe 'g' mode operation
 */
#define XR_CTS_RATE(_pDev)                                  \
(                                                           \
    (_pDev)->baseBss.pRateTable->info[                      \
        (_pDev)->baseBss.pRateTable->info[                  \
            (_pDev)->baseBss.defaultRateIndex               \
        ].controlRate                                       \
    ].rateCode                                              \
)

/*
 * Should account for sifs + grp poll time + max backoff
 * time at the station + uplink XR data frame + sifs +
 * downlink XR ack
 */
#define XR_UPLINK_TRANSACTION_TIME(_pDev)                   \
(                                                           \
    PHY_COMPUTE_TX_TIME(                                    \
        (_pDev)->xrBss.pRateTable,                          \
        sizeof(WLAN_DATA_MAC_HEADER3) + FCS_FIELD_SIZE,     \
        (_pDev)->xrBss.defaultRateIndex, 0                  \
    )                                                       \
    + ((XR_AIFS + LOG_TO_CW(XR_LOG_CWMIN)) * XR_SLOT_DELAY) \
    + PHY_COMPUTE_TX_TIME(                                  \
        (_pDev)->xrBss.pRateTable,                          \
        XR_MAX_FRAME_SIZE,                                  \
        (_pDev)->xrBss.defaultRateIndex, 0                  \
    )                                                       \
    + PHY_COMPUTE_TX_TIME(                                  \
        (_pDev)->xrBss.pRateTable,                          \
        WLAN_CTRL_FRAME_SIZE,                               \
        (_pDev)->xrBss.defaultRateIndex, 0                  \
    )                                                       \
)

#define XR_HACKERY                      1
#define XR_HACKERY_MACADDR              0x9999  /* Define it to be byte order agnostic */

/* commenting the following out will turn on XR support */
#undef  XR_HACKERY

#if defined(BUILD_AP) && defined(XR_HACKERY)
#define isXrAp(_pDev)                   ((_pDev)->hwRateTable[WIRELESS_MODE_XR])
#else
#define isXrAp(_pDev)                   FALSE
#endif

#define _OCTET(_pBssId)                 ((_pBssId)->octets[1])
#define _OCTET_MASK                     0x80

#define isXrBssSib(_pDevInfo, _pSib)    ((_pSib)->pOpBss == &((_pDevInfo)->xrBss))
#define setXrBssIdMask(_pBssId)         do { _OCTET(_pBssId) ^= _OCTET_MASK; } while (0)
#if _OCTET_MASK
#define isXrBssRxFrame(_pDev, _pHdr)    (isXrAp(_pDev) && (_OCTET(&(_pHdr)->address1) == _OCTET(&(_pDev)->xrBss.bssId)))
#else
#define isXrBssRxFrame(_pDev, _pHdr)    (isXrAp(_pDev) && ((_pHdr)->address2.st.half == XR_HACKERY_MACADDR))
#endif

#ifdef __cplusplus
}
#endif

#endif /* _XR_H_ */
