/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/sta/init.c#2 $
 *
 * some high level init code for NDIS driver
 *
 * Copyright  2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * Sample Code from Microsoft Windows 2000 Driver Development Kit is
 * used under license from Microsoft Corporation and was developed for
 * Microsoft by Intel Corp., Hillsboro, Oregon: Copyright (c) 1994-1997
 * by Intel Corporation.
 */

#include "wlantype.h"
#include "wlandrv.h"
#include "wlanext.h"
#ifdef Linux
#include "linuxext.h"
#endif
#include "usbstub.h"


//-----------------------------------------------------------------------------
// Procedure:   SetupSharedAdapterMemory
//
// Description: This routine is responsible for the allocation of the
//                              data structures inside the Adapter structure.
//
// Arguments:
//      Adapter - the adapter structure to allocate for.
//
// Returns:
//      NDIS_STATUS_SUCCESS     - If the shared memory structures were setup
//      not NDIS_STATUS_SUCCESS - If not enough memory or map registers could be
//                                allocated
//-----------------------------------------------------------------------------
NDIS_STATUS
SetupSharedAdapterMemory(IN OUT WLAN_DEV_INFO *pDevInfo)
{
    PUCHAR                      MemP;
    ULONG                       CbPhys;
    NDIS_STATUS                 Status;
    if (hwAllocateDescMemory(pDevInfo, (A_UINT16)(NUM_DESCS * DESC_SIZE)) != A_OK) {
        uiPrintf("hwAllocateDescMemory failed\n");
        return NDIS_STATUS_RESOURCES;
    }

    if (hwAllocateBufMemory(pDevInfo, 0) != A_OK) { // size parameter is ignored anyway
        uiPrintf("hwAllocateBufMemory failed\n");
        return NDIS_STATUS_RESOURCES;
    }

    return NDIS_STATUS_SUCCESS;
}


