/*
 * Copyright (c) 2002, Atheros Communications Inc.
 */
/* $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/sta/leap.h#3 $ */

#ifndef __DRV_LEAP_H
#define __DRV_LEAP_H

#ifdef WIN32
#pragma pack (push, 1)
#endif

/* State labels */
enum {
    ST_INITIALIZE = 0,
    ST_ASSOC,
    ST_IDENT_REQ,
    ST_LEAP_CHALLENGE,
    ST_EAP_SUCCESS,
    ST_LEAP_CHALL_RESP,
    ST_EAPOL_KEYMSG,
};

/* Challenge frame format */
typedef struct LeapChallenge {
    A_UINT8     version;
    A_UINT8     unused;
    A_UINT8     length;
    A_UINT8     random[LEAP_CHALLENGE_LEN];
#define LEAP_CHALLENGE_HDRLEN           (3+LEAP_CHALLENGE_LEN)
    A_UINT8     user[1]; // variable length
} __ATTRIB_PACK LEAP_CHALLENGE;

/* Challenge response frame format */
typedef struct LeapChallResp {
    A_UINT8     version;
#define LEAP_VERSION                    1
    A_UINT8     unused;
    A_UINT8     length;
    A_UINT8     response[LEAP_CHALLRESP_LEN];
#define LEAP_CHALLRESP_HDRLEN           (3+LEAP_CHALLRESP_LEN)
    A_UINT8     user[1]; // variable length
} __ATTRIB_PACK LEAP_CHALLRESP;

#define DDP_FAILCODE_INVALALG    0x0001 /* Invalid auth algorithm */
#define DDP_FAILCODE_AUTHTIMEOUT 0x0002 /* Auth timeout */
#define DDP_FAILCODE_CHALLFROMAP 0x0003 /* Challenge from AP failed */
#define DDP_FAILCODE_CHALLTOAP   0x0004 /* Challeng eto AP failed */

#ifdef WIN32
#pragma pack (pop)
#endif

#endif /* __DRV_LEAP_H */
