/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/sta/linuxbuf.c#3 $
 *
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 * conversion between NDIS packets and Atheros descriptors functions
 *
 * Sample Code from Microsoft Windows 2000 Driver Development Kit is
 * used under license from Microsoft Corporation and was developed for
 * Microsoft by Intel Corp., Hillsboro, Oregon: Copyright (c) 1994-1997
 * by Intel Corporation.
 */

/* Linux equivalent of bufconv.c */

#include "wlandrv.h"
#include "wlanext.h"
#include "wlanCapDe.h"
#include "equates.h"

#define MAX_PHYS_DESC 16

/*******************************************************************************
 *
 * RETURNS:      NULL if unsuccesful
 *               pointer of Atheros Descriptors if successful
 */
ATHEROS_DESC *
osPacketToAthDesc(WLAN_DEV_INFO *pDevInfo, void *pOsPacket,A_STATUS * status)
{
    PNDIS_PACKET    pPacket=(PNDIS_PACKET)pOsPacket; /* NDIS packet pointer */
    ATHEROS_DESC    *pDesc;

    (* status) = A_OK;

	/* There is no need to copy the payload, just allocate a descriptor and
     * attach the data; Make sure that we store the buffer info somewhere
     * so that the OS allocated buffer is freed by us at some point in 
     * time the driver feels appropriate */
    pDesc = memAllocateDescriptor(pDevInfo);
    if (pDesc == NULL) {
        (* status) = A_ERROR;
        return NULL;
    } 
    
    /* We have an Ath descriptor, physical address is already in it. */
    pDesc->bufferPhysPtr      = 0;
    pDesc->pBufferVirtPtr.ptr = pPacket->data;
    pDesc->OSspecificInfo = -1;
    pDesc->OSbuffer       = pPacket; 
    pDesc->pOSHandle      = pPacket; 
    
    pDesc->more         = 0;
    pDesc->frameLength  = pPacket->len;
    pDesc->bufferLength = pPacket->len;

    return pDesc;
}

#define OS_ALLOCATE_BUFF(pSkb, pDesc, pDevInfo, Align)                         \
do {                                                                           \
    struct net_device *pNetDevice = NULL;                                      \
    pSkb = dev_alloc_skb(pDesc->bufferLength + Align);                         \
    if (pSkb == NULL) {                                                        \
        goto SkbFree;                                                          \
    }                                                                          \
    pNetDevice = pDevInfo->pOSHandle->NicAdapterHandle;                        \
    pSkb->dev = pNetDevice;                                                    \
    if (Align) skb_reserve(pSkb, Align);                                       \
    eth_copy_and_sum(pSkb, pDesc->pBufferVirtPtr.ptr, pDesc->bufferLength, 0); \
    skb_put(pSkb, pDesc->bufferLength);                                        \
    pSkb->protocol = eth_type_trans(pSkb, pNetDevice);                         \
}while(0)

/*
 * The only reason we show up with more than one descriptor/buffer
 * per packet is if it is a scattered fast frame! scattered fragments
 * are coalesced in the defrag code now!! For the scattered fast frame
 * we don't really have buffer space in the first desc/buffer to copy
 * the rest of the desc/buffer chain to.. So lets not attempt to
 * coalesce scattered buffers anymore
 */
void *
athDescToOsPacket(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc)
{
    struct sk_buff  *pHeadSkb = NULL;
    struct sk_buff  *pCurSkb = NULL;
    ATHEROS_DESC    *pHeadDesc = pDesc;

    ASSERT(pDesc);

    while (pDesc != NULL) {
        if (pHeadSkb) {
            OS_ALLOCATE_BUFF(pCurSkb, pDesc, pDevInfo, 0);
            skb_append(pCurSkb, pDesc->OSbuffer);
        } else {
            OS_ALLOCATE_BUFF(pHeadSkb, pDesc, pDevInfo, 0);
        }
        pDesc = pDesc->pNextVirtPtr;
    }
    freeBuffandDescChain(pDevInfo, pHeadDesc);
    return pHeadSkb;

SkbFree:
    if (pHeadSkb) {
        dev_kfree_skb_any(pHeadSkb);
    }
    return (NULL);
}

/*
 * athTxFrameReleaseBufferMaps - on TX completion reverse
 * maps set by osPacketToAthDesc
 *
 */
void
athTxFrameReleaseBufferMaps(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc)
{
    return;
}

/*
 * Release all Ath descr/buffer/ndis_packet units in this NDIS packet
 */
void
athNdisRxComplete(WLAN_DEV_INFO *pDevInfo, PNDIS_PACKET pPacket)
{

}

