/* $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/sta/stapoll.c#2 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * Contains routines related to the polling timer used by the client
 */

#include "wlantype.h"
#include "wlanext.h"
#include "stacserv.h"
#include "wlanDev.h"
#include "intercept.h"
#include "histograms.h"
#include "athusbapi.h"

void
powerModeCallback(WLAN_DEV_INFO *pDevInfo, A_STATUS result)
{
    uiPrintf("powerModeCallback - result of power operation %x\n", result);
}

void
staPollFunction(WLAN_DEV_INFO *pDevInfo)
{
    A_UINT32    state;
    CSERV_INFO  *pCsInfo = pDevInfo->pCsInfo;

    ASSERT(pDevInfo->pCsInfo);

    /*
     * If the radio was turned off and the chips put to sleep, wake them up
     * periodically to see if the GPIO was toggled (by laptop switch).
     */
    if (!athDrvRadioStatus(pDevInfo, TRUE)) {
        /* can't do anything while hardware is off */
        return;
    }

    if (pDevInfo->NicResetInProgress || !wlanDevPresent(pDevInfo)) {
        /* can't do anything during a hw reset */
        return;
    }

    //xxxxPGSxxxx -  For now, poll target for stats.
    if (pCsInfo->statusPollCount < pCsInfo->statusPollInterval) {
        pCsInfo->statusPollCount ++;
    } else {
        wdcTargetGetStats(pDevInfo->targetHandle);
        pCsInfo->statusPollCount = 0;
    }

    cservPollFunction(pDevInfo);

    phyHangCheck(pDevInfo);

    if (pCsInfo->cservState == CSERV_STATE_IDLE) {
        powerMgtPoll(pDevInfo);
    }

    powerSleepHangCheck(pDevInfo);

    /* Allow periodic intercept/profiling code to run */
    ICEPT_POLL();
}


