/*
 * Copyright (c) 2003 Atheros Communications, Inc., All Rights Reserved
 *
 * This file contains the IBM Thinkpad/Atheros power management interface.
 *
 */

#include "crypto/ocb.h"
#include "crypto/wep.h"
#include "wlandrv.h"
#include "wlanDev.h"
#include "wlanPhy.h"
#include "wlanext.h"
#include "wlansmeext.h"
#include "wlanbeacon.h"
#include "wlanchannel.h"
#include "wlanSend.h"
#include "wlanReceive.h"
#ifdef Linux
#include "linuxext.h"
#endif
#include "stacserv.h"
#include "usbstub.h"

static VOID
vectorGenerator();

static A_UINT32
random();
/*
 * (LW)
 * !!! Please attention !!! 
 * All the following function should be remove after we implement
 * all stub layer WDC call, we just put those function on here to
 * let our complier happy for NDIS_WDM project.
 */
#if NDIS_WDM

static RATE_TABLE ar5212_TurboPrimeARateTable = {
    16,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,   6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,     60,       60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,   9000,  7800,   0x0f,    0x00,        18,   0,       3,       1,     60,       60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM,  12000, 10000,   0x0a,    0x00, (0x80|24),   2,       4,       2,     48,       48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM,  18000, 13900,   0x0e,    0x00,        36,   2,       6,       2,     48,       48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM,  24000, 17300,   0x09,    0x00, (0x80|48),   4,      10,       3,     44,       44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM,  36000, 23000,   0x0d,    0x00,        72,   4,      14,       3,     44,       44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM,  48000, 27400,   0x08,    0x00,        96,   4,      19,       3,     44,       44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM,  54000, 29300,   0x0c,    0x00,       108,   4,      23,       3,     44,       44 },
     /*   6 Mb */ {  TRUE, WLAN_PHY_TURBO,  6000, 10600,   0x0b,    0x00, (0x80|12),   8,       2,       1,     34,       34 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_TURBO,  9000, 15600,   0x0f,    0x00,        18,   8,       3,       1,     34,       34 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_TURBO, 12000, 19400,   0x0a,    0x00, (0x80|24),  10,       4,       2,     30,       30 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_TURBO, 18000, 26900,   0x0e,    0x00,        36,  10,       6,       2,     30,       30 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_TURBO, 24000, 33200,   0x09,    0x00, (0x80|48),  12,      10,       3,     26,       26 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_TURBO, 36000, 43600,   0x0d,    0x00,        72,  12,      14,       3,     26,       26 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_TURBO, 48000, 51300,   0x08,    0x00,        96,  12,      19,       3,     26,       26 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_TURBO, 54000, 55100,   0x0c,    0x00,       108,  12,      23,       3,     26,       26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    5,   /* 36 Mbps for 11a */
    11,  /* 18 Mbps (36 Mbps) for 108a */
    50,  /* packet count threshold */
    7,   /* initial rateMax (index) */
    8    /* # of turboRates */
};

static RATE_TABLE ar5212_TurboRateTable = {
    8,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_TURBO,  6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,     34,         34 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_TURBO,  9000,  7800,   0x0f,    0x00,        18,   0,       4,       1,     34,         34 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_TURBO, 12000, 10000,   0x0a,    0x00, (0x80|24),   2,       7,       2,     30,         30 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_TURBO, 18000, 13900,   0x0e,    0x00,        36,   2,       9,       2,     30,         30 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_TURBO, 24000, 17300,   0x09,    0x00, (0x80|48),   4,      14,       3,     26,         26 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_TURBO, 36000, 23000,   0x0d,    0x00,        72,   4,      17,       3,     26,         26 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_TURBO, 48000, 27400,   0x08,    0x00,        96,   4,      22,       3,     26,         26 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_TURBO, 54000, 29300,   0x0c,    0x00,       108,   4,      26,       3,     26,         26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    0,
    0, 
    0,
    7,   /* initial rateMax (index) */
    8    /* # of turboRates */
};

static RATE_TABLE ar5212_11aRateTable = {
    8,  /* number of rates */
    { -1 },
    {/*                                                             short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                 Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,  6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,      60,        60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,  9000,  7800,   0x0f,    0x00,        18,   0,       3,       1,      60,        60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM, 12000, 10000,   0x0a,    0x00, (0x80|24),   2,       4,       2,      48,        48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM, 18000, 13900,   0x0e,    0x00,        36,   2,       6,       2,      48,        48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM, 24000, 17300,   0x09,    0x00, (0x80|48),   4,      10,       3,      44,        44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM, 36000, 23000,   0x0d,    0x00,        72,   4,      14,       3,      44,        44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM, 48000, 27400,   0x08,    0x00,        96,   4,      19,       3,      44,        44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM, 54000, 29300,   0x0c,    0x00,       108,   4,      23,       3,      44,        44 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    0,
    0, 
    0,
    7,   /* initial rateMax (index) */
    0    /* # of turboRates */
};

static RATE_TABLE ar5212_TurboPrimeGRateTable = {
    19,  /* number of rates */
    { -1 },
    {/*                                                                short           ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid  phy              Kbps  uKbps   rateCode Preamble dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   1 Mb */ {  TRUE,  WLAN_PHY_CCK,    1000,   900,  0x1b,    0x00,         2,   0,      0,      1,       314,         314 },
     /*   2 Mb */ {  TRUE,  WLAN_PHY_CCK,    2000,  1900,  0x1a,    0x04,         4,   1,      1,      1,       258,         162 },
     /* 5.5 Mb */ {  TRUE,  WLAN_PHY_CCK,    5500,  4900,  0x19,    0x04,        11,   2,      2,      2,       223,         127 },
     /*  11 Mb */ {  TRUE,  WLAN_PHY_CCK,   11000,  8100,  0x18,    0x04,        22,   3,      3,      2,       213,         117 },
     /*   6 Mb */ {  FALSE, WLAN_PHY_OFDM,   6000,  5400,  0x0b,    0x00,        12,   4,      2,      1,        60,          60 },
     /*   9 Mb */ {  FALSE, WLAN_PHY_OFDM,   9000,  7800,  0x0f,    0x00,        18,   4,      3,      1,        60,          60 },
     /*  12 Mb */ {  TRUE,  WLAN_PHY_OFDM,  12000, 10100,  0x0a,    0x00,        24,   6,      4,      1,        48,          48 },
     /*  18 Mb */ {  TRUE,  WLAN_PHY_OFDM,  18000, 14100,  0x0e,    0x00,        36,   6,      6,      2,        48,          48 },
     /*  24 Mb */ {  TRUE,  WLAN_PHY_OFDM,  24000, 17700,  0x09,    0x00,        48,   8,     10,      3,        44,          44 },
     /*  36 Mb */ {  TRUE,  WLAN_PHY_OFDM,  36000, 23700,  0x0d,    0x00,        72,   8,     14,      3,        44,          44 },
     /*  48 Mb */ {  TRUE,  WLAN_PHY_OFDM,  48000, 27400,  0x08,    0x00,        96,   8,     19,      3,        44,          44 },
     /*  54 Mb */ {  TRUE,  WLAN_PHY_OFDM,  54000, 29300,  0x0c,    0x00,       108,   8,     23,      3,        44,          44 },
     /*   6 Mb */ {  TRUE,  WLAN_PHY_TURBO,  6000, 10600,  0x0b,    0x00, (0x80|12),   12,     2,      1,        34,          34 },
     /*  12 Mb */ {  TRUE,  WLAN_PHY_TURBO, 12000, 19400,  0x0a,    0x00,        24,   13,     4,      1,        30,          30 },
     /*  18 Mb */ {  TRUE,  WLAN_PHY_TURBO, 18000, 26900,  0x0e,    0x00,        36,   13,     6,      2,        30,          30 },
     /*  24 Mb */ {  TRUE,  WLAN_PHY_TURBO, 24000, 33200,  0x09,    0x00, (0x80|48),   15,    10,      3,        26,          26 },
     /*  36 Mb */ {  TRUE,  WLAN_PHY_TURBO, 36000, 43600,  0x0d,    0x00,        72,   15,    14,      3,        26,          26 },
     /*  48 Mb */ {  TRUE,  WLAN_PHY_TURBO, 48000, 51300,  0x08,    0x00,        96,   15,    19,      3,        26,          26 },
     /*  54 Mb */ {  TRUE,  WLAN_PHY_TURBO, 54000, 55100,  0x0c,    0x00,       108,   15,    23,      3,        26,          26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    9,   /* 36 Mbps for 11g */
    14,  /* 18 Mbps (36 Mbps) for 108g */
    50,  /* packet count threshold */
    11,  /* initial rateMax (index) */
    7    /* # of turboRates */
};

static RATE_TABLE ar5212_11bRateTable = {
    4,  /* number of rates */
    { -1 },
    {/*                                                             short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                 Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   1 Mb */ {  TRUE,  WLAN_PHY_CCK,  1000,  900,  0x1b,    0x00, (0x80| 2),   0,       0,       1,        314,        314 },
     /*   2 Mb */ {  TRUE,  WLAN_PHY_CCK,  2000, 1800,  0x1a,    0x04, (0x80| 4),   1,       1,       1,        258,        162 },
     /* 5.5 Mb */ {  TRUE,  WLAN_PHY_CCK,  5500, 4300,  0x19,    0x04, (0x80|11),   1,       2,       2,        258,        162 },
     /*  11 Mb */ {  TRUE,  WLAN_PHY_CCK, 11000, 7100,  0x18,    0x04, (0x80|22),   1,       4,     100,        258,        162 }
    },
    200, /* probe interval */
    100, /* rssi reduce interval */
    0,
    0, 
    0,
    3,   /* initial rateMax (index) */
    0    /* # of turboRates */
};

static RATE_TABLE ar5212_XrRateTable = {
    12,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /* 0.5 Mb */ {  TRUE,   WLAN_PHY_XR,   500,   400,      0x07,    0x00, (0x80| 1),   0,       0,       1,     457,      457 },
     /*   1 Mb */ {  TRUE,   WLAN_PHY_XR,  1000,   900,      0x02,    0x00, (0x80| 2),   1,       1,       1,     228,      228 },
     /*   2 Mb */ {  TRUE,   WLAN_PHY_XR,  2000,  1800,      0x06,    0x00, (0x80| 4),   2,       2,       2,     160,      160 },
     /*   3 Mb */ {  TRUE,   WLAN_PHY_XR,  3000,  2700,      0x01,    0x00, (0x80| 6),   3,       2,       2,     140,      140 },
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,  6000,  5400,      0x0b,    0x00, (0x80|12),   4,       3,       1,      60,       60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,  9000,  7800,      0x0f,    0x00,        18,   4,       3,       1,      60,       60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM, 12000, 10000,      0x0a,    0x00, (0x80|24),   6,       4,       1,      48,       48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM, 18000, 13900,      0x0e,    0x00,        36,   6,       6,       2,      48,       48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM, 24000, 17300,      0x09,    0x00, (0x80|48),   8,      10,       3,      44,       44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM, 36000, 23000,      0x0d,    0x00,        72,   8,      14,       3,      44,       44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM, 48000, 27400,      0x08,    0x00,        96,   8,      19,       3,      44,       44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM, 54000, 29300,      0x0c,    0x00,       108,   8,      23,       3,      44,       44 }
    },
    200, /* probe interval */
    100, /* rssi reduce interval */
    0,
    0, 
    0,
    11,  /* initial rateMax (index) */
    0    /* # of turboRates */
};

void
athAttachRateTables(WLAN_DEV_INFO *pDev)
{
    /*
     * Attach device specific rate tables; for ar5212.
     * 11a static turbo and 11g static turbo share the same table.
     * Dynamic turbo uses combined rate table.
     */
    pDev->hwRateTable[WIRELESS_MODE_TURBO] = &ar5212_TurboRateTable;
    pDev->hwRateTable[WIRELESS_MODE_11b]   = &ar5212_11bRateTable;
    pDev->hwRateTable[WIRELESS_MODE_11a]   = &ar5212_TurboPrimeARateTable;
    pDev->hwRateTable[WIRELESS_MODE_11g]   = &ar5212_TurboPrimeGRateTable;

    pDev->hwRateTable[WIRELESS_MODE_108g]  = &ar5212_TurboRateTable;
    pDev->hwRateTable[WIRELESS_MODE_XR]    = &ar5212_XrRateTable;
#if defined(XR_HACKERY) && (XR_DEFAULT_RATE >= 6000)
    pDev->hwRateTable[WIRELESS_MODE_XR]    = &ar5212_11aRateTable;
#endif
}

A_UINT32
halMibControl(__WLAN_DEV_INFO *pDev, HAL_MIB_CMD cmd)
{
    return 0;
}


A_STATUS
halPhyDisable(struct ArDevInfo *pArDev)
{
    return A_OK;
}

void
halReleaseTxQueue(struct ArDevInfo *pDev, int queueNum)
{
    return;
}

void
halGpioCfgOutput(__WLAN_DEV_INFO *pDev, A_UINT32 gpio)
{
    return;
}

A_UINT32
halGpioGet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio)
{
    return 0;
}

void
halGpioSet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val)
{
    return;
}

void
halGpioSetIntr(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel)
{
    return;
}

#define MERS_N   624
#define MERS_M   397
#define MERS_R   31
#define MERS_U   11
#define MERS_S   7
#define MERS_T   15
#define MERS_L   18
#define MERS_A   0x9908B0DF
#define MERS_B   0x9D2C5680
#define MERS_C   0xEFC60000

A_UINT32 randVect[MERS_N];                   // state vector
A_UINT32 vectLenth = 0;
A_UINT32 mag01[2] = {0, MERS_A};
A_BOOL   bVectInit = FALSE;

VOID
randomInit(A_UINT32 seed)
{
    A_UINT32  i;

    // re-seed generator
    randVect[0]= seed * 0x41c4e6d + 12345;

    for (i = 1; i < MERS_N; i ++) {
        randVect[i] = (1812433253UL * (randVect[i - 1] ^ (randVect[i - 1] >> 30)) + i);
    }

    vectorGenerator();
    bVectInit = TRUE;
}

VOID
vectorGenerator()
{
    A_UINT32 rand;
    A_UINT32 lowerMask;
    A_UINT32 upperMask;
    A_UINT32 kk;

    // generate MERS_N words at one time
    lowerMask = (1LU << MERS_R) - 1; // lower MERS_R bits
    upperMask = -1L  << MERS_R;      // upper (32 - MERS_R) bits    

    for (kk = 0; kk < MERS_N-MERS_M; kk ++) {
      rand = (randVect[kk] & upperMask) | (randVect[kk + 1] & lowerMask);
      randVect[kk] = randVect[kk + MERS_M] ^ (rand >> 1) ^ mag01[rand & 1];
    }

    for (; kk < MERS_N-1; kk ++) {
      rand = (randVect[kk] & upperMask) | (randVect[kk + 1] & lowerMask);
      randVect[kk] = randVect[kk + (MERS_M - MERS_N)] ^ (rand >> 1) ^ mag01[rand & 1];
    }

    rand = (randVect[MERS_N - 1] & upperMask) | (randVect[0] & lowerMask);
    randVect[MERS_N - 1] = randVect[MERS_M - 1] ^ (rand >> 1) ^ mag01[rand & 1];
}
     
A_UINT32
random()
{
    A_UINT32 rand;

    ASSERT (bVectInit);

    if (vectLenth >= MERS_N) {
        vectorGenerator();
        vectLenth = 0; 
    }

    rand = randVect[vectLenth++];

    // Tempering (May be omitted):
    rand ^=  rand >> MERS_U;
    rand ^= (rand << MERS_S) & MERS_B;
    rand ^= (rand << MERS_T) & MERS_C;
    rand ^=  rand >> MERS_L;
 
    return rand;
}

A_UINT32
halGetRandomSeed(__WLAN_DEV_INFO *pDev)
{
    return random();
}

void
halAniControl(__WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param)
{
    return;
}

A_UINT32
halGetKeyCacheSize(__WLAN_DEV_INFO *pDev)
{
    return 0;
}

void
halResetKeyCache(__WLAN_DEV_INFO *pDev)
{
    return;
}

void
halResetKeyCacheEntry(__WLAN_DEV_INFO *pDev, A_UINT16 keyCacheIndex)
{
    return;
}

void
halSetKeyCacheEntry(__WLAN_DEV_INFO *pDev, A_UINT16 keyCacheIndex,
                    WLAN_MACADDR *pMacAddr, struct WlanPrivStruct *pWlanPrivRecord,
                    A_BOOL bXorKey)
{
    return;
}

void
halKeyCacheFree(__WLAN_DEV_INFO *pDev, A_UINT16 hwIndex)
{
    return;
}

A_STATUS
halSetPowerMode(struct ArDevInfo *pArDev, A_UINT32 powerRequest, A_BOOL setChip)
{
    return A_OK;
}

A_UINT32
halGetPowerMode(struct ArDevInfo *pArDev)
{
    return 0;
}

A_BOOL
halGetPowerStatus(struct ArDevInfo *pArDev)
{
    return TRUE;
}

void
halEnableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints)
{
    return;
}

void
halDisableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints)
{
    return;
}

#endif

