/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/hostBss.c#1 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */
#include "wlandrv.h"
#include "wlanchannel.h"
#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "wdcMsgApi.h"
#include "hostSend.h"
#include "hostReceive.h"
#include "tgtInfo.h"
#include "usbstub.h"
#if NDIS_WDM
#include "athusbapi.h"
#endif

void
wdcStaJoinBss(
    TARGET_HANDLE       targetHandle,
    A_UINT32            wdcBssId,
    WLAN_MACADDR        *pBssId,
    WDC_BSS_ATTRIBUTES  *pBssConfig)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_STA_JOIN_BSS);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));
    wdcMsgAddData(wdcMsg, sizeof(*pBssId), pBssId);

    // swizzle & add
    wdcDataSwizzle((void *) pBssConfig, sizeof(*pBssConfig));
    wdcMsgAddData(wdcMsg, sizeof(*pBssConfig), pBssConfig);

    // swizzle back to the original
    wdcDataSwizzle((void *) pBssConfig, sizeof(*pBssConfig));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }

    return;
}

void
wdcStaAssocBss(
    IN  TARGET_HANDLE   targetHandle,
    IN  A_UINT32        wdcBssId,
    IN  A_UINT16        assocId)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_STA_ASSOC_BSS);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));
    wdcMsgAddParam(wdcMsg, fixEndian(assocId));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }

    return;
}

void
wdcUpdateBssAttribute(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcBssId,
    IN  WDC_BSS_ATTRIBUTE   attribute,
    IN  A_UINT32            cfgSz,
    IN  TARGET_CONFIG_VAL   cfgVal)
{
    PER_TARGET_INFO     *pTargInfo;
    A_STATUS            status;
    A_UINT32            cfgData;
    WDC_MSG             *wdcMsg;
    A_UINT32            maxLength;
    A_UINT8             *pData;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_UPDATE_BSS_ATTRIBUTE);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));
    wdcMsgAddParam(wdcMsg, fixEndian(attribute));

    switch (attribute) {
        /*
         * All the following attrID use the fixed size
         */
        case BEACON_INTERVAL:
        case DTIM_INTERVAL:
        case CFP_INTERVAL:
        case CFP_MAX_DURATION:
        case ATIM_WINDOW:
        case DEFAULT_RATE_INDEX:
        case SHORT_SLOT_TIME_11g:
        case SLEEP_DURATION:
        case BMISS_THRESHOLD:
        case TPC_POWER_LIMIT:
            /*
             * Set cfg size first
             */
            wdcMsgAddParam(wdcMsg, 0);
            cfgData = *((A_UINT32 *)cfgVal);

            wdcMsgAddParam(wdcMsg, fixEndian(cfgData));
            break;

        /*
         * All the following attrID use the variable size
         */
        case BSS_KEY_UPDATE:
            /*
             * Set cfg size first
             */
            wdcMsgAddParam(wdcMsg, fixEndian(cfgSz));
            wdcMsgPrepData(wdcMsg,(void **)&pData, &maxLength);
            ASSERT(cfgSz <= maxLength);
            A_BCOPY(cfgVal, pData, cfgSz);
            wdcMsgCommitData(wdcMsg,cfgSz);
            break;

        default:
            ASSERT(0);
            break;

    }

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }

    return;
}

void
wdcStartBss(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcBssId,
    IN  WDC_BUFFER_DESC     *pBeaconTemplate)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_STA_START_BSS);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));

    if (pBeaconTemplate) {
        wdcMsgAddData(wdcMsg, pBeaconTemplate->bufferLength, pBeaconTemplate->pBuffer);
    } else {
        wdcMsgAddParam(wdcMsg, 0);
    }

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }
}

void
wdcDetachBss(
    IN  TARGET_HANDLE   targetHandle,
    IN  A_UINT32        wdcBssId)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_STA_DETACH_BSS);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }

    return;
}
