/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/hostConn.c#1 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */
#include "wlandrv.h"
#include "wlanchannel.h"
#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "wdcMsgApi.h"
#include "hostSend.h"
#include "hostReceive.h"
#include "tgtInfo.h"
#include "usbstub.h"
#if NDIS_WDM
#include "athusbapi.h"
#endif


/*
 * Used by the host to create a connection in the target
 */
void
wdcCreateConnection(
    IN  TARGET_HANDLE       targetHandle,
    IN  WLAN_MACADDR        *pMacAddr,
    IN  A_UINT32            wdcConnId,
    IN  A_UINT32            wdcBssId,
    IN  CONN_ATTRIBUTES     *pOptions)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_CREATE_CONNECTION);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddData(wdcMsg, sizeof(*pMacAddr), pMacAddr);
    wdcMsgAddParam(wdcMsg, fixEndian(wdcConnId));
    wdcMsgAddParam(wdcMsg, fixEndian(wdcBssId));

    // swizzle & add
    wdcDataSwizzle((void *) pOptions, sizeof(*pOptions));
    wdcMsgAddData(wdcMsg, sizeof(*pOptions), pOptions);

    // swizzle back to the original
    wdcDataSwizzle((void *) pOptions, sizeof(*pOptions));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }
}

/*
 * Is used by the host to set/clear/modify an attribute related to a
 * particular connection. Whether it makes sense to modify an attribute
 * is attribute specific. The target is not required (but it could)
 * perform any validation of whether an attribute should be changed
 * or not (eg. it currently doesn't make sense to change compression after
 * associating but the target might not reject such request).
 */
void
wdcUpdateConnectionAttribute(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcConnId,
    IN  CONN_ATTRIBUTE      attribute,
    IN  A_UINT32            cfgSz,
    IN  TARGET_CONFIG_VAL   cfgVal
)
{
    PER_TARGET_INFO     *pTargInfo = (PER_TARGET_INFO *)targetHandle;
    WDC_MSG             *wdcMsg;
    A_UINT32            cfgData;
    A_UINT32            maxLength;
    A_STATUS            status;
    A_UINT8             *pData;

    ASSERT(pTargInfo);

    /*
     * Send a WDCMSG_UPDATE_CONNECTION_ATTRIBUTE message to the target.
     */
    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,WDCMSG_UPDATE_CONNECTION_ATTRIBUTE);
    if (wdcMsg == NULL) {
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcConnId));
    wdcMsgAddParam(wdcMsg, fixEndian(attribute));

    switch (attribute) {
        /*
         * All the following attrID use the fixed size
         */
        case CONN_KEYTYPE:
        case CONN_COMPRESSION:
        case CONN_LONG_PREAMBLE_ONLY:
        case CONN_CURRENT_TX_RATE_ANT:
        case CONN_SERVICE_TYPE:
        case CONN_WLAN_MODE:
            /*
             * Set cfg size first
             */
            wdcMsgAddParam(wdcMsg, 0);
            cfgData = *((A_UINT32 *)cfgVal);

            wdcMsgAddParam(wdcMsg, fixEndian(cfgData));
            break;

        /*
         * All the following attrID use the variable size
         */
        case CONN_WORKING_RATE_SET:
        case CONN_WORKING_RATE_SET_KEEPRC:
        case CONN_KEY_UPDATE:
            /*
             * Set cfg size first
             */
            wdcMsgAddParam(wdcMsg, fixEndian(cfgSz));
            wdcMsgPrepData(wdcMsg, (void **)&pData, &maxLength);
            ASSERT(cfgSz <= maxLength);
            A_BCOPY(cfgVal, pData, cfgSz);
            wdcMsgCommitData(wdcMsg, cfgSz);
            break;

        default:
            ASSERT(0);
            break;

    }

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }
}

/*
 * Used by the host to add/modify/clear a key for a particular connection
 */
void
wdcSetConnectionKey(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcConnId,
    IN  A_UINT32            keyType,
    IN  A_UINT32            keySize,            /* in bytes */
    IN  A_UCHAR             *pKeyMaterial)
{
    ASSERT(0);
}



/*
 * TODO - need async event to report connection stats
 */
void
wdcGetConnectionStats(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcConnId,
    OUT CONN_STATS          *pConnStats)
{
    ASSERT(0);
}


void
wdcDeleteConnection(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_UINT32            wdcConnId)
{
    PER_TARGET_INFO  *pTargInfo;
    A_STATUS          status;
    WDC_MSG          *wdcMsg;

    pTargInfo = (PER_TARGET_INFO *) targetHandle;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_DELETE_CONNECTION);
    if (wdcMsg == NULL) {
        ASSERT(0);
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian(wdcConnId));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);
    }
}
