/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/hostReceive.c#1 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */
#include "wlandrv.h"
#include "wlanchannel.h"
#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "wdcMsgApi.h"
#include "hostSend.h"
#include "tgtInfo.h"
#include "usbstub.h"
#if NDIS_WDM
#include "athusbapi.h"
#endif


/*
 * Local Definitions 
 */

/* 
 * Local data structures 
 */

/* 
 * Local function prototypes 
 */
LOCAL A_STATUS
allocateRxBuffers(
    IN TARGET_HANDLE targetHandle);

void
freeRxBuffers(
    IN TARGET_HANDLE targetHandle);

/*
 * Host-Side implementation of receive related functions.
 */

/******************************************************************************
 * WDC API implementation
 */

void
wdcSetRxFilter(
    IN  TARGET_HANDLE       targetHandle,
    IN  RX_FILTER_FLAGS     rxFilter
)
{
    PER_TARGET_INFO   *pTargInfo = (PER_TARGET_INFO *) targetHandle;
    WDC_MSG           *wdcMsg;
    A_STATUS          status;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_SET_RX_FILTER);
    if (wdcMsg == NULL) {
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian((A_UINT32)rxFilter));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if ((status != A_PENDING) && (status != A_TIMEOUT)) {
        wdcCtrlMsgFree(wdcMsg);
    }   
}

void
wdcInitRxMulticastFilter(
    IN  TARGET_HANDLE       targetHandle,
    IN  A_BOOL              bReset
)
{
    PER_TARGET_INFO   *pTargInfo = (PER_TARGET_INFO *) targetHandle;
    WDC_MSG           *wdcMsg;
    A_STATUS          status;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,
                              WDCMSG_INIT_RX_MULTICAST_FILTER);
    if (wdcMsg == NULL) {
        return;
    }

    wdcMsgAddParam(wdcMsg, fixEndian((A_UINT32)bReset));

    status = wdcCtrlMsgSend(pTargInfo->targetMsgHandle, wdcMsg);

    if ((status != A_PENDING) && (status != A_TIMEOUT)) {
        wdcCtrlMsgFree(wdcMsg);
    }   
}


void
wdcRxDone(
    IN  TARGET_HANDLE       targetHandle,
    IN  WDC_RX_INFO         *wdcRxInfo
)
{
    PER_TARGET_INFO   *pTargInfo = (PER_TARGET_INFO *) targetHandle;
    WDC_RXMSG         *wdcRxMsg;

    wdcRxMsg = (WDC_RXMSG *)(wdcRxInfo->rxData - WDC_RXMSG_HEADER_LENGTH);

    /* Recycle the buffer: make it available to the message transport. */
    wdcDataMsgRecv(pTargInfo->targetMsgHandle, wdcRxMsg);

    return;
}


/*****************************************************************************
 * Host Stub functions (public, but not part of the WDC API)
 */

/*
 * hsInitRx - initialize host stub for receive.
 *
 * RETURNS: status
 */
A_STATUS hsInitRx(
    IN TARGET_HANDLE targetHandle)
{
    A_STATUS    status;

    /* Allocate intermediate tx buffers */
    status = allocateRxBuffers(targetHandle);

    return status;

}

/*
 * hsShutdownRx - host stub receive shutdown
 *
 * RETURNS: status
 */
void hsShutdownRx(
    IN TARGET_HANDLE targetHandle)
{
    /* Free intermediate tx buffers */
    freeRxBuffers(targetHandle);
}

/*****************************************************************************
 * Local functions (private to this module)
 */

/*
 * allocateRxBuffers - allocate memory for rx descriptors/buffers
 *
 * RETURNS: status
 */
A_STATUS
allocateRxBuffers(
    IN TARGET_HANDLE targetHandle)
{
    PER_TARGET_INFO *pTargInfo  = (PER_TARGET_INFO *)targetHandle;
    A_STATUS        status      = A_OK;
    int             i;
    int             numRxBufs;

    /* Allocate rx buffers */
    pTargInfo->numRxBufs = MAX_DATA_MSG_COUNT;

    numRxBufs = pTargInfo->numRxBufs;

    for (i = 0; i < numRxBufs; i++) {
        pTargInfo->pRxMsgBuf[i] = 
	        (WDC_RXMSG *) A_DRIVER_MALLOC(WDC_RXMSG_LENGTH_MAX);
	
        if (pTargInfo->pRxMsgBuf[i]) {
            wdcDataMsgRecv(pTargInfo->targetMsgHandle, 
        	               pTargInfo->pRxMsgBuf[i]);
        } else {
            status = A_NO_MEMORY;
            goto exitError;
        }
    }

    return status;

exitError:
    freeRxBuffers(targetHandle);

    return status;
}

/*
 * freeRxBuffers - free rx buffer memory
 *
 * RETURNS: status
 */
void
freeRxBuffers(
    IN TARGET_HANDLE targetHandle)
{
    PER_TARGET_INFO *pTargInfo = (PER_TARGET_INFO *)targetHandle;
    int             i;
    int             numRxBufs;

    numRxBufs = pTargInfo->numRxBufs;

    for (i = 0; i < numRxBufs; i++) {

        if (pTargInfo->pRxMsgBuf[i]) {
            A_DRIVER_FREE(pTargInfo->pRxMsgBuf[i], WDC_RXMSG_LENGTH_MAX);
            pTargInfo->pRxMsgBuf[i] = NULL;
        }
    }
}
