/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/hostReset.c#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/*
 * Host-Side implmentation of Reset and related functions.
 */

#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "wdcMsgApi.h"
#include "hostSend.h"
#include "tgtInfo.h"

/* xxxxLMWxxxx error handling TBD */


/*
 * Reset a target.
 */
void
wdcTargetReset(
    IN  TARGET_HANDLE       targetHandle,
    OUT A_STATUS            *pStatus
)
{
    PER_TARGET_INFO     *pTargInfo      = (PER_TARGET_INFO *)targetHandle;
    TARGET_MSG_HANDLE   targetMsgHandle = pTargInfo->targetMsgHandle;
    WDC_MSG             *wdcMsg;
    A_STATUS            status;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,WDCMSG_TARGET_RESET);
    if (wdcMsg == NULL) {
        return;
    }
    status = wdcCtrlMsgSend(targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);     
    }

    if (pStatus) {
        *pStatus = A_OK;
    }
}

/*
 * Enable the target.
 */
void 
wdcTargetEnable( 
    IN  TARGET_HANDLE       targetHandle,
    OUT A_STATUS            *pStatus
)
{
    PER_TARGET_INFO     *pTargInfo   = (PER_TARGET_INFO *)targetHandle;
    TARGET_MSG_HANDLE   targetMsgHandle = pTargInfo->targetMsgHandle;
    WDC_MSG             *wdcMsg;
    A_STATUS            status;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,WDCMSG_TARGET_ENABLE);
    if (wdcMsg == NULL) {
        return;
    }
    status = wdcCtrlMsgSend(targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);     
    }

    if (pStatus) {
        *pStatus = A_OK;
    }
}
                
/*
 * Disable the target.
 */
void 
wdcTargetDisable(
    IN  TARGET_HANDLE       targetHandle,
    OUT A_STATUS            *pStatus
)
{
    PER_TARGET_INFO     *pTargInfo   = (PER_TARGET_INFO *)targetHandle;
    TARGET_MSG_HANDLE   targetMsgHandle = pTargInfo->targetMsgHandle;
    WDC_MSG             *wdcMsg;
    A_STATUS            status;
    KIRQL               curIrql;
    A_UINT32            msgId;

    athGetCurrentIrql(curIrql);

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,WDCMSG_TARGET_DISABLE);
    if (wdcMsg == NULL) {
        return;
    }

    if (curIrql < DISPATCH_LEVEL) {
        wdcMsg->r.responseDesired = TRUE;
    }

    msgId = wdcMsg->msgId;
    NdisResetEvent(&pTargInfo->rxMsgCompEvent[msgId]);

    status = wdcCtrlMsgSend(targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);     
    }

#if NDIS_WDM
    if (curIrql < DISPATCH_LEVEL) {
        if (!NdisWaitEvent(&pTargInfo->rxMsgCompEvent[msgId], MAX_MSGREAD_WAIT_TIME)) {
            uiPrintf("No response for WDCMSG_TARGET_DISABLE\n");                
        } else {
            wdcMsg = pTargInfo->rcvMsg[msgId];
            wdcCtrlMsgRecv(pTargInfo->targetMsgHandle,wdcMsg);
        }
    }
#endif

    if (pStatus) {
        *pStatus = A_OK;
    }

    pTargInfo->bTargetHang = FALSE;
    pTargInfo->NoRespCount = 0;
}

void
wdcTargetSetChannel(
    IN  TARGET_HANDLE       targetHandle,
    IN  CHANNEL_BAND        channelBand,
    IN  CHANNEL_FREQ        channelFrequency,
    IN  PHY_MODS            phyModulations,
    IN  A_UINT32            maxRDPower,
    IN  A_UINT32            cfgCtl,
    IN  A_UINT32            twiceAntennaReduction,
    IN  A_BOOL              keepRCContent,
    OUT A_STATUS            *pStatus
)
{
    PER_TARGET_INFO     *pTargInfo   = (PER_TARGET_INFO *)targetHandle;
    TARGET_MSG_HANDLE   targetMsgHandle = pTargInfo->targetMsgHandle;
    WDC_MSG             *wdcMsg;
    A_STATUS            status;
    A_UINT32            value;

    wdcMsg = wdcCtrlMsgCreate(pTargInfo->targetMsgHandle,WDCMSG_TARGET_SET_CHANNEL);
    if (wdcMsg == NULL) {
        return;
    }

    value = (A_UINT32)channelBand;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)channelFrequency;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)phyModulations;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)maxRDPower;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)cfgCtl;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)twiceAntennaReduction;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    value = (A_UINT32)keepRCContent;
    wdcMsgAddParam(wdcMsg, fixEndian(value));

    status = wdcCtrlMsgSend(targetMsgHandle, wdcMsg);

    if (status == A_OK) {
        wdcCtrlMsgFree(wdcMsg);     
    }

    if (pStatus) {
        *pStatus = A_OK;
    }
}
