/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/hostSend.h#1 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* Host-side WDC Send interface */

#ifndef __INC_HOSTSEND_H
#define __INC_HOSTSEND_H


/* Intermediate tx descriptor structure */
typedef struct intDesc {
    struct intDesc  *pNextVirtPtr;          /* virtual pointer to next descriptor */
    A_UINT8         *pBufferVirtPtr;        /* virtual pointer to buffer */
} INT_DESC;

/* Intermediate Queue data structure */
typedef struct intQueueDetails {
    A_SEM_TYPE           qSem;               /* Semaphore to manage this queue */
    INT_DESC            *pDescQueueHead;     /* virt pointer to queue head */
    INT_DESC            *pDescQueueTail;     /* virtual pointer to queue tail */
    A_INT32              qFrameCount;        /* frame count in this queue */
} INT_QUEUE_DETAILS;


/*
 * hsInitTx - initialize host stub for transmit.
 *
 * RETURNS: status
 */
A_STATUS hsInitTx(
    IN TARGET_HANDLE targetHandle);


/*
 * hsShutdownTx - host stub transmit shutdown
 *
 * RETURNS: status
 */
void hsShutdownTx(
    IN TARGET_HANDLE targetHandle);


#endif /* __INC_HOSTSEND_H */
