/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/tgtInfo.h#1 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* WDC Host-Side Per-Target definitions */

#ifndef __INC_TGTINFO_H
#define __INC_TGTINFO_H

#define MESSAGE_PIPE            0
#define DATA_PIPE               1
#define MAX_MSGREAD_WAIT_TIME   10000   /* 10 second */
#define MAX_MSGWRITE_WAIT_TIME  5000    /* 5 second */
#define MAX_RCV_MSG_COUNT       30
#define MAX_MSG_ID_COUNT        30

#define MAX_DATA_MSG_COUNT      48

/*
 * Here's a memory-based messaging system, just to test the dispatcher
 * and in order to get basic data types working.
 */

struct target_msg_info {
    /* Messaging stuff -- none is needed for PCI and shared memory transport */
    TARGET_HANDLE      targetHandle;
    WDCMSG_DISPATCH_FN *pDispatchFn;
};

/*
 * Already defined in wdcMsgApi.h
 * typedef struct target_msg_info *TARGET_MSG_HANDLE;
 */

typedef struct wdcevt_item {
    EVENT_HANDLER *pHandler;
    void *        param;
} WDCEVT_ITEM;

/* 
 * This is per-target information kept by the host-side WDC.
 * A TARGET_HANDLE is a pointer to one of these.
 */
typedef struct {
    TARGET_MSG_HANDLE   targetMsgHandle;/* Whatever data the host needs in order
                                           to access the target device. */

    HOST_HANDLE         hostHandle;     /* Driver cookie, which is opaque to
                                           all WDC code. */

    WDCEVT_ITEM         wdcHandlerTable[WDCEVT_MAX]; /* WDC Event handlers */

#if NDIS_WDM
    A_UINT32            numRxBufs;
    A_UINT32            numRxMsgBuf;
    WDC_RXMSG           *pRxMsgBuf[MAX_DATA_MSG_COUNT];
    WDC_MSG             *pRcvMsgBuf[MAX_RCV_MSG_COUNT];
    A_UINT32            *pPendStatSz[MAX_MSG_ID_COUNT];
    A_UINT32            pendStatBuf[MAX_MSG_ID_COUNT];
    A_UINT32            *pPendCapSz[MAX_MSG_ID_COUNT];
    A_UINT32            pendCapBuf[MAX_MSG_ID_COUNT];
    WDC_MSG             *rcvMsg[MAX_MSG_ID_COUNT];    /* keep trace which msg is received */
    A_ATOMIC            msgId;    
    NDIS_EVENT          msgCompEvent[WDCMSG_MAX]; /* Used to block for completion.*/    
    NDIS_EVENT          rxMsgCompEvent[MAX_MSG_ID_COUNT]; /* Used to block for completion.*/    
    NDIS_EVENT          txMsgCompEvent[MAX_MSG_ID_COUNT]; /* Used to block for completion.*/    
    A_UINT8             totalInPipe;        /* total receive pipe number */
    A_UINT8             totalOutPipe;       /* total transmit pipe number */
    VOID *              usbHandle;          /* USB driver cookie, which is opaque to WDC */

    INT_QUEUE_DETAILS   intTxFreeQueue;     /* Intermediate tx buffer queue */
    INT_QUEUE_DETAILS   intTxPendQueue;     /* Pending (send to the target) 
											 * tx buffer queue              */
    A_UINT8             *pIntTxMemory;      /* Intermediate tx descriptors/buffers */
#endif
    A_BOOL              bBind;              /* Bind is successful or not */
    A_BOOL              bStart;             /* start device is successful or not */
    A_BOOL              bDebugEnabled;      /* Target Debug features enabled */
    A_BOOL              bTargetHang;
    A_UINT8             NoRespCount;
    A_UINT32            busStatus;
} PER_TARGET_INFO;

extern A_STATUS
wdcTriggerEventHandler(
    TARGET_HANDLE       targetHandle,
    WDC_EVENT           event,
    A_UINT32            infoSize,
    A_UCHAR             *pInfo
);

#endif /* __INC_TGTINFO_H */
