/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/wdc/wdcMsgApi.h#2 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* Host-side WDC Message interface */

#ifndef __INC_WDCMSGAPI_H
#define __INC_WDCMSGAPI_H

/*
 * This is the out of band data which contain control information for message
 */
typedef struct _WDC_MSG_OOB_DATA{
    A_BOOL        bAsynCall;
    A_BOOL        bTimeOut;
} WDC_MSG_OOB_DATA, *PWDC_MSG_OOB_DATA;

typedef void (WDCMSG_DISPATCH_FN)(TARGET_HANDLE, WDC_MSG *);

struct target_msg_info; /* opaque */
typedef struct target_msg_info *TARGET_MSG_HANDLE;

/*
 * fixEndian adjusts endianness of message data for transmision
 * between Host and Target.  If they are different endianness,
 * we swizzle; otherwise, we pass through.
 */
#if NDIS_WDM
/* Little-Endian Host; Big-Endian USB target */
#define fixEndian(x) A_swab32(x)
#define fixEndian64(x) A_swab64(x)
#endif

TARGET_MSG_HANDLE wdcMsgInit(TARGET_HANDLE targetHandle,
                             WDCMSG_DISPATCH_FN *pDispatchFn);

void wdcCtrlMsgRecvInd(TARGET_MSG_HANDLE targetMsgHandle, WDC_MSG *wdcMsg);
void wdcCtrlMsgRecv(TARGET_MSG_HANDLE targetMsgHandle, WDC_MSG *wdcMsg);
A_STATUS wdcCtrlMsgSend(TARGET_MSG_HANDLE targetMsgHandle, WDC_MSG *wdcMsg);
WDC_MSG * wdcCtrlMsgCreate(TARGET_MSG_HANDLE targetMsgHandle,WDC_MSG_OPCODE msgOpcode);
void wdcCtrlMsgFree(WDC_MSG *wdcMsg);

void wdcDataMsgRecvInd(TARGET_MSG_HANDLE targetMsgHandle, WDC_RXMSG *wdcRxMsg);
void wdcDataMsgRecv(TARGET_MSG_HANDLE targetMsgHandle, WDC_RXMSG *wdcRxMsg);
A_STATUS wdcDataMsgSend(TARGET_MSG_HANDLE targetMsgHandle,WDC_TXMSG *wdcTxMsg);
void wdcDataMsgSendCnf(TARGET_HANDLE targetHandle, WDC_TXMSG *wdcTxMsg);

void wdcMsgAddParam(WDC_MSG *wdcMsg, A_UINT32 param);
void wdcMsgAddData(WDC_MSG *wdcMsg, A_UINT32 length, void *data);
void wdcMsgSwapHeader(WDC_MSG *wdcMsg);
void wdcTxMsgSwapHeader(WDC_TXMSG *wdcMsg);
void wdcRxMsgSwapHeader(WDC_RXMSG *wdcMsg);
void wdcDataSwizzle(void *pData, A_UINT32 length);
void wdcMsgPrepData(WDC_MSG *wdcMsg, void **pData,A_UINT32 *maxLength);
void wdcMsgCommitData(WDC_MSG *wdcMsg, A_UINT32 length);

void wdcMsgReadParam(WDC_MSG *wdcMsg, A_UINT32 *pCursor, A_UINT32 *pParam);
void wdcMsgReadData(WDC_MSG *wdcMsg, A_UINT32 *pCursor, A_UINT32 *plength, void *pData);
void wdcMsgSeekData(WDC_MSG *wdcMsg, A_UINT32 *pCursor,void **ppData);
void wdcMsgConsumeData(WDC_MSG *wdcMsg,A_UINT32 *pCursor,A_UINT32 length);

A_STATUS do_wdcFlush(TARGET_HANDLE targetHandle, A_UINT32 disableEnableCounter);

#endif /* __INC_WDCMSGAPI_H */
