/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/include/shrcfg.h#1 $
 *
 * Copyright © 2004 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Definitions shared between target and host that relate
 * to configuration items found in EEPROM.  This allows a
 * consistent interpretation of values that are passed across
 * the host/target boundary.
 */

#ifndef _SHRCFG_H_
#define _SHRCFG_H_

typedef enum {
    ABOLT_TURBO_G     = 0x01,      /* Legacy Turbo G */
    ABOLT_TURBO_PRIME = 0x02,      /* Turbo Prime */
    ABOLT_COMPRESSION = 0x04,      /* Compression */
    ABOLT_FAST_FRAME  = 0x08,      /* Fast Frames */
    ABOLT_BURST       = 0x10,      /* Bursting */
    ABOLT_WME_ELE     = 0x20,      /* WME based cwmin/max/burst tuning */
    ABOLT_FRIENDLY_TURBO = 0x80,  /* Friendly turbo that switches out based on adjacent non-turbo traffic */
    ABOLT_ATH_ADVCAP  = ( 
                          ABOLT_TURBO_PRIME |
                          ABOLT_COMPRESSION |
                          ABOLT_FAST_FRAME  |
                          ABOLT_FRIENDLY_TURBO
                        ),         /* Capabilties causes negotiation through AdvCap */
} ABOLT_OPTION;

/*
 * The ABOLT OPTION Bit positions corresponding to the bit mask above
 */
#define ABOLT_TURBO_G_BIT_POS               0
#define ABOLT_TURBO_PRIME_BIT_POS           1
#define ABOLT_COMPRESSION_BIT_POS           2
#define ABOLT_FAST_FRAME_BIT_POS            3
#define ABOLT_BURST_BIT_POS                 4
#define ABOLT_WME_ELE_BIT_POS               5
#define ABOLT_XR_BIT_POS                    6
#define ABOLT_FRIENDLY_TURBO_BIT_POS        7

/*
 * Turbo Prime is enabled separately from the other Super G
 * Capabilities.
 */
#define ABOLT_SUPERG    (ABOLT_WME_ELE | ABOLT_BURST | ABOLT_FAST_FRAME | ABOLT_COMPRESSION | ABOLT_TURBO_G)

/*
 * Turbo Prime is enabled separately from the other Super G
 * Capabilities.
 */
#define ABOLT_SUPERG    (ABOLT_WME_ELE | ABOLT_BURST | ABOLT_FAST_FRAME | ABOLT_COMPRESSION | ABOLT_TURBO_G)

/*
 * The Super Features that are configurable 
 */
#define ABOLT_CFG_SUPER_FEATURES (ABOLT_TURBO_G             |               \
                                  ABOLT_COMPRESSION         |               \
                                  ABOLT_FAST_FRAME)

typedef struct RegisterVal {
    A_UINT32    Offset;
    A_UINT32    Value;
} REGISTER_VAL;

typedef A_UINT16                    CTRY_CODE;           /* Country code */
typedef A_UINT16                    REG_DOMAIN;          /* Regulatory domain */

/* Defines for transmit power scale levels */
#define TP_SCALE_LOWEST  0
#define TP_SCALE_MAX     0
#define TP_SCALE_50      1
#define TP_SCALE_25      2
#define TP_SCALE_12      3
#define TP_SCALE_MIN     4
#define TP_SCALE_HIGHEST 4

/* Defines for Compression Window Size */
#define COMPRESSION_WINSIZE_MIN         256
#define COMPRESSION_WINSIZE_256         256
#define COMPRESSION_WINSIZE_512         512
#define COMPRESSION_WINSIZE_1024        1024
#define COMPRESSION_WINSIZE_2048        2048
#define COMPRESSION_WINSIZE_4096        4096
#define COMPRESSION_WINSIZE_MAX         4096
#define DEFAULT_COMPRESSION_WINSIZE     COMPRESSION_WINSIZE_MAX 

/* Defines for Hardware and Software Retry limits */
#define HW_TX_RETRY_MIN                    1
#define HW_TX_RETRY_MAX                   15
#define SW_TX_RETRY_MIN                    0
#define SW_TX_RETRY_MAX                   15

/* Defines for RTS threshold */
#define MIN_RTS_THRESHOLD               1
#define MAX_RTS_THRESHOLD               2346
#define DEFAULT_RTS_THRESHOLD           MAX_RTS_THRESHOLD
  
#endif /* _SHRCFG_H_ */
