/*
 * Copyright (c) 2000-2004 Atheros Communications, Inc., All Rights Reserved
 *
 * Private definitions Host and Target WDC.
 * This is a common header file for all platforms and operating systems.
 */

#ifndef _WDCPRIV_H_
#define _WDCPRIV_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Definitions in this file are intended for use by the Host WDC
 * implementation and below.  In other words, the Host driver
 * may not use anything in this file directly -- it must use the
 * WDC API.
 *
 * To make it easy to pass these between Target and Host, which
 * may be of different endianness, members of structures that
 * are shipped across the WDC Transport tend to be 32-bit quantities. 
 */

/* Target Status */
typedef struct {
    A_UINT32            s_TransmitBusy;
    A_UINT32            s_invalidTxChannel;
    A_UINT32            s_phyActivityFlag;
    A_UINT32            s_noApActivity;
    A_UINT32            s_phyHwLastRssi;
    A_UINT32            s_psFramesDropped;
    A_UINT32            s_nonErpPreamble;
    A_UINT32            s_protectOn;
    A_UINT32            s_protectRateIdx;
    A_UINT32            s_MaskReg;
    A_UINT32            s_rxFilterReg;
    A_UINT32            s_cachedDefAnt;       // can be 1 or 2
    A_UINT32            s_countOtherRxAnt;    // count consecutive rx on other antenna
    A_UINT32            s_useFastDiversity;
    A_UINT32            s_RxGenerationNum;
//  ...
} AR_DEV_STATUS __ATTRIB_ALIGN(8);


/* Target Statistics (device/connection) */
typedef struct ArStats {

    /* Receive related stats */

    A_UINT32                FcsFailCnt;
    A_UINT32                RcvDmaOverrunErrors;
    A_LONGSTATS             RxBeacons __ATTRIB_ALIGN(8);

    /* Transmit related stats */

    A_LONGSTATS             GoodTransmits __ATTRIB_ALIGN(8);
    A_LONGSTATS             TxUnicastFrames __ATTRIB_ALIGN(8);
    A_LONGSTATS             TxBroadcastFrames __ATTRIB_ALIGN(8);
    A_LONGSTATS             TxMulticastFrames __ATTRIB_ALIGN(8);
    A_LONGSTATS             TxFramesDropped __ATTRIB_ALIGN(8);
    A_LONGSTATS             GoodTransmitBytes __ATTRIB_ALIGN(8);

    A_UINT32                TransmitErrors;
    A_UINT32                TxExcessiveRetries;
    A_UINT32                TxDmaUnderrun;
    A_UINT32                AckRcvFailures;
    A_LONGSTATS             RtsSuccessCnt __ATTRIB_ALIGN(8);
    A_UINT32                RtsFailCnt;

    A_UINT32                compSuccessCnt;
    A_UINT32                CompCPC0Cnt;
    A_UINT32                CompCPC1Cnt;
    A_UINT32                CompCPC2Cnt;
    A_UINT32                CompCPC3Cnt;

    A_UINT32                TxFiltered;
    A_LONGSTATS             TotalRetries __ATTRIB_ALIGN(8);
    A_UINT32                RetryBins[16];              // long frame bin
    A_UINT32                shortFrameRetryBins[16];
    A_UINT32                swRetryTotalCnt;            // sw retries for this connection
    A_UINT32                swRetryMaxRetriesExceeded;

    /* Rates/Antenna/RSSI etc. */

    A_INT32                 ackRssi;
    A_UINT32                txRateKb;                   // Averaged rate used for transmit
    A_UINT32                AntCnt[2];
    A_UINT32                AntSwCnt;
    A_UINT32                tx6PowerInHalfDbm;
    A_UINT32                maxTxPowerAvail;
    A_UINT32                noiseFloor;

} AR_STATS __ATTRIB_ALIGN(8);

/* Channel descriptor. */
typedef struct chanDesc {
    WLAN_MODE           wlanMode;
    CHANNEL_BAND        channelBand;
    CHANNEL_FREQ        channelFreq;
    PHY_MODS            phyModulations;
    A_UINT16            maxRDPower;
    A_UINT8             cfgCtl;
    A_INT8              twiceAntennaReduction;
} CHAN_DESC __ATTRIB_ALIGN(8);

/* Target Configuration */
typedef struct ArDevConfig {
    A_UINT32            id;                 // ID, used in debug/error messages
    A_UINT32            serviceType;        // AP, STA
    A_UINT32            rateControlEnable;
    A_UINT32            hwTxRetries;
    A_UINT32            swTxRetries;
    A_UINT32            calibrationInterval;
    A_UINT32            slowClockEnable;
    A_UINT32            userRTSThreshold;
    A_UINT32            protectionType;
    A_UINT32            burstSeqThreshold;
    A_UINT32            abolt;
    A_UINT32            modeCTS;
    A_UINT32            WmeEnabled;
    A_UINT32            GprsCBRPeriod;
    REGISTER_VAL        *pInitRegs;
    A_UINT32            diversityControl;       // Enable/disable antenna diversity
    A_UINT32            tpScale;                // Scaling factor to be applied to max transmit power
    A_UINT32            tpcHalfDbm5;            // Transmit Power Control for 5 GHz in half dBm
    A_UINT32            tpcHalfDbm2;            // Transmit Power Control for 2 GHz in half dBm
    A_UINT32            overRideTxPower;        // Override of transmit power
    A_UINT32            enable32KHzClock;       // auto or manual on/off

    CHAN_DESC           chanDesc;
    WLAN_MACADDR        macAddr;
    WLAN_MACADDR        macPermAddr;
    A_UINT32            compProc;               // Compression Processing style
    A_UINT32            compWinSize;            // Compression Window Size
#define DECOMP_MASK_SIZE        128
    A_UINT8             decompMaskArray[DECOMP_MASK_SIZE];
#define SERIAL_NUMBER_SIZE      16
    A_CHAR              serialNumber[SERIAL_NUMBER_SIZE];
} AR_DEV_CONFIG __ATTRIB_ALIGN(8);


/* Target Capabilities */
typedef struct {
    A_UINT32    targetVersion;
    A_UINT32    targetRevision;
    A_UINT32    macVersion;
    A_UINT32    macRevision;
    A_UINT32    phyRevision;
    A_UINT32    analog5GhzRevision;
    A_UINT32    analog2GhzRevision;

    REG_DOMAIN  regDomain;
    CTRY_CODE   countryCode;
    A_UINT32    regCapBits;

    A_UINT32    keyCacheSize;
    A_UINT32    numTxQueues;
    A_UINT32    wirelessModes;
    A_UINT32    chanSpreadSupport;
    A_UINT32    compressSupport;
    A_UINT32    burstSupport;
    A_UINT32    fastFramesSupport;
    A_UINT32    chapTuningSupport;
    A_UINT32    turboGSupport;
    A_UINT32    turboPrimeSupport;
    A_UINT32    deviceType;

    A_UINT32    low2GhzChan;
    A_UINT32    high2GhzChan;
    A_UINT32    low5GhzChan;
    A_UINT32    high5GhzChan;

    A_UINT32    supportCipherAES_CCM;
    A_UINT32    supportCipherTKIP;
    A_UINT32    supportCipherCKIP;
    A_UINT32    supportMicAES_CCM;
    A_UINT32    supportMicTKIP;
    A_UINT32    supportMicCKIP;
    A_UINT32    twiceAntennaGain5G;
    A_UINT32    twiceAntennaGain2G;
//  ...
} AR_DEV_CAPABILITIES __ATTRIB_ALIGN(8);

typedef struct {
    AR_DEV_STATUS      devStatus;
    AR_DEV_CONFIG      devConfig;
} WDC_ALL_STATUS __ATTRIB_ALIGN(8);


#ifdef __cplusplus
}
#endif

#endif /* _WDCPRIV_H_ */
