#ifndef __WDCTYPES_H__
#define __WDCTYPES_H__

// XXX
#if defined(ECOS_NOTDONE) && defined(SPLIT_ENFORCE)

// THIS FILE IS NOT NAMED CORRECTLY.  IT DOES NOT IMPLY
// "WDC TYPES".  Rather this should be named sharedtypes.h between
// HOST and TARGET

// -- wlan/host/include/wlandrv.h
#define PRIV_KEY_TYPE_WEP       0x0
#define PRIV_KEY_TYPE_WEP_COMP  0x1 /* Artifice to support WEP + compression */
#define PRIV_KEY_TYPE_AES_OCB   0x2
#define PRIV_KEY_TYPE_AES_CCM   0x3
#define PRIV_KEY_TYPE_NULL      0x7
#define PRIV_KEY_TYPE_TKIP      0x10
#define PRIV_KEY_TYPE_TKIP_SW   0x11
#define PRIV_KEY_TYPE_CKIP      0x20
#define PRIV_KEY_TYPE_TKIP      0x10

#define DECRYPTERROR_CRC        0x01  /* Indicates there was a CRC Error */
#define DECRYPTERROR_MIC        0x02  /* Indicates there was a MICError */

#define MAX_REG_ADD_COUNT 129

#define HWINDEX_INVALID         0x7fff          /* hwIndex not allocated */

#define MAX_KEY_LEN_BITS        128
#define MAX_KEY_LEN_BYTES       (MAX_KEY_LEN_BITS / 8)
#define MAX_SHARED_KEYS         4
#define UNIQ_KEY_INDEX          4
#define HWINDEX_INVALID         0x7fff          /* hwIndex not allocated */
#define KEYINDEX_DYNAMIC        0x8000          /* dynamically allocate keyIndex */
#define KEYINDEX_INVALID        0x8001          /* invalid keyTable entry */
#define KEYINDEX_NONE           0x8002          /* implies no crypto in vlan support */

#define KEY_XOR                 0xaa
#define KRK_LENGTH_BYTES        16

#define PRIV_KEY_DESTROY        0x0400          /* Key to be destroyed */

/*
 * WLAN_PRIV_RECORD key types
 */


typedef struct WlanPrivStruct {
    A_UINT32    keyIV;             /* IV generation control */
    A_UINT32    extKeyIV;          /* extended IV field for TKIP & CCM */
    A_UINT32    keyFlags;
    A_UINT32    keyLength;         /* Length of key in bits */
    A_UINT32    keyType;           /* type of key, WEP, TKIP or AES */
    void        *initValue;        /* private data for encryption algorithms */
    A_UINT8     keyVal[32];                     /* Array for key */
    A_UINT8     micTxKeyVal[8];                 /* TX MIC key */
    A_UINT8     micRxKeyVal[8];                 /* RX MIC key */
    A_INT64     keyRSC;                         /* key Rx Seq Counter */
} WLAN_PRIV_RECORD __ATTRIB_ALIGN(8);

typedef struct WlanConnKeyStruct {
    WLAN_MACADDR        bssId;
    WLAN_PRIV_RECORD    connKey;
} CONNECTION_KEY_RECORD __ATTRIB_ALIGN(8);

typedef struct WlanBssKeyStruct {
    A_UINT32            bssKeyIdx;
    A_UINT32            isDefaultBssKey;
    WLAN_PRIV_RECORD    bssKey;
} BSS_KEY_RECORD __ATTRIB_ALIGN(8);

/*
 * Possible value for wlanMode in SIB_ENTRY
 */
#define STA_MODE_A                  0        /* STA operates in 11a mode */
#define STA_MODE_G                  1        /* STA operates in 11g mode */
#define STA_MODE_B                  2        /* STA operates in 11b mode */
#define STA_MODE_108G               3        /* STA operates in 11g turbo mode */


#define RSSI_LPF_LEN       10          // Low pass filter length for averaging RSSI values
#define RSSI_EP_MULTIPLIER 1 << 7      // Powers of two mean compiler optimizes out * and /
#define A_RSSI_OUT(x)      (A_EP_RND((x), RSSI_EP_MULTIPLIER))
#define A_RSSI_IN(x)       (A_EP_MUL((x), RSSI_EP_MULTIPLIER))
#define A_RSSI_LPF(x, y)   (A_LPF((x), A_RSSI_IN((y)), RSSI_LPF_LEN))


#define RATE_LPF_LEN       10          // Low pass filter length for averaging rates
#define RATE_EP_MULTIPLIER 1 << 7      // Powers of two mean compiler optimizes out * and /
#define A_RATE_OUT(x)      (A_EP_RND((x), RATE_EP_MULTIPLIER))
#define A_RATE_IN(x)       (A_EP_MUL((x), RATE_EP_MULTIPLIER))
#define A_RATE_LPF(x, y)   (A_LPF((x), A_RATE_IN((y)), RATE_LPF_LEN))


/*
 * Possible values for protectionType for 11g nonErp protection
 */
#define PROT_TYPE_CTSONLY           0        /* 11g nonErp protection with CTS only */
#define PROT_TYPE_RTSCTS            1        /* 11g nonErp protection with RTS-CTS */

/*
 * Possible values for protectionMode for 11g nonErp protection
 */
#define PROT_MODE_NONE              0        /* 11g nonErp protection never  */
#define PROT_MODE_ALWAYS            1        /* 11g nonErp protection always */
#define PROT_MODE_AUTO              2        /* 11g nonErp protection automatically based on nonERP assoc */

/* NOTE: Changes to AC<->TXQ mapping must propagate to AC_TO_QNUM and QNUM_TO_AC macros */
#define TXQ_ID_FOR_DATA         0       /* default for AP or STA */
#define TXQ_ID_FOR_PSPOLL       1       /* STA only */
#define TXQ_ID_FOR_XR_DATA      1       /* AP only */
#define TXQ_ID_FOR_XR_GRPPOLL   2       /* AP only */
#define TXQ_ID_FOR_XR_BEACON    3       /* AP only */
#define TXQ_ID_FOR_AC0          0       /* WME AC0 (AC_BK), AP or STA */
#define TXQ_ID_FOR_AC1          3       /* WME AC1 (AC_BE), AP or STA */
#define TXQ_ID_FOR_AC2          4       /* WME AC2 (AC_VI), AP or STA */
#define TXQ_ID_FOR_AC3          5       /* WME AC3 (AC_VO), AP or STA */
#define TXQ_ID_FOR_VIDEO        4       /* AP or STA */
#define TXQ_ID_FOR_UPSD         6       /* AP only */
#define TXQ_ID_FOR_GBURST       7
#define TXQ_ID_FOR_GPRS         7       /* AP only */
#define TXQ_ID_FOR_HCF          7       /* AP only */
#define TXQ_ID_FOR_CAB          8
#define TXQ_ID_FOR_BEACON       9
#define QNUM_TO_AC(_q) ( \
    ((_q) == 0) ? ACI_BK : \
    ((_q) == 4) ? ACI_Vi : \
    ((_q) == 5) ? ACI_Vo : \
    ((_q) == 3) ? ACI_BE :  \
    ACI_BE)
#define AC_TO_QNUM(_ac) ( \
    ((_ac) == ACI_BK) ? TXQ_ID_FOR_AC0 : \
    ((_ac) == ACI_Vi) ? TXQ_ID_FOR_AC2 : \
    ((_ac) == ACI_Vo) ? TXQ_ID_FOR_AC3 : \
    ((_ac) == ACI_BE) ? TXQ_ID_FOR_AC1 : \
    TXQ_ID_FOR_AC1)


// --  wlan/host/include/wlanchannel.h
#define CHANNEL_5GHZ      0x2000   // 5 GHz spectrum channel
#define IS_CHAN_5GHZ(x)   MAKE_BOOL(((x) & CHANNEL_5GHZ))

typedef enum ConformanceTestLimits {
    FCC        = 0x10,
    MKK        = 0x40,
    ETSI       = 0x30,
    SD_NO_CTL  = 0xE0,
    NO_CTL     = 0xFF,
    CTL_MODE_M = 3,
    CTL_11A    = 0,
    CTL_11B    = 1,
    CTL_11G    = 2,
    CTL_TURBO  = 3
} ATH_CTLS;



// -- wlanframe.h

#define isFrag(header) \
    (((header)->frameControl.moreFrag == 1) || \
     ((header)->sequenceControl.fragNo != 0))
#define moreFragGet(desc) \
    ((desc)->pBufferVirtPtr.header->frameControl.moreFrag)
#define fragNumGet(desc) \
    WLAN_GET_FRAGNUM((desc)->pBufferVirtPtr.header->seqControl)
#define seqNumGet(desc) \
    WLAN_GET_SEQNUM((desc)->pBufferVirtPtr.header->seqControl)
#define isGrp(macaddr) \
    ((A_BOOL)((macaddr)->octets[0] & 0x01))
#define isBcast(macaddr) \
    (((macaddr)->octets[0] == 0xff))

// -- wlandrv.h



#endif // ECOS_NOTDONE
#endif
