/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines exported routines from ar5212KeyCache.c
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212KeyCache.h#3 $
 */

#ifndef _AR5212_KEYCACHE_H_
#define _AR5212_KEYCACHE_H_

#ifdef _cplusplus
extern "C" {
#endif

A_UINT32
ar5212GetKeyCacheSize(AR_DEV_INFO *pArDev);

void
ar5212ResetKeyCacheEntry(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex);

void
ar5212SetKeyCacheEntry(AR_DEV_INFO *pArDev,
                       A_UINT32 keyCacheIndex, WLAN_MACADDR *pBssId,
                       WLAN_PRIV_RECORD *pKey);

A_UINT16
ar5212SetDecompMask(AR_DEV_INFO *pArDev, A_UINT32 connIdx,
                    A_UINT32 keyType, A_BOOL en);

#if defined(DEBUG) || defined(_DEBUG)

const char *
ar5212DebugGetKeyType(AR_DEV_INFO *pArDev, A_UINT32 keyCacheIndex);

#endif


#ifdef _cplusplus
}
#endif

#endif /* _AR5212_KEYCACHE_H_ */
