/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines exported routines from ar5212Misc.c
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212Misc.h#3 $
 */

#ifndef _AR5212_MISC_H_
#define _AR5212_MISC_H_

#ifdef _cplusplus
extern "C" {
#endif

struct ArDevInfo;

A_STATUS
ar5212EepromRead(AR_DEV_INFO *pArDev, A_UINT32 offset, A_UINT16 *data);

A_BOOL
ar5212GetSerialNumber(AR_DEV_INFO *pArDev, A_CHAR *pSerialNum, A_UINT16 strLen);

A_STATUS
ar5212SetRegulatoryDomain(AR_DEV_INFO *pArDev, A_UINT16 regDomain);

A_STATUS
ar5212GetMacAddr(AR_DEV_INFO *pArDev, WLAN_MACADDR *mac);

void
ar5212EnableRfKill(AR_DEV_INFO *pArDev);

A_BOOL
ar5212GetRfKill(AR_DEV_INFO *pArDev);

void
ar5212SetAntennaSwitch(AR_DEV_INFO *pArDev, ANTENNA_CONTROL settings,
                       CHAN_DESC *pChDesc);

void
ar5212UseShortSlotTime(AR_DEV_INFO *pArDev, A_BOOL en);

void
ar5212SetupClock(AR_DEV_INFO *pArDev);

void
ar5212RestoreClock(AR_DEV_INFO *pArDev);

void
ar5212SetSleepRegisters(AR_DEV_INFO *pArDev, A_BOOL enSlowClockSleep, A_BOOL enPllBandGap);

void
ar5212SetLedState(WLAN_DEV_INFO	*pDev, A_BOOL bConnected);

void
ar5212GpioCfgInput(WLAN_DEV_INFO *pDev, A_UINT32 gpio);

void
ar5212GpioCfgOutput(WLAN_DEV_INFO *pDev, A_UINT32 gpio);

A_UINT32
ar5212GpioGet(WLAN_DEV_INFO *pDev, A_UINT32 gpio);

void
ar5212GpioSet(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val);

void
ar5212GpioSetIntr(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel);

void
ar5212WriteAssocid(WLAN_DEV_INFO *pDev, WLAN_MACADDR *bssid, A_UINT16 assocId);

void
ar5212SetStaBeaconTimers(struct ArDevInfo *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig);

void
ar5212GetTsf(struct ArDevInfo *pArDev, WLAN_TIMESTAMP *tsf);

void
ar5212ResetTsf(WLAN_DEV_INFO *pDev);

void
ar5212SetAdhocMode(AR_DEV_INFO *pArDev);

void
ar5212SetBasicRate(AR_DEV_INFO *pArDev, CONN_RATE_SET *);

A_UINT32
ar5212GetRandomSeed(WLAN_DEV_INFO *pDev);

A_BOOL
ar5212DetectCardPresent(AR_DEV_INFO *pArDev);

A_UINT32
ar5212MibControl(WLAN_DEV_INFO *pDev, HAL_MIB_CMD cmd);

void
ar5212EnableRadarDetection(WLAN_DEV_INFO *pDev, HAL_RADAR_PHY_PARAMS *pPhyParams);

void
ar5212AniControl(WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param);

void
ar5212DumpRegisters(WLAN_DEV_INFO *pDev);

A_UINT32
ar5212GetCurRssi(WLAN_DEV_INFO *pDev);

A_UINT32
ar5212GetDefAntenna(WLAN_DEV_INFO *pDev);

void
ar5212SetDefAntenna(WLAN_DEV_INFO *pDev, A_UINT32 antenna);

void
ar5212UpdateAntenna(AR_DEV_INFO *pDev, AR_CONN_INFO *pSib, int retries,
                    A_UINT8 rssiAck, A_UINT8 curTxAnt);

void
ar5212DmaDebugDump(WLAN_DEV_INFO *pDev);

void
ar5212GetApSwitchHelper(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);

void
ar5212SetApSwitchHelper(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);


/* Auto Noise Immunity */

void
ar5212AniReset(AR_DEV_INFO *pArDev);

void 
ar5212AniPeriodicCheck(AR_DEV_INFO *pArDev);

void 
ar5212AniReceiveCheck(AR_DEV_INFO *pArDev);

A_BOOL
ar5212AniAttach(AR_DEV_INFO *pArDev);

A_STATUS
ar5212ApplyMKKIrreversibleUpdate(AR_DEV_INFO *pDev, A_UINT32 enOddU1, A_UINT32 undoUpdate);

A_STATUS
ar5212MkkLockEeprom(AR_DEV_INFO *pDev, A_BOOL readOnly);

A_STATUS
ar5212RawEepromRead(AR_DEV_INFO *pDev, A_UINT16 offset, A_UINT16 *data);

#ifdef __cplusplus
}
#endif

#endif /* _AR5212_MISC_H_ */
