/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ident "$Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212Phy.c#3 $"

#include "arDev.h"
#include "arPhy.h"
#if !defined(SPLIT_ENFORCE)
#include "wlandrv.h"
#include "wlanPhy.h"
#endif
#include "ar5212Phy.h"

#ifdef BUILD_AR5212
#define TURBO_PRIME 1

#ifdef TURBO_PRIME
static RATE_TABLE ar5212_TurboPrimeARateTable = {
    16,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,   6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,     60,       60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,   9000,  7800,   0x0f,    0x00,        18,   0,       3,       1,     60,       60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM,  12000, 10000,   0x0a,    0x00, (0x80|24),   2,       4,       2,     48,       48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM,  18000, 13900,   0x0e,    0x00,        36,   2,       6,       2,     48,       48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM,  24000, 17300,   0x09,    0x00, (0x80|48),   4,      10,       3,     44,       44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM,  36000, 23000,   0x0d,    0x00,        72,   4,      14,       3,     44,       44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM,  48000, 27400,   0x08,    0x00,        96,   4,      19,       3,     44,       44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM,  54000, 29300,   0x0c,    0x00,       108,   4,      23,       3,     44,       44 },
     /*   6 Mb */ {  TRUE, WLAN_PHY_TURBO,  6000, 10600,   0x0b,    0x00, (0x80|12),   8,       2,       1,     34,       34 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_TURBO,  9000, 15600,   0x0f,    0x00,        18,   8,       3,       1,     34,       34 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_TURBO, 12000, 19400,   0x0a,    0x00, (0x80|24),  10,       4,       2,     30,       30 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_TURBO, 18000, 26900,   0x0e,    0x00,        36,  10,       6,       2,     30,       30 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_TURBO, 24000, 33200,   0x09,    0x00, (0x80|48),  12,      10,       3,     26,       26 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_TURBO, 36000, 43600,   0x0d,    0x00,        72,  12,      14,       3,     26,       26 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_TURBO, 48000, 51300,   0x08,    0x00,        96,  12,      19,       3,     26,       26 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_TURBO, 54000, 55100,   0x0c,    0x00,       108,  12,      23,       3,     26,       26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    5,   /* 36 Mbps for 11a */
    11,  /* 18 Mbps (36 Mbps) for 108a */
    50,  /* packet count threshold */
    7,   /* initial rateMax (index) */
    8    /* # of turboRates */
};
#else
static RATE_TABLE ar5212_11aRateTable = {
    8,  /* number of rates */
    { -1 },
    {/*                                                             short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                 Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,  6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,      60,        60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,  9000,  7800,   0x0f,    0x00,        18,   0,       3,       1,      60,        60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM, 12000, 10000,   0x0a,    0x00, (0x80|24),   2,       4,       2,      48,        48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM, 18000, 13900,   0x0e,    0x00,        36,   2,       6,       2,      48,        48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM, 24000, 17300,   0x09,    0x00, (0x80|48),   4,      10,       3,      44,        44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM, 36000, 23000,   0x0d,    0x00,        72,   4,      14,       3,      44,        44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM, 48000, 27400,   0x08,    0x00,        96,   4,      19,       3,      44,        44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM, 54000, 29300,   0x0c,    0x00,       108,   4,      23,       3,      44,        44 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    0,
    0, 
    0,
    7,   /* initial rateMax (index) */
    0    /* # of turboRates */
};
#endif

static RATE_TABLE ar5212_TurboRateTable = {
    8,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   6 Mb */ {  TRUE, WLAN_PHY_TURBO,  6000,  5400,   0x0b,    0x00, (0x80|12),   0,       2,       1,     34,         34 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_TURBO,  9000,  7800,   0x0f,    0x00,        18,   0,       4,       1,     34,         34 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_TURBO, 12000, 10000,   0x0a,    0x00, (0x80|24),   2,       7,       2,     30,         30 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_TURBO, 18000, 13900,   0x0e,    0x00,        36,   2,       9,       2,     30,         30 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_TURBO, 24000, 17300,   0x09,    0x00, (0x80|48),   4,      14,       3,     26,         26 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_TURBO, 36000, 23000,   0x0d,    0x00,        72,   4,      17,       3,     26,         26 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_TURBO, 48000, 27400,   0x08,    0x00,        96,   4,      22,       3,     26,         26 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_TURBO, 54000, 29300,   0x0c,    0x00,       108,   4,      26,       3,     26,         26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    0,
    0, 
    0,
    7,   /* initial rateMax (index) */
    8    /* # of turboRates */
};

#ifdef TURBO_PRIME
static RATE_TABLE ar5212_TurboPrimeGRateTable = {
    19,  /* number of rates */
    { -1 },
    {/*                                                                short           ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid  phy              Kbps  uKbps   rateCode Preamble dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   1 Mb */ {  TRUE,  WLAN_PHY_CCK,    1000,   900,  0x1b,    0x00,         2,   0,      0,      1,       314,         314 },
     /*   2 Mb */ {  TRUE,  WLAN_PHY_CCK,    2000,  1900,  0x1a,    0x04,         4,   1,      1,      1,       258,         162 },
     /* 5.5 Mb */ {  TRUE,  WLAN_PHY_CCK,    5500,  4900,  0x19,    0x04,        11,   2,      2,      2,       223,         127 },
     /*  11 Mb */ {  TRUE,  WLAN_PHY_CCK,   11000,  8100,  0x18,    0x04,        22,   3,      3,      2,       213,         117 },
     /*   6 Mb */ {  FALSE, WLAN_PHY_OFDM,   6000,  5400,  0x0b,    0x00,        12,   4,      2,      1,        60,          60 },
     /*   9 Mb */ {  FALSE, WLAN_PHY_OFDM,   9000,  7800,  0x0f,    0x00,        18,   4,      3,      1,        60,          60 },
     /*  12 Mb */ {  TRUE,  WLAN_PHY_OFDM,  12000, 10100,  0x0a,    0x00,        24,   6,      4,      1,        48,          48 },
     /*  18 Mb */ {  TRUE,  WLAN_PHY_OFDM,  18000, 14100,  0x0e,    0x00,        36,   6,      6,      2,        48,          48 },
     /*  24 Mb */ {  TRUE,  WLAN_PHY_OFDM,  24000, 17700,  0x09,    0x00,        48,   8,     10,      3,        44,          44 },
     /*  36 Mb */ {  TRUE,  WLAN_PHY_OFDM,  36000, 23700,  0x0d,    0x00,        72,   8,     14,      3,        44,          44 },
     /*  48 Mb */ {  TRUE,  WLAN_PHY_OFDM,  48000, 27400,  0x08,    0x00,        96,   8,     19,      3,        44,          44 },
     /*  54 Mb */ {  TRUE,  WLAN_PHY_OFDM,  54000, 29300,  0x0c,    0x00,       108,   8,     23,      3,        44,          44 },
     /*   6 Mb */ {  TRUE,  WLAN_PHY_TURBO,  6000, 10600,  0x0b,    0x00, (0x80|12),   12,     2,      1,        34,          34 },
     /*  12 Mb */ {  TRUE,  WLAN_PHY_TURBO, 12000, 19400,  0x0a,    0x00,        24,   13,     4,      1,        30,          30 },
     /*  18 Mb */ {  TRUE,  WLAN_PHY_TURBO, 18000, 26900,  0x0e,    0x00,        36,   13,     6,      2,        30,          30 },
     /*  24 Mb */ {  TRUE,  WLAN_PHY_TURBO, 24000, 33200,  0x09,    0x00, (0x80|48),   15,    10,      3,        26,          26 },
     /*  36 Mb */ {  TRUE,  WLAN_PHY_TURBO, 36000, 43600,  0x0d,    0x00,        72,   15,    14,      3,        26,          26 },
     /*  48 Mb */ {  TRUE,  WLAN_PHY_TURBO, 48000, 51300,  0x08,    0x00,        96,   15,    19,      3,        26,          26 },
     /*  54 Mb */ {  TRUE,  WLAN_PHY_TURBO, 54000, 55100,  0x0c,    0x00,       108,   15,    23,      3,        26,          26 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    9,   /* 36 Mbps for 11g */
    14,  /* 18 Mbps (36 Mbps) for 108g */
    50,  /* packet count threshold */
    11,  /* initial rateMax (index) */
    7    /* # of turboRates */
};
#else
/* Venice TODO: roundUpRate() is broken when the rate table does not represent rates
 * in increasing order  e.g.  5.5, 11, 6, 9.    
 * An average rate of 6 Mbps will currently map to 11 Mbps. 
 */
static RATE_TABLE ar5212_11gRateTable = {
    12,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   1 Mb */ {  TRUE,  WLAN_PHY_CCK,   1000,   900,  0x1b,    0x00,         2,   0,       0,       1,       314,       314 },
     /*   2 Mb */ {  TRUE,  WLAN_PHY_CCK,   2000,  1900,  0x1a,    0x04,         4,   1,       1,       1,       258,       162 },
     /* 5.5 Mb */ {  TRUE,  WLAN_PHY_CCK,   5500,  4900,  0x19,    0x04,        11,   2,       2,       2,       223,       127 },
     /*  11 Mb */ {  TRUE,  WLAN_PHY_CCK,  11000,  8100,  0x18,    0x04,        22,   3,       3,       2,       213,       117 },
     /*   6 Mb */ {  FALSE, WLAN_PHY_OFDM, 6000,   5400,  0x0b,    0x00,        12,   4,       2,       1,        60,        60 },
     /*   9 Mb */ {  FALSE, WLAN_PHY_OFDM, 9000,   7800,  0x0f,    0x00,        18,   4,       3,       1,        60,        60 },
     /*  12 Mb */ {  TRUE,  WLAN_PHY_OFDM, 12000, 10000,  0x0a,    0x00,        24,   6,       4,       1,        48,        48 },
     /*  18 Mb */ {  TRUE,  WLAN_PHY_OFDM, 18000, 13900,  0x0e,    0x00,        36,   6,       6,       2,        48,        48 },
     /*  24 Mb */ {  TRUE,  WLAN_PHY_OFDM, 24000, 17300,  0x09,    0x00,        48,   8,      10,       3,        44,        44 },
     /*  36 Mb */ {  TRUE,  WLAN_PHY_OFDM, 36000, 23000,  0x0d,    0x00,        72,   8,      14,       3,        44,        44 },
     /*  48 Mb */ {  TRUE,  WLAN_PHY_OFDM, 48000, 27400,  0x08,    0x00,        96,   8,      19,       3,        44,        44 },
     /*  54 Mb */ {  TRUE,  WLAN_PHY_OFDM, 54000, 29300,  0x0c,    0x00,       108,   8,      23,       3,        44,        44 }
    },
    100, /* probe interval */
    50,  /* rssi reduce interval */
    0,
    0, 
    0,
    11,  /* initial rateMax (index) */
    0    /* # of turboRates */
};
#endif

static RATE_TABLE ar5212_11bRateTable = {
    4,  /* number of rates */
    { -1 },
    {/*                                                             short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                 Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /*   1 Mb */ {  TRUE,  WLAN_PHY_CCK,  1000,  900,  0x1b,    0x00, (0x80| 2),   0,       0,       1,        314,        314 },
     /*   2 Mb */ {  TRUE,  WLAN_PHY_CCK,  2000, 1800,  0x1a,    0x04, (0x80| 4),   1,       1,       1,        258,        162 },
     /* 5.5 Mb */ {  TRUE,  WLAN_PHY_CCK,  5500, 4300,  0x19,    0x04, (0x80|11),   1,       2,       2,        258,        162 },
     /*  11 Mb */ {  TRUE,  WLAN_PHY_CCK, 11000, 7100,  0x18,    0x04, (0x80|22),   1,       4,     100,        258,        162 }
    },
    200, /* probe interval */
    100, /* rssi reduce interval */
    0,
    0, 
    0,
    3,   /* initial rateMax (index) */
    0    /* # of turboRates */
};


static RATE_TABLE ar5212_XrRateTable = {
    12,  /* number of rates */
    { -1 },
    {/*                                                              short            ctrl  RssiAck  RssiAck long Preamble short Preamble*/
     /*              valid                  Kbps  uKbps  rateCode Preamble  dot11Rate Rate ValidMin DeltaMin  ACK Duration   ACK Duration*/
     /* 0.5 Mb */ {  TRUE,   WLAN_PHY_XR,   500,   400,      0x07,    0x00, (0x80| 1),   0,       0,       1,     457,      457 },
     /*   1 Mb */ {  TRUE,   WLAN_PHY_XR,  1000,   900,      0x02,    0x00, (0x80| 2),   1,       1,       1,     228,      228 },
     /*   2 Mb */ {  TRUE,   WLAN_PHY_XR,  2000,  1800,      0x06,    0x00, (0x80| 4),   2,       2,       2,     160,      160 },
     /*   3 Mb */ {  TRUE,   WLAN_PHY_XR,  3000,  2700,      0x01,    0x00, (0x80| 6),   3,       2,       2,     140,      140 },
     /*   6 Mb */ {  TRUE, WLAN_PHY_OFDM,  6000,  5400,      0x0b,    0x00, (0x80|12),   4,       3,       1,      60,       60 },
     /*   9 Mb */ {  TRUE, WLAN_PHY_OFDM,  9000,  7800,      0x0f,    0x00,        18,   4,       3,       1,      60,       60 },
     /*  12 Mb */ {  TRUE, WLAN_PHY_OFDM, 12000, 10000,      0x0a,    0x00, (0x80|24),   6,       4,       1,      48,       48 },
     /*  18 Mb */ {  TRUE, WLAN_PHY_OFDM, 18000, 13900,      0x0e,    0x00,        36,   6,       6,       2,      48,       48 },
     /*  24 Mb */ {  TRUE, WLAN_PHY_OFDM, 24000, 17300,      0x09,    0x00, (0x80|48),   8,      10,       3,      44,       44 },
     /*  36 Mb */ {  TRUE, WLAN_PHY_OFDM, 36000, 23000,      0x0d,    0x00,        72,   8,      14,       3,      44,       44 },
     /*  48 Mb */ {  TRUE, WLAN_PHY_OFDM, 48000, 27400,      0x08,    0x00,        96,   8,      19,       3,      44,       44 },
     /*  54 Mb */ {  TRUE, WLAN_PHY_OFDM, 54000, 29300,      0x0c,    0x00,       108,   8,      23,       3,      44,       44 }
    },
    200, /* probe interval */
    100, /* rssi reduce interval */
    0,
    0, 
    0,
    11,  /* initial rateMax (index) */
    0    /* # of turboRates */
};

void ar5212InitRateCodeToIndex(RATE_TABLE    *pRateTable)
{
    A_UINT8       i;

    /* 
     * finish setting up the rate table for reverse lookup 
     */
    for (i = 0; i < RATE_TABLE_SIZE; ++i) {
        pRateTable->rateCodeToIndex[i] = -1;
    }

    /* 
     * turboPrime - instead of looping from beginning to end of array, 
     * loop in opposite direction 
     */
    for (i = pRateTable->rateCount-1; i < 0xff; i--) {
        A_UINT8 rateCode = pRateTable->info[i].rateCode;

        pRateTable->rateCodeToIndex[rateCode] = i;
        pRateTable->rateCodeToIndex[rateCode | pRateTable->info[i].shortPreamble] = i;
    }
}

void
ar5212AttachRateTables(AR_DEV_INFO *pArDev)
{
    /*
     * Attach device specific rate tables; for ar5212.
     * 11a static turbo and 11g static turbo share the same table.
     * Dynamic turbo uses combined rate table.
     */
    pArDev->hwRateTable[WIRELESS_MODE_TURBO] = &ar5212_TurboRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_TURBO]);

    pArDev->hwRateTable[WIRELESS_MODE_11b]   = &ar5212_11bRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_11b]);

#ifdef TURBO_PRIME
    pArDev->hwRateTable[WIRELESS_MODE_11a]   = &ar5212_TurboPrimeARateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_11a]);

    pArDev->hwRateTable[WIRELESS_MODE_11g]   = &ar5212_TurboPrimeGRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_11g]);
#else
    pArDev->hwRateTable[WIRELESS_MODE_11a]   = &ar5212_11aRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_11a]);

    pArDev->hwRateTable[WIRELESS_MODE_11g]   = &ar5212_11gRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_11g]);
#endif
    pArDev->hwRateTable[WIRELESS_MODE_108g]  = &ar5212_TurboRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_108g]);

    pArDev->hwRateTable[WIRELESS_MODE_XR]    = &ar5212_XrRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_XR]);

#if defined(XR_HACKERY) && (XR_DEFAULT_RATE >= 6000)
    pArDev->hwRateTable[WIRELESS_MODE_XR]    = &ar5212_11aRateTable;
    ar5212InitRateCodeToIndex(pArDev->hwRateTable[WIRELESS_MODE_XR]);
#endif
}

#endif
