/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines exported routines from ar5212Receive.c
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212Receive.h#3 $
 */

#ifndef _AR5212_Receive_H_
#define _AR5212_Receive_H_

#ifdef _cplusplus
extern "C" {
#endif

A_UINT32
ar5212GetRxDP(AR_DEV_INFO *pDev);

void
ar5212SetRxDP(AR_DEV_INFO *pDev, A_UINT32 rxdp);

void
ar5212EnableReceive(AR_DEV_INFO *pDev);

A_STATUS
ar5212StopDmaReceive(AR_DEV_INFO *pDev);

void
ar5212StartPcuReceive(AR_DEV_INFO *pDev);

void
ar5212StopPcuReceive(AR_DEV_INFO *pDev);

void
ar5212SetMulticastFilter(AR_DEV_INFO *pDev, A_UINT32 filter0, A_UINT32 filter1);

void
ar5212MulticastFilterIndex(AR_DEV_INFO *pDev, A_UINT32 index, A_BOOL bSet);

void
ar5212SetRxFilter(AR_DEV_INFO *pDev, A_UINT32 bits);

A_STATUS
ar5212ProcessRxDesc(AR_DEV_INFO *pDev, AR_DESC *pDesc);

void
ar5212SetupRxDesc(AR_DESC *pDesc, A_UINT32 size);

A_BOOL
ar5212GetPcuState(AR_DEV_INFO *pDev);

#ifdef UPSD
void
ar5212UpsdResponse(AR_DEV_INFO *pDev);
void
ar5212PProcessRxDesc(AR_DEV_INFO);
#endif

#ifdef _cplusplus
}
#endif

#endif /* _AR5212_Receive_H_ */
