/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines exported routines from ar5212Reset.c
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212Reset.h#3 $
 */

#ifndef _AR5212_RESET_H_
#define _AR5212_RESET_H_

#ifdef _cplusplus
extern "C" {
#endif

A_STATUS
ar5212ChipReset(AR_DEV_INFO *pArDev, CHAN_DESC *pChDesc);

A_STATUS
ar5212Reset(AR_DEV_INFO *pArDev, WLAN_SERVICE serviceType, CHAN_DESC *pChDesc, A_BOOL bChannelChange);

A_STATUS
ar5212PerCalibration(AR_DEV_INFO *pArDev, CHAN_DESC *pChDesc);

A_STATUS
ar5212SleepExit(AR_DEV_INFO *pArDev);

A_STATUS
ar5212Disable(AR_DEV_INFO *pArDev);

A_STATUS
ar5212PhyDisable(AR_DEV_INFO *pArDev);

RFGAIN_STATES
ar5212GetRfgain(AR_DEV_INFO *pArDev);

void
ar5212InitializeGainValues(AR_DEV_INFO *pArDev, struct gainValues *pGainValues);

A_BOOL
ar5212AllocateRfBanks(AR_DEV_INFO *pArDev, HAL_INFO *pHalInfo);

void
ar5212FreeRfBanks(AR_DEV_INFO *pArDev, HAL_INFO *pHalInfo);

void
ar5212SetTxPowerLimit(AR_DEV_INFO *pArDev, A_UINT32 limit);

A_STATUS
ar5212MacStop(AR_DEV_INFO *pArDev);

extern const struct RfHalFuncs ar5112Funcs;

#ifdef _cplusplus
}
#endif

#endif /* _AR5212_RESET_H_ */
