/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines exported routines from ar5212Transmit.c
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/ar5212/ar5212Transmit.h#3 $
 */

#ifndef _AR5212_Transmit_H_
#define _AR5212_Transmit_H_

#ifdef _cplusplus
extern "C" {
#endif

A_BOOL
ar5212UpdateTxTrigLevel(AR_DEV_INFO *pArDev, A_BOOL bIncTrigLevel);

int
ar5212SetupTxQueue(AR_DEV_INFO *pArDev, HAL_TX_QUEUE_INFO *queueInfo);

void
ar5212ReleaseTxQueue(AR_DEV_INFO *pArDev, int queueNum);

A_UINT32
ar5212GetTxDP(AR_DEV_INFO *pArDev, int queueNum);

void
ar5212SetTxDP(AR_DEV_INFO *pArDev, int queueNum, A_UINT32 txdp);

void
ar5212StartTxDma(AR_DEV_INFO *pArDev, int queueNum);

A_UINT32
ar5212NumTxPending(AR_DEV_INFO *pArDev, int queueNum);

void
ar5212StopTxDma(AR_DEV_INFO *pArDev, int queueNum, int msec);


/* Descriptor Access Functions */

void
ar5212SetupTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_UINT32 hwIndex);

A_STATUS
ar5212ProcessTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc);

A_BOOL
ar5212GetTxDescDone(AR_DEV_INFO *pArDev, AR_DESC *pDesc);

#if defined(DEBUG) || defined(_DEBUG)
void
ar5212DebugPrintTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_BOOL verbose);
#endif

#ifdef _cplusplus
}
#endif

#endif /* _ar5212_Transmit_H_ */
