#ifndef __AR5212DEBUG_H__
#define __AR5212DEBUG_H__

// Defined to GDB symbol debugging

#ifdef BIG_ENDIAN

typedef struct {
    A_UINT32   RES0:4,          // 31-28
	       QTRIG_PI:1,      // 27     
	       QCBURN_PI:1,     // 26
	       QCBROVF_PI:1,    // 25
	       GPIO_PI:1,       // 24
	       BCNMISC_PI:1,    // 23
	       RES1:1,          // 22
	       RXCHIRP:1,       // 21
	       BNR_PI:1,        // 20
	       HIUERR_PI:1,     // 19
	       BMISS_PI:1,      // 18
	       BRSSI_PI:1,      // 17
	       SWBA_PI:1,       // 16
	       RXKCM_PI:1,      // 15
	       RXPHY_PI:1,      // 14
	       SWI_PI:1,        // 13
	       MIB_PI:1,        // 12 
	       TXURN_PI:1,      // 11
	       TXEOL_PI:1,      // 10 
	       TXNOFRM_PI:1,    // 9
	       TXERR_PI:1,      // 8
	       TXDESC_PI:1,     // 7
	       TXOK_PI:1,       // 6
	       RXORN_PI:1,      // 5
	       RXEOL_PI:1,      // 4
	       RXNOFRM_PI:1,    // 3
	       RXERR_PI:1,      // 2
	       RXDESC_PI:1,     // 1
	       RXOK_PI:1;       // 0
} AR5212_ISR_P, AR5212_IMR_P;

typedef struct {
    A_UINT32   RES0:6,          // 31-26
               TXDESC_SI:10,    // 25-16
               RES1:6,          // 15-10
               TXOK_SI:10;      // 9-0
} AR5212_ISR_S0, AR5212_IMR_S0;


typedef struct {
    A_UINT32   RES0:6,          // 31-26
               TXEOL_SI:10,     // 25-16
               RES1:6,          // 15-10
               TXERR_SI:10;     // 9-0
} AR5212_ISR_S1, AR5212_IMR_S1;

typedef struct {
    A_UINT32   RES0:3,
               DTIM:1,
               CABTO:1,
               BCNTO:1,
               DTIMSYNC:1,
               CABEND:1,
               TIM:1,
               RES:4,
               DPERR_SI:1,
               SSERR_SI:1,
               MCABT_SI:1,
               RES2:6,
               TXURN_S1:10;
} AR5212_ISR_S2, AR5212_IMR_S2;

typedef struct {
    A_UINT32   STA_ADDR_L32;
} AR5212_STA_ADDR_L32;

typedef struct {
    A_UINT32   ADHOC_MCAST_SEARCH:1,
               CBCIV_ENDIAN:1,
   	           PRESERVE_SEQNUM:1,
               KSRCH_MODE:1,
	           CRPT_MIC_ENABLE:1,
	           SECTOR_SELF_GEN:1,
	           BASE_RATE_11B:1,
	           ACKCTS_6MB:1,
	           RTS_USE_DEF:1,
	           DEFANT_UPDATE:1,
	           USE_DEFANT:1,
	           PCF:1,
	           NO_KEYSRCH:1,
	           PWR_SV:1,
	           ADHOC:1,
	           AP:1,
	           STA_ADDR_U16:16;
} AR5212_STA_ADDR_U32;

typedef struct {
    A_UINT32   BSSID_L32;
} AR5212_BSS_ID0;

typedef struct {
    A_UINT32   AID:16,
	           BSSID_U16:16;	   
} AR5212_BSS_ID1;

typedef struct {
    A_UINT32   RES:16,
               BEACON_MISS:8,
               RSSI_THR:8;
} AR5212_RSSI_THR;

typedef struct {
    A_UINT32   RES:16,
               BEACONCNT:16;
} AR5212_BEACONCNT;

typedef struct {
    A_UINT32   RES:7,
               RESET_TSF:1,
               RES1:1,
               TIM_OFFSET:7,
               BEACON_PERIOD:16;
} AR5212_BEACON;


typedef struct {
    A_UINT32   RES:16,
               NEXT_BEACON:16;
} AR5212_NEXT_BEACON;

typedef struct {
    A_UINT32   CAB_TIMEOUT:8,
               RES:3,
               SLEEP_ENABLE:1,
               ASSUME_DTIM:1,
               NEXT_DTIM:19;
} AR5212_SLEEP1;

typedef struct {
    A_UINT32   TFS_L32;
} AR5212_TSF_L32;

typedef struct {
    A_UINT32   TFS_U32;
} AR5212_TSF_U32;

typedef struct {
    A_UINT32   RES:24,
               TSF_INCREMENT:8;
} AR5212_TSF; 

typedef struct {
    A_UINT32   RX_LATENCY:9,
               TX_LATENCY:9,
               USEC32:7,
               USEC:7;
} AR5212_USEC;

typedef struct {
    A_UINT32   LAST_TSTP;
} AR5212_LAST_TSTP;

typedef struct {
    A_UINT32   RES:10,
               SLEEP_PERF_COUNTER_MIB_ENABLE:1,
               SLEEP_POLICY:1,
               SLSETCTL:1,
               SLRSTCTL:1,
               SLE:2,
               SLDUR:16;
} AR5212_SCR;

typedef struct {
    A_UINT32   RES:27,
               RPCI:1,
               RES1:2,
               RBB:1,
               RMAC:1;
} AR5212_RC;



typedef struct {
    A_UINT32    RES:15,
               DCU_INTERFRAME_CACHING_DISABLE:1,
               DCU_DOUBLE_BUFFER_DISABLE:1,                               
               RDYDIS:1,
               RES2:1,
               FRAGBURST:1,
               ADHOCBEACON:1,
               JUMBOTXD:1,
               TXFULL:6,
               RES3:1,
               SDMAMR:3;
} AR5212_TXCFG;


typedef struct {
    A_UINT32   RES:17,
               FPBURSTEN:10,
               FPNORMALEN:1,
               FPDCUSEL:4;
} AR5212_FPCTL;




#endif 

#endif
