/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines header objects used INTERNALLY by the HAL layer
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/hal.h#3 $
 */

#ifndef _HAL_H_
#define _HAL_H_

#ifdef _cplusplus
extern "C" {
#endif

/* JK -remove later */
#include "arDev.h"

typedef enum {
    IQ_CAL_INACTIVE,
    IQ_CAL_RUNNING,
    IQ_CAL_DONE,
} IQ_CAL_STATES;


#define HAL_NUM_TX_QUEUES   10
#define HAL_COMP_BUF_MAX_SIZE   9216            /* 9K */
#define HAL_COMP_BUF_ALIGN_SIZE 512


/* Storage for HAL-specific items */
typedef struct HalInfo {
    struct eepMap       *pEepData;          /* Holds all info read from EEPROM on first reset */
    struct gainValues   *pGainValues;       /* The thermal gain adjustment structure */
    A_UINT32            txQueueAllocMask;   /* Holds the allocation vector for tx queues */
    A_UINT32            txNormalIntMask;    /* Holds the Normal Interrupt bits for the Queues */
    A_UINT32            txDescIntMask;      /* Holds the Desc Interrupt bits for the Queues */
    A_UINT32            globIntRefCount;    /* Reference count for global interrupt enable */
    const struct RfHalFuncs *pRfHal;        /* Used for RF Hal */
#if defined(EAR_SUPPORT)
    struct earHeader    *pEarHead;          /* All EAR information */
#endif
    void                *pAnalogBanks;      /* Analog Bank scratchpad */
    A_UINT32            txPowerIndexOffset; /* Offset of transmit power table */
    A_UINT32            ofdmTxPower;        /* Tracks the nominal OFDM tx power level - mostly for probe requests */
    IQ_CAL_STATES       iqCalState;         /* Current state of IQ calibration */
    RFGAIN_STATES       rfgainState;        /* Current state of rfgain */
    A_CHAR              serialNumber[13];   /* Null terminated serial number */
    A_UINT16            *pRawEeprom;        /* Raw EEPROM (during startup) */
    A_UINT32            rawEepromSz;        /* Size of raw EEPROM data */
} HAL_INFO;

#define ANT_SWITCH_TABLE1 0x9960
#define ANT_SWITCH_TABLE2 0x9964

#define RX_FLIP_THRESHOLD 3 /* Count successful Tx before switching Rx Ant */


#if defined(ECOS_NOTDONE)
    typedef void * WLAN_RATE_SET;
    typedef void * SIB_ENTRY;
    typedef void * ATHEROS_DESC;
#endif


/* The device specific function list for the HW layer */
typedef struct HwFuncs {
    A_STATUS  (*hwDevInit)(AR_DEV_INFO *pArDev);
    A_STATUS  (*hwDevFini)(AR_DEV_INFO *pArDev);
    A_STATUS  (*hwFillCapabilityInfo)(AR_DEV_INFO *pArDev);

    /* Reset Functions */
    A_STATUS  (*hwReset)(AR_DEV_INFO *pArDev, WLAN_SERVICE serviceType, CHAN_DESC *pChDesc, A_BOOL bChannelChange);
    A_STATUS  (*hwPhyDisable)(AR_DEV_INFO *pArDev);
    A_STATUS  (*hwDisable)(AR_DEV_INFO *pArDev);
    A_STATUS  (*hwPerCalibration)(AR_DEV_INFO *pArDev, CHAN_DESC *pChDesc);
    RFGAIN_STATES (*hwGetRfgain)(AR_DEV_INFO *pArDev);
    void      (*hwSetTxPowerLimit)(AR_DEV_INFO *pArDev, A_UINT32 limit);

    /* TX Functions */
    A_BOOL    (*hwUpdateTxTrigLevel)(AR_DEV_INFO *pArDev, A_BOOL bIncTrigLevel);
    int       (*hwSetupTxQueue)(AR_DEV_INFO *pArDev, HAL_TX_QUEUE_INFO *queueInfo);
    void      (*hwReleaseTxQueue)(AR_DEV_INFO *pArDev, int queueNum);
    A_UINT32  (*hwGetTxDP)(AR_DEV_INFO *pArDev, int queueNum);
    void      (*hwSetTxDP)(AR_DEV_INFO *pArDev, int queueNum, A_UINT32 txdp);
    void      (*hwStartTxDma)(AR_DEV_INFO *pArDev, int queueNum);
    A_UINT32  (*hwNumTxPending)(AR_DEV_INFO *pArDev, int queueNum);
    void      (*hwStopTxDma)(AR_DEV_INFO *pArDev, int queueNum, int msec);

    void      (*hwSetupTxDesc)(AR_DEV_INFO *pArDev, AR_DESC *pTxDesc, A_UINT32 hwIndex);
    A_STATUS  (*hwProcessTxDesc)(AR_DEV_INFO *pArDev, AR_DESC *pTxDesc);
    A_BOOL    (*hwGetTxDescDone)(AR_DEV_INFO *pArDev, AR_DESC *pDesc);

#if defined(DEBUG) || defined(_DEBUG)
    void      (*hwDebugPrintTxDesc)(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_BOOL verbose);
#endif

    /* RX Functions */
    A_UINT32  (*hwGetRxDP)(AR_DEV_INFO *pDev);
    void      (*hwSetRxDP)(AR_DEV_INFO *pDev, A_UINT32 rxdp);
    void      (*hwEnableReceive)(AR_DEV_INFO *pDev);
    A_STATUS  (*hwStopDmaReceive)(AR_DEV_INFO *pDev);
    void      (*hwStartPcuReceive)(AR_DEV_INFO *pDev);
    void      (*hwStopPcuReceive)(AR_DEV_INFO *pDev);
    void      (*hwSetMulticastFilter)(AR_DEV_INFO *pDev, A_UINT32 filter0, A_UINT32 filter1);
    void      (*hwMulticastFilterIndex)(AR_DEV_INFO *pDev, A_UINT32 index, A_BOOL bSet);
    void      (*hwSetRxFilter)(AR_DEV_INFO *pDev, A_UINT32 bits);
    A_STATUS  (*hwProcessRxDesc)(AR_DEV_INFO *pDev, AR_DESC *pDesc);
#ifdef UPSD
    void      (*hwPProcessRxDesc)(AR_DEV_INFO *pDev);
#endif
    void      (*hwSetupRxDesc)(AR_DESC *pDesc, A_UINT32 size);
    A_BOOL    (*hwGetPcuState)(AR_DEV_INFO *pDev);

    /* Misc Functions */
    A_STATUS  (*hwSetRegulatoryDomain)(AR_DEV_INFO *pArDev, A_UINT16 regDomain);
    void      (*hwSetLedState)(WLAN_DEV_INFO *pDev, A_BOOL bConnected);
    void      (*hwWriteAssocid)(WLAN_DEV_INFO *pDev, WLAN_MACADDR *bssid, A_UINT16 assocId);
    void      (*hwGpioCfgInput)(WLAN_DEV_INFO *pDev, A_UINT32 gpio);
    void      (*hwGpioCfgOutput)(WLAN_DEV_INFO *pDev, A_UINT32 gpio);
    A_UINT32  (*hwGpioGet)(WLAN_DEV_INFO *pDev, A_UINT32 gpio);
    void      (*hwGpioSet)(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val);
    void      (*hwGpioSetIntr)(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel);
    void      (*hwSetStaBeaconTimers)(struct ArDevInfo *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig);
    void      (*hwGetTsf)(struct ArDevInfo *pArDev, WLAN_TIMESTAMP *tsf);
    void      (*hwResetTsf)(WLAN_DEV_INFO *pDev);
    void      (*hwSetAdhocMode)(AR_DEV_INFO *pArDev);
    void      (*hwSetBasicRate)(WLAN_DEV_INFO *pDev, CONN_RATE_SET *);
    A_UINT32  (*hwGetRandomSeed)(WLAN_DEV_INFO *pDev);
    A_BOOL    (*hwDetectCardPresent)(AR_DEV_INFO *pArDev);
    A_UINT32  (*hwMibControl)(WLAN_DEV_INFO *pDev, HAL_MIB_CMD cmd);
    void      (*hwEnableRadarDetection)(WLAN_DEV_INFO *pDev, HAL_RADAR_PHY_PARAMS *pPhyParams);
    void      (*hwAniControl)(WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param);
    A_UINT32  (*hwGetCurRssi)(WLAN_DEV_INFO *pDev);
    A_UINT32  (*hwGetDefAntenna)(WLAN_DEV_INFO *pDev);
    void      (*hwSetDefAntenna)(WLAN_DEV_INFO *pDev, A_UINT32 antenna);
    void      (*hwSetAntennaSwitch)(AR_DEV_INFO *pArDev, ANTENNA_CONTROL settings, CHAN_DESC *pChDesc);
    void      (*hwUpdateAntenna)(AR_DEV_INFO *, AR_CONN_INFO *, int retries, A_UINT8 rssiAck, A_UINT8 curTxAnt);
    void      (*hwUseShortSlotTime)(AR_DEV_INFO *pArDev, A_BOOL en);
    void      (*hwDmaDebugDump)(WLAN_DEV_INFO *pDev);
    A_UINT16  (*hwSetDecompMask)(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex,
                                 A_UINT32 keyType, A_BOOL en);
    void      (*hwGetApSwitchHelper)(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);
    void      (*hwSetApSwitchHelper)(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);

    /* Key Cache Functions */
    A_UINT32  (*hwGetKeyCacheSize)(AR_DEV_INFO *pArDev);
    void      (*hwResetKeyCacheEntry)(AR_DEV_INFO *pArDev,
                                       A_UINT16 keyCacheIndex);
    void      (*hwSetKeyCacheEntry)(AR_DEV_INFO *pArDev,
                                    A_BOOL connId, A_UINT32 rawIdx,
                                    A_UINT32 msgLen, TARGET_CONFIG_VAL msgVal);
    void      (*hwSetKeyCacheBssid)(AR_DEV_INFO  *pArDev,
                                    A_UINT32     connIdx,
                                    WLAN_MACADDR *pBssId);
    A_UINT16  (*hwKeyCacheAlloc)(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex,
                                 A_UINT16 keyType,
                                 A_BOOL *pHwEncrypt);
    void      (*hwKeyCacheFree)(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex);

    /* Power Management Functions */
    A_STATUS  (*hwSetPowerMode)(AR_DEV_INFO *pArDev, A_UINT32 powerRequest, A_BOOL setChip);
    A_UINT32  (*hwGetPowerMode)(AR_DEV_INFO *pArDev);
    A_BOOL    (*hwGetPowerStatus)(AR_DEV_INFO *pArDev);
    void      (*hwSetupPSPollDesc)(AR_DEV_INFO *pArDev, AR_DESC *pPSPollDesc);

    /* Beacon Functions */
    void      (*hwSetupBeaconDesc)(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_UINT32 antMode, A_BOOL isAp);
    void      (*hwBeaconInit)(AR_DEV_INFO *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig);
    void      (*hwSetupGrpPollChain)(AR_DEV_INFO *pArDev, AR_DESC *pHead,
                                     AR_DESC *pTail, A_UINT32 hwIndex);

    /* Interrupt Functions */
    A_BOOL    (*hwIsInterruptPending)(AR_DEV_INFO *pArDev);
    HAL_INT_TYPE (*hwGetInterrupts)(AR_DEV_INFO *pArDev, HAL_INT_TYPE *pUnmaskedValue,A_UINT32 *pQueueBitMask);
    void      (*hwEnableInterrupts)(AR_DEV_INFO *pArDev, HAL_INT_TYPE ints);
    void      (*hwDisableInterrupts)(AR_DEV_INFO *pArDev, HAL_INT_TYPE ints);
#ifdef UPSD
    void      (*hwUpsdResponse)(WLAN_DEV_INFO *pDev);
#endif
} HW_FUNCS;

extern const char *halFrameTypeToName[];

#if defined(DEBUG)
extern int GainDebug;
#endif

#ifdef _cplusplus
}
#endif

#endif /* _HAL_H */
