/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines the MAC/PHY Hardware Abstraction Layer (HAL) API as well as commonly
 * used types and structs.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halApi.h#6 $
 */

#ifndef _HAL_API_H_
#define _HAL_API_H_

#ifdef _cplusplus
extern "C" {
#endif

struct ArDevInfo;
struct ArDesc;
struct chanDesc;
struct wlanDevInfo;         // xxxamanxxx: to go away
struct channelValues;       // xxxamanxxx: to go away
struct atherosDesc;         // xxxamanxxx: to go away
struct sibEntry;            // xxxamanxxx: to go away
struct WlanPrivStruct;      // xxxamanxxx: to go away
struct WlanRateSet;         // xxxamanxxx: to go away

#if !defined(ECOS_NOTDONE)
#define __WLAN_DEV_INFO struct wlanDevInfo
#else
#define __WLAN_DEV_INFO struct ArDevInfo
#endif

A_STATUS
halDevInit(struct ArDevInfo *);

A_UINT32
halGetNumDevid(void);

A_UINT16
halGetDevids(A_UINT32 index);

A_STATUS
halDevFini(struct ArDevInfo *);

A_STATUS
halFillCapabilityInfo(struct ArDevInfo *);

/* Reset Functions */
A_STATUS
halReset(struct ArDevInfo *pArDev, WLAN_SERVICE serviceType,
         struct chanDesc *pChDesc, A_BOOL bChannelChange);

A_STATUS
halPhyDisable(struct ArDevInfo *pArDev);

A_STATUS
halDisable(struct ArDevInfo *pArDev);

A_STATUS
halPerCalibration(struct ArDevInfo *pArDev, struct chanDesc *pChDesc);

void
halSetTxPowerLimit(struct ArDevInfo *pArDev, A_UINT32 limit);
#define MAX_TX_POWER 0xffffffff

/* Transmit Functions */

A_BOOL
halUpdateTxTrigLevel(struct ArDevInfo *pArDev, A_BOOL bIncTrigLevel);

typedef struct HalTxQueueInfo {
    enum {
        TXQ_MODE_INACTIVE = 0,
        TXQ_MODE_NORMAL,
        TXQ_MODE_BEACON,        /* implies TBTT gated queue */
        TXQ_MODE_CAB,           /* implies beacon gated queue */
        TXQ_MODE_PSPOLL         /* implies TIM gated queue */
    }           mode;
    enum {
        TXQ_FLAG_TXINT_ENABLE       = 0x0001,   /* Flag to have TXOK,TXERR Interrupts */
        TXQ_FLAG_TXDESCINT_ENABLE   = 0x0002,   /* Flag to have TXDESC     Interrupts */
        TXQ_FLAG_BACKOFF_DISABLE    = 0x0004,   /* Flag to disable Post Backoff  */
        TXQ_FLAG_COMPRESSION_ENABLE = 0x0008    /* Flag to compression enabled */
    }           qFlags;
    A_UINT32    priority;       /* for now: hacked to map to queueNum */
    A_UINT32    aifs;
    A_UINT32    logCwMin;
    A_UINT32    logCwMax;
    A_UINT32    cbrPeriod;
    A_UINT32    cbrOverflowLimit;
    A_UINT32    burstTime;
    A_UINT32    readyTime;
    A_UINT32    physCompBuf;                    /* Compression buffer */
} HAL_TX_QUEUE_INFO;

int
halSetupTxQueue(struct ArDevInfo *pDev, HAL_TX_QUEUE_INFO* queueInfo);

void
halReleaseTxQueue(struct ArDevInfo *pDev, int queueNum);

A_UINT32
halGetTxDP(struct ArDevInfo *pDev, int queueNum);

void
halSetTxDP(struct ArDevInfo *pDev, int queueNum, A_UINT32 txdp);

void
halStartTxDma(struct ArDevInfo *pDev, int queueNum);

A_UINT32
halNumTxPending(struct ArDevInfo *pDev, int queueNum);

void
halStopTxDma(struct ArDevInfo *pDev, int queueNum, int msec);

/* Transmit Desriptor Functions */

void
halSetupTxDesc(struct ArDevInfo *pArDev, struct ArDesc *pTxDesc, A_UINT32 hwIndex);

A_STATUS
halProcessTxDesc(struct ArDevInfo *pArDev, struct ArDesc *pTxDesc);

A_BOOL
halGetTxDescDone(struct ArDevInfo *pArDev, struct ArDesc *pTxDesc);

#if defined(DEBUG) || defined(_DEBUG)
void
halDebugPrintTxDesc(struct ArDevInfo *pArDev, struct ArDesc *pDesc, A_BOOL verbose);
#endif

/* Receive Functions */

A_UINT32
halGetRxDP(struct ArDevInfo *pDev);

void
halSetRxDP(struct ArDevInfo *pDev, A_UINT32 rxdp);

void
halEnableReceive(struct ArDevInfo *pDev);

A_STATUS
halStopDmaReceive(struct ArDevInfo *pDev);

void
halStartPcuReceive(struct ArDevInfo *pDev);

void
halStopPcuReceive(struct ArDevInfo *pDev);

A_BOOL
halGetPcuState(struct ArDevInfo *pDev);

void
halSetMulticastFilter(struct ArDevInfo *pDev, A_UINT32 filter0, A_UINT32 filter1);

void
halMulticastFilterIndex(struct ArDevInfo *pDev, A_UINT32 index, A_BOOL bSet);

void
halSetRxFilter(struct ArDevInfo *pDev, A_UINT32 bits);

A_STATUS
halProcessRxDesc(struct ArDevInfo *pDev, struct ArDesc *pDesc);

#if (defined(UPSD) && defined(BUILD_AP))
void
halUpsdResponse(struct ArDevInfo *pDev);
#endif

void
halSetupRxDesc(struct ArDevInfo *pDev, struct ArDesc *pDesc, A_UINT32 size);

/* Misc Functions */
typedef enum {
    /* Direct mapped to storage - must be in order */
    HAL_GET_REG_DMN,
    HAL_GET_WIRELESS_MODES,
    HAL_GET_CHAN_SPREAD_SUPPORT,
    HAL_GET_SLEEP_AFTER_BEACON_SUPPORT,
    HAL_GET_COMPRESS_SUPPORT,
    HAL_GET_BURST_SUPPORT,
    HAL_GET_FAST_FRAME_SUPPORT,
    HAL_GET_CHAP_TUNING_SUPPORT,
    HAL_GET_TURBO_G_SUPPORT,
    HAL_GET_TURBO_PRIME_SUPPORT,
    HAL_GET_DEVICE_TYPE,

    /* Multiple storage items with no direct storage map */
    HAL_GET_LOW_CHAN_EDGE,
    HAL_GET_HIGH_CHAN_EDGE,
    HAL_END_CAPABILITY_TYPE
} HAL_CAPABILITY_TYPE;

A_BOOL
halGetSerialNumber(struct ArDevInfo *pDev, A_CHAR *pSerialNum, A_UINT16 strLen);

A_STATUS
halSetRegulatoryDomain(struct ArDevInfo *pDev, A_UINT16 regDomain);

void
halSetLedState(__WLAN_DEV_INFO *pDev, A_BOOL bConnected);

void
halWriteAssocid(struct ArDevInfo *, WLAN_MACADDR *bssid, A_UINT16 assocId);

void
halGpioCfgInput(__WLAN_DEV_INFO *pDev, A_UINT32 gpio);

void
halGpioCfgOutput(__WLAN_DEV_INFO *pDev, A_UINT32 gpio);

A_UINT32
halGpioGet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio);

void
halGpioSet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val);

void
halGpioSetIntr(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel);

void
halSetStaBeaconTimers(struct ArDevInfo *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig);

void
halGetTsf(struct ArDevInfo *pArDev, WLAN_TIMESTAMP *tsf);

void
halResetTsf(struct ArDevInfo *pArDev);

void
halSetAdhocMode(struct ArDevInfo *pArDev);

void
halSetBasicRate(struct ArDevInfo *pArDev, CONN_RATE_SET *);

A_UINT32
halGetRandomSeed(struct ArDevInfo *pDev);

A_BOOL
halDetectCardPresent(struct ArDevInfo *pArDev);

typedef enum {
    UPDATE_SW_COMMON = 1,
    UPDATE_SW_ALL,
    GET_CCA_PERCENTAGE,
    CLEAR_ALL_COUNTERS
} HAL_MIB_CMD;

A_UINT32
halMibControl(struct ArDevInfo, HAL_MIB_CMD cmd);

typedef struct HalRadarPhyParams {
    A_INT32 firpwr;
    A_INT32 radarRssi;
    A_INT32 height;
    A_INT32 pulseRssi;
    A_INT32 inband;
} HAL_RADAR_PHY_PARAMS;

void
halEnableRadarDetection(__WLAN_DEV_INFO *pDev, HAL_RADAR_PHY_PARAMS *pPhyParams);

typedef enum {
    SET_NOISE_IMMUNITY_LEVEL = 1,
    SET_OFDM_WEAK_SIGNAL_DETECTION,
    SET_CCK_WEAK_SIGNAL_THR,
    SET_FIRSTEP_LEVEL,
    SET_SPUR_IMMUNITY_LEVEL
} HAL_ANI_CMD;

void
halAniControl(__WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param);

A_UINT32
halGetCurRssi(struct ArDevInfo *pArDev);

A_UINT32
halGetDefAntenna(__WLAN_DEV_INFO *pDev);

void
halSetDefAntenna(__WLAN_DEV_INFO *pDev, A_UINT32 antenna);

void
halSetAntennaSwitch(struct ArDevInfo *pArDev, ANTENNA_CONTROL settings,
                    struct chanDesc *pChDesc);

void
halUpdateAntenna(struct ArDevInfo *, struct ArConnInfo *, int retries, A_UINT8 rssiAck, A_UINT8 curTxAnt);

void
halUseShortSlotTime(struct ArDevInfo *, A_BOOL en);

void
halDmaDebugDump(struct ArDevInfo *pArDev);

A_UINT16
halSetDecompMask(struct ArDevInfo *pArDev, A_UINT16 keyCacheIndex,
                 A_UINT32 keyType, A_BOOL en);

typedef struct save_six_reg {
    A_UINT32    r1;
    A_UINT32    r2;
    A_UINT32    r3;
    A_UINT32    r4;
    A_UINT32    r5;
    A_UINT32    r6;
} SAVE_SIX_REG;

void
halGetApSwitchHelper(__WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);

void
halSetApSwitchHelper(__WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs);

/* Key Cache Functions */
A_UINT32
halGetKeyCacheSize(struct ArDevInfo *pArDev);

void
halResetKeyCacheEntry(struct ArDevInfo *pArDev, A_UINT16 keyCacheIndex);

void
halSetKeyCacheEntry(struct ArDevInfo *pArDev,
                    A_UINT32 keyCacheIndex, WLAN_MACADDR pBssId,
                    WLAN_PRIV_RECORD *pKey);

enum halPowerModes {
    AWAKE,
    FULL_SLEEP,
    NETWORK_SLEEP,
    DEVICE_SLEEP,
    DEVICE_WAKE
};

/* Power Management Functions */
A_STATUS
halSetPowerMode(struct ArDevInfo *pArDev, A_UINT32 powerRequest, A_BOOL setChip);

A_UINT32
halGetPowerMode(struct ArDevInfo *pArDev);

A_BOOL
halGetPowerStatus(struct ArDevInfo *pArDev);

void
halSetupPSPollDesc(struct ArDevInfo *pArDev, struct ArDesc *pPSPollDesc);

void
halSetupBeaconDesc(struct ArDevInfo *pArDev, struct ArDesc *pDesc, A_UINT32 antMode, A_BOOL isAp);

void
halBeaconInit(struct ArDevInfo *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig);

void
halSetupGrpPollChain(struct ArDevInfo *pArDev, struct ArDesc *pHead, struct ArDesc *pTail, A_UINT32 hwIndex);

/* Interrupt functions */

/*
 * NOTE WELL:
 * These are mapped to take advantage of the common locations for many of
 * the bits on all of the currently supported MAC chips. This is to make the ISR
 * as efficient as possible, while still abstracting HW differences. When new
 * hardware breaks this commonality this enumerated type, as well as the HAL
 * functions using it, must be modified. All values are directly mapped unless
 * commented otherwise.
 */
typedef enum HalIntType {
    HAL_INT_RX      = 0x00000001,   /* Non-common mapping */
    HAL_INT_RXEOL   = 0x00000010,
    HAL_INT_RXORN   = 0x00000020,
    HAL_INT_TX      = 0x00000040,   /* Non-common mapping */
    HAL_INT_TXDESC  = 0x00000080,   /* Non-common mapping */
    HAL_INT_TXURN   = 0x00000800,
    HAL_INT_MIB     = 0x00001000,
    HAL_INT_RXPHY   = 0x00004000,   /* Never really used as we get a RXERR interrupt also */
    HAL_INT_RXKCM   = 0x00008000,
    HAL_INT_SWBA    = 0x00010000,
    HAL_INT_BMISS   = 0x00040000,
    HAL_INT_BNR     = 0x00100000,   /* Non-common mapping */
    HAL_INT_BCNMISC = 0x00800000,   /* Venice, 'or' of misc beacon bits from ISR_S2 */
    HAL_INT_GPIO    = 0x01000000,

    /* The following are special values which don't map directly to ISR bits */
    HAL_INT_DTIM    = 0x20000000,   /* Virtual map of DTIM interrupt in ISR_S2 */
    HAL_INT_FATAL   = 0x40000000,   /* Non-common mapping */
    HAL_INT_GLOBAL  = 0x80000000,   /* To set/clear IER. Don't combine with other ints. */

    HAL_INT_COMMON  =  (HAL_INT_RXEOL | HAL_INT_RXORN | HAL_INT_TXURN | HAL_INT_MIB   |
                        HAL_INT_RXKCM | HAL_INT_SWBA  | HAL_INT_BMISS | HAL_INT_GPIO  |
                        HAL_INT_RXPHY),
    HAL_INT_INVALID = ~(HAL_INT_RX    | HAL_INT_RXEOL | HAL_INT_RXORN | HAL_INT_TX    |
                        HAL_INT_TXDESC| HAL_INT_TXURN | HAL_INT_MIB   | HAL_INT_RXKCM |
                        HAL_INT_SWBA  | HAL_INT_BMISS | HAL_INT_BNR   | HAL_INT_GPIO  |
                        HAL_INT_FATAL | HAL_INT_RXPHY | HAL_INT_GLOBAL),
    HAL_INT_NOCARD  = 0xffffffff    /* To signal that the card has been removed */
} HAL_INT_TYPE;

A_BOOL
halIsInterruptPending(struct ArDevInfo *pArDev);

HAL_INT_TYPE
halGetInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE *pUnmaskedValue, A_UINT32 *pQueueBitMask);

void
halEnableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints);

void
halDisableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints);

/* Manipulation of RF gain for temparature sensitivity */
typedef enum {
    RFGAIN_INACTIVE,
    RFGAIN_READ_REQUESTED,
    RFGAIN_NEED_CHANGE,
} RFGAIN_STATES;

RFGAIN_STATES
halGetRfgain(struct ArDevInfo *pArDev);

#ifdef DEBUGWME
void
halDumpIFS(__WLAN_DEV_INFO *pDevInfo);

void
ar52xxDumpIFS(__WLAN_DEV_INFO *pDevInfo);
#endif

#if defined(PREDATOR_TB84) && !defined(PCI_INTERFACE)
#if 1
#define HAL_CODE_REDUCTION
#include "halApiRedef.h"
#endif
#else
#define EAR_SUPPORT
#endif /* PREDATOR && PCI_INTERFACE */

#ifdef _cplusplus
}
#endif

#endif /* _HAL_API_H */
