/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines the MAC/PHY Hardware Abstraction Layer (HAL) API as well as commonly
 * used types and structs.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halApiRedef.h#3 $
 */

#ifndef _HAL_API_REDEF_H_
#define _HAL_API_REDEF_H_

#ifdef _cplusplus
extern "C" {
#endif

#include "hal.h"
#include "ar5212/ar5212.h"
#include "ar5212/ar5212Reg.h"
#include "ar5212/ar5212Misc.h"
#include "ar5212/ar5212Attach.h"
#include "ar5212/ar5212KeyCache.h"
#include "ar5212/ar5212Beacon.h"
#include "ar5212/ar5212Interrupts.h"
#include "ar5212/ar5212Transmit.h"
#include "ar5212/ar5212Receive.h"
#include "ar5212/ar5212Reset.h"
#include "ar5212/ar5212Phy.h"
#include "ar5212/ar5212Power.h"

#define halDevInit(ArDev)               ar5212DevInit(ArDev)
#define halGetNumDevid(void)            ar5212GetNumDevid(void)
#define halGetDevids(index)             ar5212GetDevids(index)
#define halDevFini(ArDev)               ar5212DevFini(ArDev)
#define halFillCapabilityInfo(ArDev)    ar5212FillCapabilityInfo(ArDev)
#define halReset(ArDev, serviceType, chanDesc, bChannelChange)  \
            ar5212Reset(ArDev, serviceType, chanDesc, bChannelChange)
#define halPhyDisable(ArDev)            ar5212PhyDisable(ArDev)
#define halDisable(ArDev)               ar5212Disable(ArDev)
#define halPerCalibration(ArDev, chanDesc)                      \
            ar5212PerCalibration(ArDev, chanDesc)
#define halSetTxPowerLimit(ArDev, limit)                        \
            ar5212SetTxPowerLimit(ArDev, limit)

/* Transmit Functions */

#define halUpdateTxTrigLevel(ArDev, bIncTrigLevel)              \
            ar5212UpdateTxTrigLevel(ArDev, bIncTrigLevel)
#define halSetupTxQueue(ArDev, HAL_TX_QUEUE_INFO)               \
            ar5212SetupTxQueue(ArDev, HAL_TX_QUEUE_INFO)
#define halReleaseTxQueue(ArDev, queueNum)                      \
            ar5212ReleaseTxQueue(ArDev, queueNum)
#define halGetTxDP(ArDev, queueNum)                             \
            ar5212GetTxDP(ArDev, queueNum)
#define halSetTxDP(ArDev, queueNum, txdp)                       \
            ar5212SetTxDP(ArDev, queueNum, txdp)
#define halStartTxDma(ArDev, queueNum)                          \
            ar5212StartTxDma(ArDev, queueNum)
#define halNumTxPending(ArDev, queueNum)                        \
            ar5212NumTxPending(ArDev, queueNum)
#define halStopTxDma(ArDev, queueNum, msec)                     \
            ar5212StopTxDma(ArDev, queueNum, msec)

/* Transmit Desriptor Functions */
#define halSetupTxDesc(ArDev, ArDesc, hwIndex)                  \
            ar5212SetupTxDesc(ArDev, ArDesc, hwIndex)
#define halProcessTxDesc(ArDev, ArDesc)                         \
            ar5212ProcessTxDesc(ArDev, ArDesc)
#define halGetTxDescDone(ArDev, ArDesc)                         \
            ar5212GetTxDescDone(ArDev, ArDesc)
#define halSwapHwDesc(ArDev, ArDesc, ArDesc1, complete)         \
            ar5212SwapHwDesc(ArDev, ArDesc, ArDesc1, complete)
#define halGetHwDescWord(ArDev, hwDescWord)                     \
            ar5212GetHwDescWord(ArDev, hwDescWord)

#if defined(DEBUG) || defined(_DEBUG)
#define halDebugPrintTxDesc(ArDev, ArDesc, verbose)             \
            ar5212DebugPrintTxDesc(ArDev, ArDesc, verbose)
#endif

/* Receive Functions */
#define halGetRxDP(ArDev)               ar5212GetRxDP(ArDev)
#define halSetRxDP(ArDev, rxdp)         ar5212SetRxDP(ArDev, rxdp)
#define halEnableReceive(ArDev)         ar5212EnableReceive(ArDev)
#define halStopDmaReceive(ArDev)        ar5212StopDmaReceive(ArDev)
#define halStartPcuReceive(ArDev)       ar5212StartPcuReceive(ArDev)
#define halStopPcuReceive(ArDev)        ar5212StopPcuReceive(ArDev)
#define halSetMulticastFilter(ArDev, filter0, filter1)          \
            ar5212SetMulticastFilter(ArDev, filter0, filter1)
#define halMulticastFilterIndex(ArDev, index, bSet)             \
            ar5212MulticastFilterIndex(ArDev, index, bSet)
#define halSetRxFilter(ArDev, bits)                             \
            ar5212SetRxFilter(ArDev, bits)
#define halProcessRxDesc(ArDev, ArDesc)                         \
            ar5212ProcessRxDesc(ArDev, ArDesc)

#define halGetPcuState(ArDev)                         \
            ar5212GetPcuState(ArDev)

#if (defined(UPSD) && defined(BUILD_AP))
#define halUpsdResponse(ArDev)          ar5212UpsdResponse(ArDev)
#endif

#define halSetupRxDesc(ArDev, ArDesc, size)                     \
            ar5212SetupRxDesc(ArDesc, size)

/* Misc Functions */
#define halApplyMKKIrreversibleUpdate(ArDev, enOddU1, undoUpdate)    \
            ar5212ApplyMKKIrreversibleUpdate(ArDev, enOddU1, undoUpdate)
#define halMkkLockEeprom(ArDev, readOnly)                       \
            ar5212MkkLockEeprom(ArDev, readOnly)
#define halRawEepromRead(ArDev, offset, data)               \
            ar5212RawEepromRead(ArDev, offset, data)
#define halGetSerialNumber(ArDev, pSerialNum, strLen)           \
            ar5212GetSerialNumber(ArDev, pSerialNum, strLen)
#define halSetRegulatoryDomain(ArDev, regDomain)                \
            ar5212SetRegulatoryDomain(ArDev, regDomain)
#define halSetLedState(ArDev, bConnected)                       \
            ar5212SetLedState(ArDev, bConnected)
#define halWriteAssocid(ArDev, bssid, assocId)                  \
            ar5212WriteAssocid(ArDev, bssid, assocId)
#define halGpioCfgInput(ArDev, gpio)    ar5212GpioCfgInput(ArDev, gpio)
#define halGpioCfgOutput(ArDev, gpio)   ar5212GpioCfgOutput(ArDev, gpio)
#define halGpioGet(ArDev, gpio)         ar5212GpioGet(ArDev, gpio)
#define halGpioSet(ArDev, gpio, val)    ar5212GpioSet(ArDev, gpio, val)
#define halGpioSetIntr(ArDev, gpio, ilevel)                     \
            ar5212GpioSetIntr(ArDev, gpio, ilevel)
#define halSetStaBeaconTimers(ArDev, pBssConfig)                \
            ar5212SetStaBeaconTimers(ArDev, pBssConfig)
#define halGetTsf(ArDev, tsf)           ar5212GetTsf(ArDev, tsf)
#define halResetTsf(ArDev)              ar5212ResetTsf(ArDev)
#define halSetAdhocMode(ArDev)          ar5212SetAdhocMode(ArDev)
#define halSetBasicRate(ArDev, WlanRateSet)                     \
            ar5212SetBasicRate(ArDev, WlanRateSet)
#define halGetRandomSeed(ArDev)         ar5212GetRandomSeed(ArDev)
#define halDetectCardPresent(ArDev)     ar5212DetectCardPresent(ArDev)
#define halMibControl(ArDev, cmd)       ar5212MibControl(ArDev, cmd)
#define halEnableRadarDetection(ArDev, pPhyParams)              \
            ar5212EnableRadarDetection(ArDev, pPhyParams)
#define halAniControl(ArDev, cmd, param)                        \
            ar5212AniControl(ArDev, cmd, param)
#define halGetCurRssi(ArDev)            ar5212GetCurRssi(ArDev)
#define halGetDefAntenna(ArDev)         ar5212GetDefAntenna(ArDev)
#define halSetDefAntenna(ArDev, antenna)                        \
            ar5212SetDefAntenna(ArDev, antenna)
#define halSetAntennaSwitch(ArDev, settings, chanDesc)          \
            ar5212SetAntennaSwitch(ArDev, settings, chanDesc)
#define halUpdateAntenna(ArDev, ArConnInfo, retries, rssiAck, curTxAnt) \
            ar5212UpdateAntenna(ArDev, ArConnInfo, retries, rssiAck, curTxAnt)
#define halUseShortSlotTime(ArDev, en)                          \
            ar5212UseShortSlotTime(ArDev, en)
#define halDmaDebugDump(ArDev)                                  \
            ar5212DmaDebugDump(ArDev)
#define halSetDecompMask(ArDev, keyCacheIndex, WlanPrivStruct, en)   \
            ar5212SetDecompMask(ArDev, keyCacheIndex, WlanPrivStruct,  en)
#define halGetApSwitchHelper(ArDev, pRegs)                       \
            ar5212GetApSwitchHelper(ArDev, pRegs)
#define halSetApSwitchHelper(ArDev, pRegs)                       \
            ar5212SetApSwitchHelper(ArDev, pRegs)
#define halAniPeriodicCheck(ArDev)                               \
            ar5212AniPeriodicCheck(ArDev)

/* Key Cache Functions */
#define halGetKeyCacheSize(ArDev)            ar5212GetKeyCacheSize(ArDev)
#define halResetKeyCacheEntry(ArDev, keyCacheIndex)             \
            ar5212ResetKeyCacheEntry(ArDev, keyCacheIndex)
#define halSetKeyCacheEntry(pArDev, keyCacheIndex, pBssId, pKey)    \
            ar5212SetKeyCacheEntry(pArDev, keyCacheIndex, pBssId, pKey)

/* Power Management Functions */
#define halSetPowerMode(ArDev, powerRequest, setChip)           \
            ar5212SetPowerMode(ArDev, powerRequest, setChip)
#define halGetPowerMode(ArDev)                                  \
            ar5212GetPowerMode(ArDev)
#define halGetPowerStatus(ArDev)                                \
            ar5212GetPowerStatus(ArDev)
#define halSetupPSPollDesc(ArDev, pPSPollDesc)                  \
            ar5212SetupPSPollDesc(ArDev, pPSPollDesc)
#define halSetupBeaconDesc(ArDev, pDesc, antMode, isAp)         \
            ar5212SetupBeaconDesc(ArDev, pDesc, antMode, isAp)
#define halBeaconInit(ArDev, pBssConfig)                        \
            ar5212BeaconInit(ArDev, pBssConfig)
#define halSetupGrpPollChain(ArDev, pHead, pTail, hwIndex)      \
            ar5212SetupGrpPollChain(ArDev, pHead, pTail, hwIndex)

/* Interrupt functions */

#define halIsInterruptPending(ArDev)    ar5212IsInterruptPending(ArDev)
#define halGetInterrupts(ArDev, pUnmaskedValue, pQueueBitMask)  \
            ar5212GetInterrupts(ArDev, pUnmaskedValue, pQueueBitMask)
#define halEnableInterrupts(ArDev, ints)                        \
            ar5212EnableInterrupts(ArDev, ints)
#define halDisableInterrupts(ArDev, ints)                       \
            ar5212DisableInterrupts(ArDev, ints)

/* Manipulation of RF gain for temparature sensitivity */
#define halGetRfgain(ArDev) ar5212GetRfgain(ArDev)
#ifdef DEBUGWME
#define halDumpIFS(ArDev) ar5212DumpIFS(ArDev)
void
ar52xxDumpIFS(ArDev);
#endif

#ifdef _cplusplus
}
#endif

#endif /* _HAL_API_REDEF_H */
