/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 * TODO: comment
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halBeacon.c#3 $"

#if !defined(ECOS_NOTDONE)
#include "wlantype.h"   
#include "wlanchannel.h"
#include "wlandrv.h"    
#endif

#include "arDev.h"
#include "halApi.h"     
#include "hal.h"        


/**************************************************************
 * halSetupBeaconDesc
 *
 * This routine is used by both the AP and client.  It constructs the beacon
 * descriptor based on HW requirements.
 *
 * Assumptions: frameLen does not include the FCS
 */
void
halSetupBeaconDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc, 
                   A_UINT32 antMode, A_BOOL isAp)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetupBeaconDesc);

    pArDev->pHwFunc->hwSetupBeaconDesc(pArDev, pDesc, antMode, isAp);
}


/**************************************************************
 * halBeaconInit
 *
 * Initializes the HW registers required to send beacons.
 */
void
halBeaconInit(AR_DEV_INFO *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwBeaconInit);

    pArDev->pHwFunc->hwBeaconInit(pArDev, pBssConfig);
}

/**************************************************************
 * halSetupGrpPollChain
 *
 * This routine is used by both the AP and client.  It sets up the
 * group poll chain for XR
 */
void
halSetupGrpPollChain(AR_DEV_INFO *pArDev, AR_DESC *pHead, 
                     AR_DESC *pTail, A_UINT32 hwIndex)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    if (pArDev->pHwFunc->hwSetupGrpPollChain) {
        pArDev->pHwFunc->hwSetupGrpPollChain(pArDev, pHead, pTail, hwIndex);
    }
}
