/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halDesc.h#5 $
 *
 * Copyright  2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Defines the hardware descriptor data structures.
 *
 * Fields named hwSpecific are chipset dependent. Use the HAL descriptor
 * access functions to access these fields.
 * All other fields are common to all Atheros chipsets.
 */

#ifndef _HAL_DESC_H_
#define _HAL_DESC_H_

#ifdef _cplusplus
extern "C" {
#endif

typedef struct hwTxControlAccess {
#ifdef BIG_ENDIAN
    A_UINT32    hwSpecific1:20,     /* 31:12 hardware specific bits */
                frameLength:12;     /* 11:0  length of the 802.11 packet */
    A_UINT32    hwSpecific2:19,     /* 31:13 hardware specific  */
                more:1,             /* 12    set if packet continues in next descriptor */
                bufferLength:12;    /* 11:0  size of buffer for this descriptor */
#else
    A_UINT32    frameLength:12,     /* 11:0  length of the 802.11 packet */
                hwSpecific1:20;     /* 31:12 hardware specific */
    A_UINT32    bufferLength:12,    /* 11:0  size of buffer for this descriptor */
                more:1,             /* 12    set if packet continues in next descriptor */
                hwSpecific2:19;     /* 31:13 hardware specific */
#endif
    A_UINT32    pad[4];             /* to make it align to the rest of hw area */
} HW_TX_CONTROL_ACCESS;

/* Hardware Descriptor Packet Types */
typedef enum {
    HAL_DESC_PKT_TYPE_NORMAL = 0,
    HAL_DESC_PKT_TYPE_ATIM,
    HAL_DESC_PKT_TYPE_PSPOLL,
    HAL_DESC_PKT_TYPE_BEACON,
    HAL_DESC_PKT_TYPE_PROBE_RESP,
    HAL_DESC_PKT_TYPE_CHIRP,
    HAL_DESC_PKT_TYPE_GRP_POLL
} HAL_DESC_PKT_TYPE;

#ifdef _cplusplus
}
#endif

#endif /* _HAL_DESC_H_ */
