/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 */

#ifndef _HAL_DEVID_H_
#define _HAL_DEVID_H_

#ifdef _cplusplus
extern "C" {
#endif

/* AR5212 */
#define AR5212_DEFAULT          0x1113          /* No eeprom HW default */
#define AR5212_DEVID            0x0013          /* ar5212 devid */
#define AR5312_DEVID            0x0030          /* Final ar5312 devid */
#define AR5212_SREV_1_0         0x50
#define AR5212_SREV_1_1         0x51
#define AR5212_SREV_1_3         0x53
#define AR5212_SREV_1_4         0x56
#define AR5212_SREV_AR5523_0    0x80            /* (Pre-release) */
#define AR5212_SREV_AR5523_1    0x81
#define AR5212_SREV_REG         0x4020

/* AR5212 compatible devid's also attach to 5212 */
#define AR5212_DEVID_0014       0x0014          /* ar5212 forward compatibility id */
#define AR5212_DEVID_0015       0x0015          /* ar5212 forward compatibility id */
#define AR5212_DEVID_0016       0x0016          /* ar5212 forward compatibility id */
#define AR5212_DEVID_0017       0x0017          /* ar5212 forward compatibility id */
#define AR5212_DEVID_0018       0x0018          /* ar5212 forward compatibility id */
#define AR5212_DEVID_0019       0x0019          /* ar5212 forward compatibility id */

/* AR5213 */
#define AR5213_SREV_1_0         0x55
#define AR5213_SREV_REG         0x4020

/* SubVendor Specific Ids */
#define SUBVENDOR_ID_NO_G       0x0e11          /* No 11G subVendor ID */

#ifdef _cplusplus
}
#endif

#endif /* _HAL_DEVID_H */
