/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halKeyCache.c#3 $"

#include "wlantype.h"
#include "wlandrv.h"
#include "halApi.h"
#include "hal.h"
#include "ui.h"
#include "arDev.h"


/**************************************************************
 * halGetKeyCacheSize
 *
 * Returns size of hardware key cache.
 */
A_UINT32
halGetKeyCacheSize(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGetKeyCacheSize);

    return pArDev->pHwFunc->hwGetKeyCacheSize(pArDev);
}

/**************************************************************
 * halResetKeyCache
 *
 * Clears ALL key cache entries
 */
void
halResetKeyCache(AR_DEV_INFO *pArDev)
{
    A_UINT16 keyCacheIndex;

    ASSERT(pArDev);

    for (keyCacheIndex = 0;
         keyCacheIndex < halGetKeyCacheSize(pArDev);
         keyCacheIndex++) {
        halResetKeyCacheEntry(pArDev, keyCacheIndex);
    }

}

/**************************************************************
 * halResetKeyCacheEntry
 *
 * Clears the specified key cache entry
 */
void
halResetKeyCacheEntry(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwResetKeyCacheEntry);

    pArDev->pHwFunc->hwResetKeyCacheEntry(pArDev, keyCacheIndex);
}

/**************************************************************
 * halSetKeyCacheEntry
 *
 * Sets the specified key cache entry
 */
void
halSetKeyCacheEntry(AR_DEV_INFO *pArDev,
                    A_BOOL connKey, A_UINT32 rawIdx,
                    A_UINT32 msgLen, TARGET_CONFIG_VAL msgVal)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetKeyCacheEntry);

    pArDev->pHwFunc->hwSetKeyCacheEntry(pArDev,
                                        connKey, rawIdx,
                                        msgLen, msgVal);
}


/**************************************************************
 * halKeyCacheAlloc
 *
 * Allocate key cache index, including handling over-subscription.
 *
 * First try to find an unused key cache entry.
 *
 * If we have to steal a key cache entry, we take the oldest SIB that
 * does not have any pending tx frames, with preference to SIBs that
 * are not associated.
 *
 * If all key cache entries are in use by the tx queue, we
 * fail by returning HWINDEX_INVALID.
 *
 * NOTE: caller must hold the keySem.
 */
A_UINT16
halKeyCacheAlloc(AR_DEV_INFO *pArDev, A_UINT16 hwIndex,
                 A_UINT16 keyType, A_BOOL *pHwEncrypt)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwKeyCacheAlloc);

    return (pArDev->pHwFunc->hwKeyCacheAlloc(pArDev, hwIndex, keyType,
                                              pHwEncrypt));
}

/*
 * Free the key cache entry referenced by hwIndex
 */
void
halKeyCacheFree(AR_DEV_INFO *pArDev, A_UINT16 hwIndex)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwKeyCacheFree);

    pArDev->pHwFunc->hwKeyCacheFree(pArDev, hwIndex);
}

/**************************************************************
 * halSetDecompMask
 *
 * update the decompression mask based on key cache index
 */
A_UINT16
halSetDecompMask(AR_DEV_INFO *pArDev, A_UINT16 keyCacheIndex,
                 A_UINT32 keyType, A_BOOL en)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    if (pArDev->pHwFunc->hwSetDecompMask) {
        return pArDev->pHwFunc->hwSetDecompMask(pArDev, keyCacheIndex,
                                                 keyType, en);
    }

    return DECOMPINDEX_INVALID;
}
