/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halMisc.c#3 $"

#if !defined(ECOS_NOTDONE)
#include "wlantype.h"
#include "wlandrv.h"
#include "wlanchannel.h"
#include "ui.h"
#endif

#include "arDev.h"
#include "halApi.h"
#include "hal.h"
#include "arDev.h"


#if !defined(ECOS_NOTDONE)

/**************************************************************
 * halGetSerialNumber
 *
 * Copy Hal Serial Number into provided string.
 * Returns TRUE if the value was copied.
 */
A_BOOL
halGetSerialNumber(WLAN_DEV_INFO *pDev, A_CHAR *pSerialNum, A_UINT16 strLen)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    if (strLen < sizeof(pArDev->pHalInfo->serialNumber)) {
        return FALSE;
    }
    A_BCOPY(pArDev->pHalInfo->serialNumber, pSerialNum, sizeof(pArDev->pHalInfo->serialNumber));
    return TRUE;
}
#endif

/**************************************************************
 * halSetRegulatoryDomain
 *
 * Changes the Regulatory domain in the PROM.
 * Returns A_OK for a successful change.
 */
A_STATUS
halSetRegulatoryDomain(AR_DEV_INFO *pArDev, A_UINT16 regDomain)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetRegulatoryDomain);
    return pArDev->pHwFunc->hwSetRegulatoryDomain(pArDev, regDomain);
}

/**************************************************************
 * halSetLedState
 *
 * Change LED state based on WLAN connection status
 */
void
halSetLedState(WLAN_DEV_INFO *pDev, A_BOOL bConnected)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetLedState);
    pArDev->pHwFunc->hwSetLedState(pDev, bConnected);
}


/**************************************************************
 * halWriteAssocid
 *
 * Setup the association id (duh)
 */
void
halWriteAssocid(AR_DEV_INFO *pArDev, WLAN_MACADDR *bssid, A_UINT16 assocId)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwWriteAssocid);
    pArDev->pHwFunc->hwWriteAssocid(HACK_TO_PDEV(pArDev), bssid, assocId);
}

#if !defined(ECOS_NOTDONE)

void
halGpioCfgInput(WLAN_DEV_INFO *pDev, A_UINT32 gpio)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGpioCfgInput);
    pArDev->pHwFunc->hwGpioCfgInput(pDev, gpio);
}

void
halGpioCfgOutput(WLAN_DEV_INFO *pDev, A_UINT32 gpio)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGpioCfgOutput);
    pArDev->pHwFunc->hwGpioCfgOutput(pDev, gpio);
}

A_UINT32
halGpioGet(WLAN_DEV_INFO *pDev, A_UINT32 gpio)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGpioGet);
    return pArDev->pHwFunc->hwGpioGet(pDev, gpio);
}

void
halGpioSet(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGpioSet);
    pArDev->pHwFunc->hwGpioSet(pDev, gpio, val);
}

void
halGpioSetIntr(WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGpioSetIntr);
    pArDev->pHwFunc->hwGpioSetIntr(pDev, gpio, ilevel);
}
#endif


void
halSetStaBeaconTimers(AR_DEV_INFO *pArDev, WDC_BSS_ATTRIBUTES *pBssConfig)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetStaBeaconTimers);
    pArDev->pHwFunc->hwSetStaBeaconTimers(pArDev, pBssConfig);
}

void
halGetTsf(AR_DEV_INFO *pArDev, WLAN_TIMESTAMP *tsf)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGetTsf);
    pArDev->pHwFunc->hwGetTsf(pArDev, tsf);
}

void
halResetTsf(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwResetTsf);
    pArDev->pHwFunc->hwResetTsf(HACK_TO_PDEV(pArDev));
}


void
halSetAdhocMode(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetAdhocMode);
    pArDev->pHwFunc->hwSetAdhocMode(pArDev);
}


/**************************************************************
 * halSetBasicRate
 *
 * Modify the basic rate
 */
void
halSetBasicRate(AR_DEV_INFO *pArDev, CONN_RATE_SET *pSet)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetBasicRate);
    pArDev->pHwFunc->hwSetBasicRate(pArDev, pSet);
}

/**************************************************************
 * halGetRandomSeed
 *
 * Grab a semi-random value from hardware registers - may not
 * change often
 */
A_UINT32
halGetRandomSeed(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    return pArDev->pHwFunc->hwGetRandomSeed(pDev);
}

/**************************************************************
 * halMibControl
 *
 */
A_UINT32
halMibControl(AR_DEV_INFO *pArDev, HAL_MIB_CMD cmd)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    if (pArDev->pHwFunc->hwMibControl) {
        return pArDev->pHwFunc->hwMibControl(pDev, cmd);
    }

    return 0;
}

#if !defined(ECOS_NOTDONE)
/**************************************************************
 * halDetectCardPresent
 *
 * Detect if our card is present
 */
A_BOOL
halDetectCardPresent(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwDetectCardPresent);
    return pArDev->pHwFunc->hwDetectCardPresent(pArDev);
}

/**************************************************************
 * halEnableRadarDetection
 *
 * Enable radar detection in the hardware - may later be changed
 * to modify radar "sensitivity"
 */
void
halEnableRadarDetection(WLAN_DEV_INFO *pDev, HAL_RADAR_PHY_PARAMS *pPhyParams)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwEnableRadarDetection);
    pArDev->pHwFunc->hwEnableRadarDetection(pDev, pPhyParams);
}

/**************************************************************
 * halAniControl
 *
 * Control Adaptive Noise Immunity Parameters
 */
void
halAniControl(WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    if (pArDev->pHwFunc->hwAniControl) {
        pArDev->pHwFunc->hwAniControl(pDev, cmd, param);
    }
}

A_UINT32
halGetCurRssi(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    return pArDev->pHwFunc->hwGetCurRssi(HACK_TO_PDEV(pArDev));
}

#endif

A_UINT32
halGetDefAntenna(WLAN_DEV_INFO *pDev)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    return pArDev->pHwFunc->hwGetDefAntenna(pDev);
}

void
halSetDefAntenna(WLAN_DEV_INFO *pDev, A_UINT32 antenna)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    pArDev->pHwFunc->hwSetDefAntenna(pDev, antenna);
}

/**************************************************************
 * halSetAntennaSwitch
 *
 */
void
halSetAntennaSwitch(AR_DEV_INFO *pArDev,
                    ANTENNA_CONTROL settings,
                    CHAN_DESC *pChDesc)
{
    ASSERT(pArDev);
    pArDev->pHwFunc->hwSetAntennaSwitch(pArDev, settings, pChDesc);    
}

void
halUpdateAntenna(AR_DEV_INFO *pArDev, AR_CONN_INFO *pArConn, int retries,
                 A_UINT8 rssiAck, A_UINT8 curTxAnt)
{
    ASSERT(pArDev && pArConn);
    pArDev->pHwFunc->hwUpdateAntenna(pArDev, pArConn, retries, rssiAck, curTxAnt);
}



/**************************************************************
 * halUseShortSlotTime
 *
 * Initializes the HW registers required to send beacons.
 */
void
halUseShortSlotTime(AR_DEV_INFO *pArDev, A_BOOL en)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwUseShortSlotTime);

    pArDev->pHwFunc->hwUseShortSlotTime(pArDev, en);
}


#if !defined(ECOS_NOTDONE)

void
halDmaDebugDump(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwDmaDebugDump);

    pArDev->pHwFunc->hwDmaDebugDump(HACK_TO_PDEV(pArDev));
}

/**************************************************************
 * halGetApSwitchHelper
 *
 * Get some Beacon relevant registers.
 */
void
halGetApSwitchHelper(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    if (pArDev->pHwFunc->hwGetApSwitchHelper) {
        pArDev->pHwFunc->hwGetApSwitchHelper(pDev, pRegs);
    }
}

/**************************************************************
 * halSetApSwitchHelper
 *
 * Restore some Beacon relevant registers.
 */
void
halSetApSwitchHelper(WLAN_DEV_INFO *pDev, SAVE_SIX_REG *pRegs)
{
    AR_DEV_INFO *pArDev = HACK_TO_PARDEV(pDev);

    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    if (pArDev->pHwFunc->hwSetApSwitchHelper) {
        pArDev->pHwFunc->hwSetApSwitchHelper(pDev, pRegs);
    }
}

#endif /* ECOS_NOTDONE */
