/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halPower.c#3 $"

#include "arDev.h"
#include "halApi.h"
#include "hal.h"
#include "arDev.h"


/**************************************************************
 * halSetPowerMode
 *
 * Set power mgt to the requested mode, and conditionally set
 * the chip as well
 * Returns A_OK if chip is successfully forced awake.
 */
A_STATUS
halSetPowerMode(AR_DEV_INFO *pArDev, A_UINT32 powerRequest, A_BOOL setChip)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetPowerMode);

    return pArDev->pHwFunc->hwSetPowerMode(pArDev, powerRequest, setChip);
}

/**************************************************************
 * halGetPowerMode
 *
 * Get and return current power setting from the chip
 */
A_UINT32
halGetPowerMode(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGetPowerMode);

    return pArDev->pHwFunc->hwGetPowerMode(pArDev);
}

/**************************************************************
 * halGetPowerStatus
 *
 * Return the current sleep state of the chip
 * TRUE = sleeping
 */
A_BOOL
halGetPowerStatus(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGetPowerStatus);

    return pArDev->pHwFunc->hwGetPowerStatus(pArDev);
}

/**************************************************************
 * halSetupPSPollDesc
 *
 * Initialize for PS-Polls
 */
void
halSetupPSPollDesc(AR_DEV_INFO *pArDev, AR_DESC *pPSPollDesc)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetupPSPollDesc);

    pArDev->pHwFunc->hwSetupPSPollDesc(pArDev, pPSPollDesc);
}
