/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halReceive.c#3 $"

#if !defined(ECOS_NOTDONE)
#include "wlantype.h"
#include "wlandrv.h"
#endif

#include "arDev.h"
#include "halApi.h"
#include "hal.h"

/**************************************************************
 * halGetRxDP
 *
 * Get the RXDP.
 */
A_UINT32
halGetRxDP(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwGetRxDP(pArDev);
}

/**************************************************************
 * halSetRxDP
 *
 * Set the RxDP.
 */
void
halSetRxDP(AR_DEV_INFO *pArDev, A_UINT32 rxdp)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwSetRxDP(pArDev, rxdp);
}

/**************************************************************
 * halEnableReceive
 *
 * Set Transmit Enable bits for the "main" data queue.
 */
void
halEnableReceive(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwEnableReceive(pArDev);
}

/**************************************************************
 * halStopDmaReceive
 *
 * Stop Transmit at the DMA engine
 */
A_STATUS
halStopDmaReceive(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwStopDmaReceive(pArDev);
}

/**************************************************************
 * halStartPcuReceive
 *
 * Start Transmit at the PCU engine (unpause receive)
 */
void
halStartPcuReceive(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwStartPcuReceive(pArDev);
}

/**************************************************************
 * halGetPcuState
 *
 * Get PCU engine state(unpause receive)
 */
A_BOOL
halGetPcuState(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwGetPcuState(pArDev);
}
/**************************************************************
 * halStopPcuReceive
 *
 * Stop Transmit at the PCU engine (pause receive)
 */
void
halStopPcuReceive(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwStopPcuReceive(pArDev);
}


/**************************************************************
 * halSetMulticastFilter
 *
 * Set multicast filter 0 (lower 32-bits)
 *               filter 1 (upper 32-bits)
 */
void
halSetMulticastFilter(AR_DEV_INFO *pArDev, A_UINT32 filter0, A_UINT32 filter1)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwSetMulticastFilter(pArDev, filter0, filter1);
}

/**************************************************************
 * halMulticastFilterIndex
 *
 * Clear/Set multicast filter by index
 */
void
halMulticastFilterIndex(AR_DEV_INFO *pArDev, A_UINT32 index, A_BOOL bSet)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwMulticastFilterIndex(pArDev, index, bSet);
}

/**************************************************************
 * halSetRxFilter
 *
 * Set the RxFilter in HW and its associated pArDev value
 */
void
halSetRxFilter(AR_DEV_INFO *pArDev, A_UINT32 bits)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetRxFilter);
    pArDev->pHwFunc->hwSetRxFilter(pArDev, bits);
}

/**************************************************************
 * halProcessRxDesc
 *
 * Process a receive descriptor
 */
A_STATUS
halProcessRxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc)
{
    ASSERT(pArDev);
    ASSERT(pDesc);

    return pArDev->pHwFunc->hwProcessRxDesc(pArDev, pDesc);
}

/**************************************************************
 * halSetupRxDesc
 *
 * Setup a receive descriptor
 */
void
halSetupRxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_UINT32 size)
{
    ASSERT(pArDev);
    ASSERT(pDesc);

    pArDev->pHwFunc->hwSetupRxDesc(pDesc, size);
}

#ifdef UPSD
void
halUpsdResponse(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);

    pArDev->pHwFunc->hwUpsdResponse(pArDev);
}
#endif
