/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halReset.c#3 $"

#include "wlantype.h"
#include "wdcApi.h"
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "arDev.h"
#include "halApi.h"
#include "hal.h"

/**************************************************************
 * halPeriodicCal
 *
 * Readjusts hardware to environmental changes such as
 * temperature, noise, etc.  Performs channel "correctness" check.
 *
 */
A_STATUS
halPerCalibration(AR_DEV_INFO *pArDev, CHAN_DESC *pChDesc)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwPerCalibration);

    if (pChDesc == NULL) {
        pChDesc = CURRENT_PCHDESC(pArDev);
    }

    return pArDev->pHwFunc->hwPerCalibration(pArDev, pChDesc);
}

/**************************************************************
 * halReset
 *
 * halReset requires a successful halInit.  halReset soft-resets
 * all chips present and then reloads their initialization
 * information based on the chips' selected operation mode.
 *
 */
A_STATUS
halReset(AR_DEV_INFO *pArDev,
         WLAN_SERVICE serviceType,
         CHAN_DESC *pChDesc,
         A_BOOL bChannelChange)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwReset);

    if (pChDesc == NULL) {
        pChDesc = CURRENT_PCHDESC(pArDev);
    }

    return pArDev->pHwFunc->hwReset(pArDev, serviceType, pChDesc, bChannelChange);
}

/**************************************************************
 * halDisable
 *
 * Disable the chip by putting it into reset
 */
A_STATUS
halDisable(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwDisable);
    return pArDev->pHwFunc->hwDisable(pArDev);
}

/**************************************************************
 * halPhyDisable
 *
 * Used by RFKIll to turn off all radio capabilities.
 */
A_STATUS
halPhyDisable(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwPhyDisable);
    return pArDev->pHwFunc->hwPhyDisable(pArDev);
}

/**************************************************************
 * halGetRfgain
 *
 * Get the Rf Gain state and inform the RfGain that a packet has been
 * sent.
 */
RFGAIN_STATES
halGetRfgain(AR_DEV_INFO *pArDev)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwGetRfgain);
    return pArDev->pHwFunc->hwGetRfgain(pArDev);
}

/**************************************************************
 * halSetTxPowerLimit
 *
 * Sets a limit on the overall output power.  Used for dynamic
 * transmit power control and the like.
 *
 * NOTE: The power passed in is in units of 0.5 dBm.
 */
void
halSetTxPowerLimit(AR_DEV_INFO *pArDev, A_UINT32 limit)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);
    ASSERT(pArDev->pHwFunc->hwSetTxPowerLimit);
    pArDev->pHwFunc->hwSetTxPowerLimit(pArDev, limit);
}


