/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 */

#ident "ACI $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/hal/halTransmit.c#3 $"

#if !defined(ECOS_NOTDONE)
#include "wlantype.h"
#include "wlandrv.h"
#include "ui.h"
#include "display.h"
#endif

#include "arDev.h"
#include "halApi.h"
#include "hal.h"

/**************************************************************
 * halUpdateTxTrigLevel
 *
 * Update Tx FIFO trigger level.
 *
 * Set bIncTrigLevel to TRUE to increase the trigger level.
 * Set bIncTrigLevel to FALSE to decrease the trigger level.
 *
 * Returns TRUE if the trigger level was updated
 */
A_BOOL
halUpdateTxTrigLevel(AR_DEV_INFO *pArDev, A_BOOL bIncTrigLevel)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwUpdateTxTrigLevel(pArDev, bIncTrigLevel);

}

/**************************************************************
 * halSetupTxQueue
 *
 * Allocates and initializes a DCU/QCU combination for tx
 *
 */
int
halSetupTxQueue(AR_DEV_INFO *pArDev, HAL_TX_QUEUE_INFO *queueInfo)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwSetupTxQueue(pArDev, queueInfo);
}

/**************************************************************
 * halReleaseTxQueue
 *
 * Frees up a DCU/QCU combination
 *
 */
void
halReleaseTxQueue(AR_DEV_INFO *pArDev, int queueNum)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwReleaseTxQueue(pArDev, queueNum);
}

/**************************************************************
 * halGetTxDP
 *
 * Get the TXDP for the specified queue
 */
A_UINT32
halGetTxDP(AR_DEV_INFO *pArDev, int queueNum)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwGetTxDP(pArDev, queueNum);
}

/**************************************************************
 * halSetTxDP
 *
 * Set the TxDP for the specified transmit queue
 */
void
halSetTxDP(AR_DEV_INFO *pArDev, int queueNum, A_UINT32 txdp)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwSetTxDP(pArDev, queueNum, txdp);
}

/**************************************************************
 * halStartTxDma
 *
 * Set Transmit Enable bits for the specified queue
 */
void
halStartTxDma(AR_DEV_INFO *pArDev, int queueNum)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwStartTxDma(pArDev, queueNum);
}


/**************************************************************
 * halIsTxQueueStopped
 *
 * See if the given queue is active or not
 */
A_UINT32
halNumTxPending(AR_DEV_INFO *pArDev, int queueNum)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwNumTxPending(pArDev, queueNum);
}


/**************************************************************
 * halStopTxDma
 *
 * Stop the specified queue
 */
void
halStopTxDma(AR_DEV_INFO *pArDev, int queueNum, int msec)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwStopTxDma(pArDev, queueNum, msec);
}


/**************************************************************
 * halSetupTxDesc
 *
 * Sets the control fields of the transmit descriptor
 * Has more intelligence than it needs - i.e. some of it
 * may be better belong to the wlan layer in the future
 *
 */
void
halSetupTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pTxDesc, A_UINT32 hwIndex)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    pArDev->pHwFunc->hwSetupTxDesc(pArDev, pTxDesc, hwIndex);
}

/**************************************************************
 * halProcessTxDescStatus
 *
 * Process TX descriptor status.  Handles completed chain
 * termination, swretry look ahead decision and wlan stats
 * collection.
 *
 */
A_STATUS
halProcessTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pTxDesc)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwProcessTxDesc(pArDev, pTxDesc);
}

A_BOOL
halGetTxDescDone(AR_DEV_INFO *pArDev, AR_DESC *pTxDesc)
{
    ASSERT(pArDev);
    ASSERT(pArDev->pHwFunc);

    return pArDev->pHwFunc->hwGetTxDescDone(pArDev, pTxDesc);
}

/**************************************************************
 * DEBUG related routines - defined for DEBUG only
 *
 */
#if !defined(ECOS_NOTDONE)

#if defined(DEBUG) || defined(_DEBUG) 

const char *halFrameTypeToName[] = {
    "ASSOC_REQ",    "ASSOC_RESP",   "REASSOC_REQ",  "REASSOC_RESP",
    "PROBE_REQ",    "PROBE_RESP",   "MGT:???",      "MGT:???",
    "BEACON",       "ATIM",         "DISASSOC",     "AUTH",
    "DEAUTH",       "MGT:???",      "MGT:???",      "MGT:???",

    "CTRL:???",     "CTRL:???",     "CTRL:???",     "CTRL:???",
    "CTRL:???",     "CTRL:???",     "CTRL:???",     "CTRL:???",
    "CTRL:???",     "CTRL:???",     "PSPOLL",       "RTS",
    "CTS",          "ACK",          "CFEND",        "CFENDACK",

    "DATA",         "DATA_CFACK",   "DATA_CFPOLL",  "DATA_CFACK_CFPOLL",
    "NODATA",       "NODATA_CFACK", "NODATA_CFPOLL","NODATA_CFACK_CFPOLL",
    "DATA:???",     "DATA:???",     "DATA:???",     "DATA:???",
    "DATA:???",     "DATA:???",     "DATA:???",     "DATA:???",

    "???", "???", "???", "???",
    "???", "???", "???", "???",
    "???", "???", "???", "???",
    "???", "???", "???", "???"
};

void
halDebugPrintTxDesc(AR_DEV_INFO *pArDev, AR_DESC *pDesc, A_BOOL verbose)
{
    ASSERT(pArDev);
    ASSERT(pDesc);

    /* Display all 6 words of the descriptor */
    if (verbose) {
        uiPrintf(DESC_ADDR        "%08x  ", pDesc->thisPhysPtr);
        uiPrintf(NEXT_DESC        "%08x  ", pDesc->nextPhysPtr);
        uiPrintf(BUFFER_PTR       "%08x\n", pDesc->bufferPhysPtr);
    }

    /* Display the hardware specific stuff */
    pArDev->pHwFunc->hwDebugPrintTxDesc(pArDev, pDesc, verbose);
}

#endif
#ifdef DEBUGWME
void
halDumpIFS(AR_DEV_INFO *pArDev)
{
	ar52xxDumpIFS(pArDev);
}
#endif

#endif //ECOS_NOTDONE
