/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ifndef _ARBSS_H
#define _ARBSS_H

#include "wdcApi.h"
#include "arDesc.h"
#if !defined(SPLIT_ENFORCE)
#include "wlanPhy.h"
#endif
#include "arPhy.h" 

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Without XR or some other form of multiple BSS
 * support, we shouldn't need more than 1 BSS
 */
#define AR_MAX_BSS      1

typedef struct ArBssInfo {
    WLAN_MACADDR        bssId;
    WDC_BSS_ATTRIBUTES  config;
    A_UINT16            assocId;

    struct ArDesc       *pBeaconDesc;
    int                 halBeaconQueue;

    RATE_TABLE          *pRateTable;        // if NULL, BSS is not in use

    AR_QUEUE_INFO       *pTxQueue;          // queue details for transmit queue
    AR_QUEUE_INFO       *pBurstQueue;       // queue details for Burst queue
} AR_BSS_INFO;


#define AR_MAX_BEACON_SIZE          128
#define DMA_BEACON_RESPONSE_TIME    512     // 1/2 TU
#define SW_BEACON_RESPONSE_TIME   10240     // 10 TUs


#define IS_VALID_AR_BSS(_pArBss)   ((_pArBss) && (_pArBss)->config.wlanMode != WLAN_MODE_NONE)

#ifdef __cplusplus
}
#endif

#endif /* _ARBSS_H_ */

