/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ifndef _ARCONN_H
#define _ARCONN_H

#include "wdcApi.h"

#ifdef __cplusplus
extern "C" {
#endif

/* MRD Requirement: Adhoc must support at least 4 simultaneous peers */
#define AR_MAX_CONN     4

/*
 * The followings are the Tx Rate Control Definitions
 * and data structures
 */

#define NO_RETRY            1       /* No retry */
#define MAX_TX_RETRIES      16      /* Max number of Tx (hw) retries */
#define MAX_REL_RATE        3       /* Number of adjacent Tx rates under consideration */

#if 1   
/* TODO: resolve for 12 vs 8 */
/* TURBO_PRIME */
#define MAX_TX_RATE_TBL     19      /* Highest Tx rate table length */
// #define MAX_TX_RATE_TBL     12      /* Highest Tx rate table length */
#else
#define MAX_TX_RATE_TBL     8       /* Highest Tx rate table length */
#endif


struct TxRetry_s {
    struct bin_s {
        A_UINT16  retryBin[NO_RETRY+MAX_TX_RETRIES]; /* 16+1 because 0 is used
                                                      * to store no retry count */
        A_UINT32  total_time;           /* Total Tx time */
        A_UINT32  frameLoss;            /* Frame Loss */
    } tbl[MAX_REL_RATE];
    A_UINT16    rateIdx;                /* Rate table index for Tx frame */
    A_UINT32    throttle_count;
    A_UINT32    throttle_dncnt;
    A_UINT32    throttle_upcnt;
    A_UINT32    rateDnCnt;
    A_UINT32    rateUpCnt;
    A_UINT32    frameCnt;               /* Frame count */
    A_UINT32    txCnt;
    A_UINT32    rateCnt[MAX_TX_RATE_TBL];
    A_UINT8     optRateCnt;             /* Optimal rate counter.
                                         * Use exploratory rate when count maxs out. */
    A_UINT8     optRateMax;             /* Max optimal rate count */
    A_BOOL      xLoRate;                /* Use low exploratory rate */
    A_BOOL      xHiRate;                /* Use high exploratory rate */
};

/*
 * State structures for new rate adaptation code
 *
 * NOTE: Modifying these structures will impact
 * the Perl script that parses packet logging data.
 * See the packet logging module for more information.
 */
typedef struct TxRateCrtlState_s {
    A_UINT8 rssiThres;          /* required rssi for this rate (dB) */
    A_UINT8 per;                /* recent estimate of packet error rate (%) */
} TxRateCtrlState;

typedef struct TxRateCtrl_s {
    TxRateCtrlState state[MAX_TX_RATE_TBL];    /* state for each rate */
    A_UINT8 rssiLast;           /* last ack rssi */
    A_UINT8 rssiLastLkup;       /* last ack rssi used for lookup */
    A_UINT8 rssiLastPrev;       /* previous last ack rssi */
    A_UINT8 rssiMedian;         /* median of last 3 rssi */
    A_UINT8 rateTableSize;      /* rate table size */  
    A_UINT32 validTxRateMask;   /* mask of valid rates */
    A_UINT8 rateMax;            /* max rate that has recently worked */
    A_UINT8 probeRate;          /* rate we are probing at */
    A_INT8  antFlipCnt;         /* number of consec times retry=2,3 */
    /* no dummy bytes */
    A_UINT8 misc[16];           /* miscellaneous state */
    A_UINT16 rssiSum;           /* running sum of rssi for averaging */
    A_UINT8 rssiSumCnt;         /* count of rssiSum for averaging */
    A_UINT8 rssiSumRate;        /* rate that we are averaging */
    A_UINT8 rate;               /* last rate we returned */
    A_UINT32 rssiTime;          /* msec timestamp for last ack rssi */
    A_UINT32 rssiDownTime;      /* msec timestamp for last down step */
    A_UINT32 probeTime;         /* msec timestamp for last probe */
    A_UINT8 hwMaxRetryRate;     /* rate of last max retry fail */
    A_UINT8 hwMaxRetryPktCnt;   /* number of packets since we got
                                   HW max retry error */
    A_UINT8 antProbeCnt;        /* number of packets since ant probe */
    A_UINT8 rssiLastPrev2;      /* 2nd previous last ack rssi */
    /* TURBO_PRIME */
    A_UINT8 recommendedPrimeState; /* 0 = regular mode (11g or 11a); 1 = Turbo mode (Turbo A or 108g) */
    A_UINT8 switchCount;           /* number of consec frames sent at a rate past the mode switch threshold */
    A_UINT8 validRateIndex[MAX_TX_RATE_TBL]; /*valid rate index*/
    A_UINT8 maxValidRate;       /* maximum number of valid rate*/
    A_UINT8 maxValidTurboRate;	/* maximum number of valid turbo rate*/	
} TX_RATECTRL_S;


typedef struct ArConnInfo {
    A_BOOL              bInUse;
    WLAN_MACADDR        macAddr;
    CONN_ATTRIBUTES     options;
    A_UINT32            numFilteredPending;
    A_UINT32            numTxPending;
    A_UINT32            needClearDest;
    AR_BSS_INFO         *pOpBss;
    AR_QUEUE_INFO       swRetryQueue;
#if !defined(NO_CONN_STATS)
    AR_STATS            stats;
#endif
    TX_RATECTRL_S       txRateCtrl;
    A_UINT32            txAnt;
    A_UINT16            ivLength;
    A_UINT16            icvLength;
} AR_CONN_INFO;

#define IS_FREE_AR_CONN(_pArConn)   ((_pArConn)->bInUse == FALSE)


void arDeleteAllConnections(TARGET_HANDLE targetHandle);

#define DECOMPINDEX_INVALID     0x7fff  /* invalid decompression index */

#ifdef __cplusplus
}
#endif

#endif /* _ARCONN_H_ */

