/*
 * Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 */

#ifndef _ARDESC_H
#define _ARDESC_H

#include "wdcApi.h"
#include "halDesc.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Software copies of HW status.  Currently must be 2 DWORDS in length.
 */
typedef struct ArDescTxStatus {
    enum {
        AR_NOT_DONE,
        AR_TRANSMIT_OK,
        AR_EXCESSIVE_RETRIES,
        AR_FILTERED
    }           status;
    A_UINT16    timestamp;          /* HW assigned timestamp */
    A_UINT16    seqNum;             /* HW assigned sequence number */
    A_UINT16    retryCount;         /* short + long retries */
} AR_DESC_TX_STATUS;

HANDLE_TYPEDEF(TX_COOKIE);

typedef struct ArDescRxStatus {
    A_UINT16    dataLength;         /* RX frame length */
    A_UINT16    timestamp;          /* HW assigned receive time stamp */
    A_UINT8     decryptError;       /* payload was not decrypted ok */
    A_UINT8     crcError;           /* HW crc error */
    A_UINT8     phyError;           /* phy error code from HW */
    A_UINT8     rate;               /* HW receive rate */
    A_UINT8     hwIndex;            /* key cache index */
    A_INT8      rssi;               /* signed RSSI */
    A_UINT8     antenna;            /* antenna */
    A_UINT8     keyCacheMiss;       /* No entry found for in key cache */
} AR_DESC_RX_STATUS;


/* Software descriptor structure */
typedef struct ArDesc {
    volatile A_UINT32    nextPhysPtr;        /* phys address of next descriptor */
    volatile A_UINT32    bufferPhysPtr;      /* phys address of this buffer */
    volatile union {                         /* harware control variables */
        /*
         * the hw control and status words are opaque to the wlan
         * layer!! but.. for now: touching certain transmit control
         * bits is still kosher!
         */
        volatile HW_TX_CONTROL_ACCESS    txControl;
        volatile A_UINT32                word[6];
#define AR_DESC_INIT_HW_AREA(_p) A_MEM_ZERO(&((_p)->hw.word[0]), 6 * sizeof(A_UINT32))
    } hw;

    /* HW above, SW below - SW should be cache aligned */

    struct ArDesc       *pNextVirtPtr;      /* Queue linkage */
    A_UINT32            thisPhysPtr;        /* phys addr of this descriptor */
    WLAN_FRAME_UNION    pBufferVirtPtr;     /* virtual pointer to buffer */

    struct ArBssInfo        *pOpBss;        /* Bss the frame belongs to. */
    void    *pKey;                          /* pointer to the key table entry
                                               for the frame */

   struct ArDesc  *pTxLastDesc;             /* pointer to the last descriptor
                                               of the frame in a transmit chain */
   struct ArDesc  *pTxFirstDesc;            /* pointer to the first descriptor
                                               of the frame in a transmit chain */


    A_UINT32            hwIndex;
    A_UINT32            staleFlag:1,        /* already processed holding descriptor */
                        swretryCount:4,     /* this desc is being swretried */
                        fragSeqNumValid:1,  /* set if we've already saved the seqNum in a frag train */
                        swRetryFlag:1,      /* set if this is a retransmit frame */
                        ffFlag:1,           /* frame being tx is fast frame */
                        ffSeqNum:11,        /* ffSeqNum of recd and buffered fast frame */
                        is4AddrFrm:1,       /* Is the Frame a 4 Address Frame */
                        isEthFrm:1,         /* Is the Ethernet Frame */
                        bIndicateXmitStatus,/* indicate the transmit status or not */
                        reserved:10;        /* reserved field */
   A_UINT32             timeStamp;          /* time stamp for PS aging in MS */

    /* software copies of hardware status filled in by the hal */
    union {
        AR_DESC_RX_STATUS rx;
        AR_DESC_TX_STATUS tx;
    } status;

    struct ArConnInfo   *pArConnInfo;       /* target connection info */
    TX_COOKIE           txCookie;           /* An opaque identifier for a
                                               particular tx request. */
} AR_DESC;

/* AR queue structure */
#define AR_BEACON_QUEUE      9
#define AR_MAX_QUEUES       10

typedef struct ArQueueInfo {
    A_SEM_TYPE          qSem;
    AR_DESC             *pDescQueueHead;     /* virt pointer to queue head */
    AR_DESC             *pDescQueueTail;     /* virtual pointer to queue tail */
    A_INT32              qFrameCount;        /* frame count in this queue */
    TXQ_ATTRIBUTES       wdc;
    int                  halTxQueueNum;
    A_BOOL               isTailSelfLinked;   /* should the tail descriptor be linked to itself? */
    A_BOOL               isDmaStopped;       /* has SW stopped the DMA HW? */
    A_BOOL               queuingBurst;       /* flag to indicate operations on a burst Q */
    A_BOOL               isCabQueue;
    A_INT32              qBurstCount;        /* counter for the pending burst seq */
    A_INT32              pendBFrameCount;    /* count of frames in pending Burst sequence */
    A_UINT32             burstCTSDur;        /* CTS duration for the being formed burst seq */
    AR_DESC             *pBurstHeadDesc;     /* frame desc  which is last one in a burst seq */
    AR_DESC             *pBurstTailDesc;     /* frame desc  which is first one in a burst seq */
    struct ArQueueInfo  *pStagingQueue;
} AR_QUEUE_INFO;


#define AR_DESC_INIT_SW_AREA(_pDesc)     do {                                \
    (_pDesc)->hwIndex         = HWINDEX_INVALID;                            \
    (_pDesc)->staleFlag       = 0;                                          \
    (_pDesc)->ffFlag          = 0;                                          \
    (_pDesc)->ffSeqNum        = 0;                                          \
    (_pDesc)->is4AddrFrm      = 0;                                          \
    (_pDesc)->isEthFrm        = 0;                                          \
    (_pDesc)->reserved        = 0;                                          \
    (_pDesc)->pTxFirstDesc    = NULL;                                       \
    (_pDesc)->pTxLastDesc     = NULL;                                       \
} while (0)

#define AR_FF_QUEUE_DRAIN(pDev, pQ)

#define AR_TX_DESC_CHAIN_FORMAT(_pDesc)  do {                               \
    AR_DESC *pTail = _pDesc;                                                \
    while (pTail->hw.txControl.more) {                                      \
        pTail->pTxFirstDesc = _pDesc;                                       \
        pTail = pTail->pNextVirtPtr;                                        \
        ASSERT(pTail);                                                      \
    }                                                                       \
    pTail->pTxFirstDesc = _pDesc;                                           \
    (_pDesc)->pTxLastDesc = pTail;                                          \
} while (0)

#define AR_2_ATHEROS(_pArDesc)       (ATHEROS_DESC *)(_pArDesc)


/* Function prototypes */

A_STATUS
arDescQInit(AR_QUEUE_INFO *pQueue);

AR_DESC *
arDescQGetHead(AR_QUEUE_INFO *pQueue);

AR_DESC *
arDescQGetTail(AR_QUEUE_INFO *pQueue);

AR_DESC *
arDescQPopHead(AR_QUEUE_INFO *pQueue);

void
arDescQPushTail(AR_QUEUE_INFO *pQueue, AR_DESC *pDesc, AR_DESC *pTail);

void
arDescQPushHead(AR_QUEUE_INFO *pQueue, AR_DESC *pDesc);

AR_DESC *
arMemAllocateDescriptor(AR_QUEUE_INFO *pQueue);

void
arMemFreeDescriptor(AR_QUEUE_INFO *pQueue, AR_DESC *pDesc);






#ifdef __cplusplus
}
#endif

#endif /* _ARDESC_H_ */

