/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arDev.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef _ARDEV_H
#define _ARDEV_H

#include "wdcApi.h"
#if defined(PCI_INTERFACE)
#include "arPci.h"
#endif /* PCI_INTERFACE */
#if !defined(SPLIT_ENFORCE)
#include "wlandrv.h"
#include "wlanchannel.h"
#endif /* SPLIT_ENFORCE */
#include "wdcMsg.h"
#include "arMsgApi.h"
#include "wdcTypes.h"
#include "wdcPriv.h"
#include "targPlatform.h"

#include "arBss.h"
#include "arConn.h"
#include "arDesc.h"
#include "arPhy.h"
#include "arPower.h"


#ifdef __cplusplus
extern "C" {
#endif


/* Number of (OEM-defined) functions using GPIO pins currently defined */
#define NUM_GPIO_FUNCS 1

/* WDC Event Management */
typedef struct {
    EVENT_HANDLER      *pHandler;
    void               *param;
} WDCEVT_MGMT;

typedef struct gpioFuncInfo {
    A_UINT32        enabled;     // function is enabled
    A_UINT32        pin;         // pin used by this function
    A_BOOL          state;       // current state of GPIO pin
    A_UINT32        timerParm;   // general purpose variable for timer routine
} GPIO_FUNC_INFO;

// Enums for various GPIO functions
typedef enum  {
    RECEIVE_EVENT,
    TRANSMIT_EVENT
} GPIO_FUNC1;

typedef struct ArDevInfo {
#if defined(PCI_INTERFACE)
    AR_PCI_INFO         pciInfo;
#else
    A_UINT32            WLANBaseAddr;
#endif
    MASTER_HANDLE       masterHandle;

    struct HalInfo         *pHalInfo;       // HW-dependent info
#if !defined(HAL_CODE_REDUCTION)
    const struct HwFuncs   *pHwFunc;        // HW-dependent calls
#endif
    AR_DEV_CAPABILITIES hwInfo;             // Hardware capabilities, determined
                                            // by hardware and governed by
                                            // EEPROM.  They may be communicated
                                            // to the Host through
                                            // wdcTargetGetCapability.

    AR_DEV_CONFIG       config;             // Target configuration attributes
                                            // may be initialized from EEPROM
                                            // or flash data, and may also be
                                            // supplied -- or overridden -- by
                                            // the Host.

    AR_BSS_INFO         bssTable[AR_MAX_BSS];
    AR_CONN_INFO        connTable[AR_MAX_CONN];
    AR_PWR_MGMT_INFO    powerMgmt;
    AR_STATS            devStats;           // Device Statistics

    // TX State Information
    A_CNTSEM_TYPE       txCompleteSem;      // Complete Count
    A_SEM_TYPE          txCompleteLock;     // Thread Lock USB <- TX COMPLETE
    A_SEM_TYPE          txMsgDispatchLock;  // Thread Lock for outgoing TX
    AR_QUEUE_INFO       txHwQueues[AR_MAX_QUEUES];
    TXQ_ATTRIBUTES      txQueueInfo[AR_MAX_QUEUES];
    A_UINT32            txQueueInitialized;
    A_CNTSEM_TYPE       txWaitDoneSem;    
    volatile A_BOOL     bTxEnabled;

    // RX State Information
    A_CNTSEM_TYPE       rxCompleteSem;      // RX Complete Count
    A_SEM_TYPE          rxCompleteLock;     // Thread Lock USB <- WLAN RX
    AR_QUEUE_INFO       rxHwQueue;
    A_BOOL              rxIsBeacon;         // RX in midst of receiving a beacon
    A_SEM_TYPE          pwrLock;         

    // Synchronization Sate
    A_CNTSEM_TYPE       dataDispatcherBarrier;
    A_CNTSEM_TYPE       ctrlDispatcherBarrier;
    volatile A_BOOL     txBarrierInProgress; // WDCMSG_FLUSH support
    A_BOOL              oneTimeInitDone;
    volatile A_BOOL     bTargetStarted;
    volatile A_BOOL     bRxEnabled;
    A_BOOL              bUSBPowerSave;
    A_SEM_TYPE          asyncEvtLock;       // Asynchronous Event Thread Lock

    // Rate State
    RATE_TABLE          *hwRateTable[WLAN_MODE_MAX];
    A_BOOL              curPrimeState;
    A_BOOL              primeInUse;

    AR_DEV_STATUS       devStatus;          // Hardware-independent run time
                                            // state for this device.
                                            // Items that may be of interest to 
                                            // the Host are put here, whereas
                                            // hardware state that is purely
                                            // for use by the target is 
                                            // elsewhere.
    A_UINT32            globISRReg;

    // Timer State
    A_HANDLE            rtcCounterHandle;
    A_TIMER             periodicCalTimer;
    A_TIMER             autoNoiseImmunityTimer;

    AR_ANI             *arCurrentAni;
    AR_ANI              arAniState[64];
    A_UINT32            arAniPeriod;
    A_INT32             arAniLastBeaconRssi;
    A_BOOL              arDoAni; 

    // Compression scratch buffers -- one for each TX queue
    // that supports compression.  Hardware constraints:
    // Each buffer must be large enough to hold
    // 2*MAX_FRAME_SZ+128 Bytes.  Each buffer must be a
    // multiple of 1KB in size.  Each buffer must be
    // 512Byte aligned.
    A_UINT32            physCompBuffers;    // physical address
    A_UINT32            virtCompBuffers;    // virtual address
    A_UINT32            compBufKbs;         // KBs per compression buffer

    GPIO_FUNC_INFO      gpioFunc[NUM_GPIO_FUNCS]; // Control struct for each GPIO pin
    A_BOOL              connectStatus;
    A_UINT32            ledTimerState;
} AR_DEV_INFO;

enum {
    TIMER_STOPPED,
    TIMER_FUNC_QUEUED,
    TIMER_FUNC_RUNNING,
    TIMER_FUNC_CANCELLED,
};

typedef AR_DEV_INFO *DEVICE_HANDLE;

#define TURBO_MODE              1
#define BASE_MODE               0

/* Convenience macros */
#define TransmitBusy        devStatus.s_TransmitBusy
#define invalidTxChannel    devStatus.s_invalidTxChannel
#define phyActivityFlag     devStatus.s_phyActivityFlag
#define noApActivity        devStatus.s_noApActivity
#define phyHwLastRssi       devStatus.s_phyHwLastRssi
#define psFramesDropped     devStatus.s_psFramesDropped
#define nonErpPreamble      devStatus.s_nonErpPreamble
#define protectOn           devStatus.s_protectOn
#define protectRateIdx      devStatus.s_protectRateIdx
#define MaskReg             devStatus.s_MaskReg
#define rxFilterReg         devStatus.s_rxFilterReg
#define cachedDefAnt        devStatus.s_cachedDefAnt
#define countOtherRxAnt     devStatus.s_countOtherRxAnt
#define useFastDiversity    devStatus.s_useFastDiversity
#define RxGenerationNum     devStatus.s_RxGenerationNum

#define noiseFloor          devStats.noiseFloor
#define tx6PowerInHalfDbm   devStats.tx6PowerInHalfDbm
#define maxTxPowerAvail     devStats.maxTxPowerAvail

/*******************************************************************************
 * Useful macros
 */
#if !defined(isXrAp)
#if defined(BUILD_AP)
#define isXrAp(pArDev)                  (((pArDev)->.configabolt & ABOLT_XR))
#else
#define isXrAp(pArDev)                  0
#endif
#endif

#define CURRENT_PCHDESC(pArDev)      (&(pArDev)->config.chanDesc)
#define CURRENT_WLAN_MODE(pArDev)    ((pArDev)->config.chanDesc.wlanMode)
#define CURRENT_FREQ(pArDev)         ((pArDev)->config.chanDesc.channelFreq)
#define CURRENT_SERVICE_TYPE(pArDev) ((pArDev)->config.serviceType)

#define CHAN_IS_G(pChDesc)     ((pChDesc)->wlanMode == WLAN_MODE_11g)
#define CHAN_IS_CCK(pChDesc)   ((pChDesc)->phyModulations & PHY_MOD_CCK)
#define CHAN_IS_OFDM(pChDesc)  ((pChDesc)->phyModulations & PHY_MOD_OFDM)
#define CHAN_IS_XR(pChDesc)    ((pChDesc)->phyModulations & PHY_MOD_XR)
#define CHAN_IS_TURBO(pChDesc) ((pChDesc)->phyModulations & PHY_MOD_TURBO)
#define CHAN_IS_2GHZ(pChDesc)  ((pChDesc)->channelBand == CHANNEL_BAND_2GHz)
#define CHAN_IS_5GHZ(pChDesc)  ((pChDesc)->channelBand == CHANNEL_BAND_5GHz)
#define CHAN_IS_108G(pChDesc)  (CHAN_IS_2GHZ(pChDesc) &&          \
                               (((pChDesc)->phyModulations &      \
                               (PHY_MOD_TURBO | PHY_MOD_OFDM)) == \
                                (PHY_MOD_TURBO | PHY_MOD_OFDM)))


#if defined(ECOS_NOTDONE)
typedef AR_DEV_INFO WLAN_DEV_INFO;
#define HACK_TO_PDEV(pArDev) (WLAN_DEV_INFO *) pArDev
#define HACK_TO_PARDEV(pArDev) (AR_DEV_INFO *) pArDev
#endif


#define AR_UPDATE_DEV_STATS(pDevStats, field, updateVal) \
{   \
  (pDevStats)->field += (updateVal);   \
}

#if defined(NO_CONN_STATS)
#define AR_UPDATE_STATS(pDevStats, pConnStats, field, updateVal) \
    AR_UPDATE_DEV_STATS(pDevStats, field, updateVal)

#else
#define AR_UPDATE_STATS(pDevStats, pConnStats, field, updateVal) \
{   \
  AR_UPDATE_DEV_STATS(pDevStats, field, updateVal);   \
  AR_UPDATE_DEV_STATS(pConnStats, field, updateVal);   \
}
#endif



/*******************************************************************************
 * Register read/write APIs on the AR Device
 */

#if defined(PCI_INTERFACE)
/*
 * This is to ensure that our chip is awake before accessing registers
 * which aren't in the PCI clock domain i.e. 0x4000-0x6000. The s/w
 * state machines should preclude such accesses - and thus this assert.
 * The corresponding register values being touched are hacked in here
 * since they aren't expected to be visible at this level.
 * #define MAC_PCICFG           0x4010
 * #define MAC_PCICFG_SPWR_DN   0x00010000
 * #define PHY_CHIP_ID          0x9818
 */
static INLINE void
_arAssertChipAwake(AR_DEV_INFO *pArDev, A_UINT32 reg)
{
#ifdef DEBUG
    if (pArDev->hwInfo.phyRevision && ((reg < 0x4000) || (reg >= 0x6000))) {
        volatile A_UINT32 val;
        val = A_PCI_REG_RD(&pArDev->pciInfo, 0x4010);
        if (val & 0x00010000) {
            val = A_PCI_REG_RD(&pArDev->pciInfo, 0x9818);
            ASSERT(val == pArDev->hwInfo.phyRevision);
        }
    }
#endif
}

static INLINE A_UINT32
_arReadPlatformReg(AR_DEV_INFO *pArDev, A_UINT32 reg)
{
    _arAssertChipAwake(pArDev, reg);
    return A_PCI_REG_RD(&pArDev->pciInfo, reg);
}

static INLINE void
_arWritePlatformReg(AR_DEV_INFO *pArDev, A_UINT32 reg, A_UINT32 val)
{
    _arAssertChipAwake(pArDev, reg);
    A_PCI_REG_WR(&pArDev->pciInfo, reg, val);
}

#define A_REG_RD(pd, off)       _arReadPlatformReg(pd, off)
#define A_REG_WR(pd, off, val)  _arWritePlatformReg(pd, off, val)

#else
/*
 * WLAN registers are memory-mapped into the address space
 * and must be accessed through A_REG_RD and A_REG_WR.
 */
#define A_REG_RD(pArDev, off) \
    (*(volatile A_UINT32 *)((pArDev)->WLANBaseAddr+(off)))

#define A_REG_WR(pArDev, off, val) \
        *((volatile A_UINT32 *)((pArDev)->WLANBaseAddr+(off))) = (val)

/*
 * WiSoC configuration registers are accessed through A_CFG_RD.
 *
 * The current implementation supports at most one device,
 * so the "offset" is really a full virtual address, and
 * we simply ignore the first parameter.  If we ever support
 * multiple devices (or configuration spaces), we'll modify
 * this to use an actual offset from a configuration base
 * stored in pArDev.
 */
#define A_CFG_RD(pArDev, off) (*(volatile A_UINT32 *)(off))

#endif /* PCI_INTERFACE */

#define readPlatformReg         A_REG_RD    // some old-style code
#define writePlatformReg        A_REG_WR    // some old-style code

#define A_REG_RD_FIELD_LONG(pd, off, m, s) \
        ((A_REG_RD(pd, off) & (m)) >> (s))
#define A_REG_RD_FIELD(pd, off, field) \
        (A_REG_RD_FIELD_LONG(pd, off, off##_##field##_M, off##_##field##_S))
#define A_REG_WR_FIELD_LONG(pd, off, m, s, val) \
        (A_REG_WR(pd, off, ((val) << (s)) & (m)))
#define A_REG_WR_FIELD(pd, off, field, val) \
        (A_REG_WR_FIELD_LONG(pd, off, off##_##field##_M, off##_##field##_S, val))
#define A_REG_RMW(pd, off, set, clr)    \
        (A_REG_WR(pd, off, (A_REG_RD(pd, off) & ~(clr)) | (set)))
#define A_REG_RMW_FIELD_LONG(pd, off, m, s, val) \
        (A_REG_WR(pd, off, (A_REG_RD(pd, off) & ~(m)) | (((val) << (s)) & (m))))
#define A_REG_RMW_FIELD(pd, off, field, val) \
        (A_REG_RMW_FIELD_LONG(pd, off, off##_##field##_M, off##_##field##_S, val))
#define A_REG_SET_BIT(pd, off, bitname) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) | off##_##bitname))
#define A_REG_SET_BIT2(pd, off, b1, b2) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) | off##_##b1 | off##_##b2))
#define A_REG_SET_BIT3(pd, off, b1, b2, b3) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) | off##_##b1 | off##_##b2 | off##_##b3))
#define A_REG_SET_BIT4(pd, off, b1, b2, b3, b4) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) | off##_##b1 | off##_##b2 | off##_##b3 | off##_##b4))
#define A_REG_CLR_BIT(pd, off, bitname) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) & ~off##_##bitname))
#define A_REG_CLR_BIT2(pd, off, b1, b2) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) & ~(off##_##b1 | off##_##b2)))
#define A_REG_CLR_BIT3(pd, off, b1, b2, b3) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) & ~(off##_##b1 | off##_##b2 | off##_##b3)))
#define A_REG_CLR_BIT4(pd, off, b1, b2, b3, b4) \
        (A_REG_WR(pd, off, A_REG_RD(pd, off) & ~(off##_##b1 | off##_##b2 | off##_##b3 | off##_##b4)))
#define A_REG_IS_BIT_SET(pd, off, bitname) \
        ((A_REG_RD(pd, off) & off##_##bitname) ? TRUE : FALSE)
#define A_FIELD_VALUE(off, field, val) \
        (((val) << off##_##field##_S) & off##_##field##_M)


#ifdef __cplusplus
}
#endif

#endif /* _ARDEV_H_ */
