/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arEvent.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef __TARGEVENT_H__
#define __TARGEVENT_H__

#ifdef __cplusplus
extern "C" {
#endif


A_STATUS
TARG_wdcAsyncEvtDispatchInit(
    MASTER_HANDLE masterHandle
); 


A_STATUS
TARG_wdcAsyncEvtEnqueue(
    IN MASTER_HANDLE  masterHandle,
    IN A_UINT32       event,
    IN void          *pOpaque,
    IN A_BOOL         bWait
);

void 
TARG_wdcAsyncEvtFlushqueue(
    AR_DEV_INFO     *pArDev
);


#if defined(ECOS)
A_UINT32
ar_wmac_isr(
    A_UINT32 IntVector, 
    A_UINT32 intrHandle
);

void
ar_wmac_dsr(
    A_UINT32 IntVector, 
    A_UINT32 IntCount,
    A_UINT32 intrHandle
);
#endif

typedef enum {
    AREVT_PERIODIC_CAL = WDCEVT_MAX+1,
    AREVT_PERIODIC_ANI,
//  ...
    AREVT_MAX
} AR_EVENT;


#define arNotifyDeviceAvailable(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, WDCEVT_DEVICE_AVAILABLE,   \
                            NULL, TRUE)

#define arNotifyDeviceUnavailable(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, WDCEVT_DEVICE_UNAVAILABLE, \
                            NULL, TRUE)

#define arNotifyBeaconMiss(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, WDCEVT_BEACON_MISS,        \
                            NULL, FALSE)

#define arNotifyPeriodicCal(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, AREVT_PERIODIC_CAL,        \
                            NULL, FALSE)

#define arNotifyPeriodicAni(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, AREVT_PERIODIC_ANI,        \
                            NULL, FALSE)

#define arNotifyDeviceStats(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, WDCEVT_WLAN_STATS_UPDATE,  \
                            NULL, FALSE)

#define arNotifyConnStats(masterHandle) \
    TARG_wdcAsyncEvtEnqueue(masterHandle, WDCEVT_CONNECTION_STATS_UPDATE,  \
                            NULL, FALSE)

#define arStopEvents(pArDev) \
    A_SEM_LOCK(pArDev->asyncEvtLock, WAIT_FOREVER)

#define arStartEvents(pArDev) \
    A_SEM_UNLOCK(pArDev->asyncEvtLock)


#ifdef __cplusplus
}
#endif

#endif
