
/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arMsgApi.h#3 $
 *
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 */

/* Target-side WDC Message interface */

#ifndef __INC_ARMSGAPI_H
#define __INC_ARMSGAPI_H


struct master_msg_info; /* opaque */
typedef struct master_msg_info *MASTER_MSG_HANDLE;

struct per_master_info;
typedef struct per_master_info *MASTER_HANDLE;

extern MASTER_MSG_HANDLE TARG_wdcMsgInit(MASTER_HANDLE masterHandle);
extern void TARGET_wdcMsgFini(MASTER_MSG_HANDLE masterMsgHandle);

extern WDC_MSG * TARG_wdcCtrlMsgCreate(MASTER_MSG_HANDLE masterMsgHandle,
                                       WDC_MSG_OPCODE msgOpcode);

extern void TARG_wdcCtrlMsgDestroy(MASTER_MSG_HANDLE masterMsgHandle, WDC_MSG *wdcMsg);

extern void TARG_wdcMsgAddParam(WDC_MSG *wdcMsg, A_UINT32 param);
extern void TARG_wdcMsgAddData(WDC_MSG *wdcMsg, A_UINT32 length, void *data);
extern void TARG_wdcMsgPrepData(WDC_MSG *wdcMsg, void **pData,
                                A_UINT32 *maxLength);
extern void TARG_wdcMsgCommitData(WDC_MSG *wdcMsg, A_UINT32 length);

extern A_STATUS TARG_wdcCtrlMsgSend(MASTER_MSG_HANDLE masterMsgHandle,
                                    WDC_MSG *wdcMsg);

extern A_STATUS TARG_wdcRxMsgSend(MASTER_MSG_HANDLE masterMsgHandle,
                                  WDC_RXMSG *rxMsg);

extern void TARG_wdcDataMsgRecv(WDC_TXMSG *txMsg);

/*
 * A "cursor" is used when reading incoming messages.  The cursor indicates
 * our current position in the message, and is updated after each read.  It
 * should be initialized to 0 in order to read the first parameter from
 * a message.
 */
typedef A_UINT32 WDC_MSG_CURSOR;

extern void TARG_wdcMsgReadParam(WDC_MSG *wdcMsg, WDC_MSG_CURSOR *pCursor,
                                 A_UINT32 *pParam);

extern void TARG_wdcMsgReadData(WDC_MSG *wdcMsg, WDC_MSG_CURSOR *pCursor,
                                A_UINT32 *plength, void *pData);

extern void TARG_wdcMsgSeekData(WDC_MSG *wdcMsg, WDC_MSG_CURSOR *pCursor,
                                void **ppData);

extern void TARG_wdcMsgConsumeData(WDC_MSG *wdcMsg, WDC_MSG_CURSOR *pCursor,
                                   A_UINT32 length);

/* For WDCMSG_FLUSH */
extern A_CNTSEM_TYPE dataDispatcherBarrier;
extern A_CNTSEM_TYPE ctrlDispatcherBarrier;


/*
 * Reflect msgId from the incoming message back in the
 * response message.
 */
#define REFLECT_MSG_ID(wdcMsg, responseMsg)      \
do {                                             \
    (responseMsg)->msgId = (wdcMsg)->msgId;      \
} while(0)

#if defined(WDC_TARGET_DEBUG)
/*
 * Reflect msgDebug data from the incoming message back in the
 * response message.
 */
#define REFLECT_MSG_DEBUG(wdcMsg, responseMsg)                \
do {                                                          \
    int i;                                                    \
    for (i=0; i< WDC_CTRL_MSG_DEBUG_CNT; i++) {               \
        (responseMsg)->msgDebug[i] = (wdcMsg)->msgDebug[i];   \
    }                                                         \
} while(0)
#else
#define REFLECT_MSG_DEBUG(wdcMsg, responseMsg)
#endif

#endif /* __INC_ARMSGAPI_H */
