/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/target/include/arPci.h#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef _ARPCI_H
#define _ARPCI_H

#include "athPlatform.h"

#ifdef __cplusplus
extern "C" {
#endif

#if defined(PCI_INTERFACE)

typedef struct ArPciInfo {
    A_UINT32    baseAddr;
    A_UINT16    DeviceId;
} AR_PCI_INFO;


A_STATUS
arPciAttach(
    AR_PCI_INFO *pPciInfo,
    A_UINT32    deviceContext
);


/*******************************************************************************
 * Register read/write APIs on the PCI Device
 */

#define A_PCI_REG_RD(_p, _off)                      \
    sysPciRead32((_p)->baseAddr + (_off))
#define A_PCI_REG_WR(_p, _off, _val)                \
    sysPciWrite32((_p)->baseAddr + (_off), _val)

#else
#error "arPci.h SHOULD NOT BE INCLUDED"
#endif /* PCI_INTERFACE */

#ifdef __cplusplus
}
#endif

#endif /* _ARPCI_H_ */

